// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPublickeyCollectionGetParams creates a new PublickeyCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPublickeyCollectionGetParams() *PublickeyCollectionGetParams {
	return &PublickeyCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPublickeyCollectionGetParamsWithTimeout creates a new PublickeyCollectionGetParams object
// with the ability to set a timeout on a request.
func NewPublickeyCollectionGetParamsWithTimeout(timeout time.Duration) *PublickeyCollectionGetParams {
	return &PublickeyCollectionGetParams{
		timeout: timeout,
	}
}

// NewPublickeyCollectionGetParamsWithContext creates a new PublickeyCollectionGetParams object
// with the ability to set a context for a request.
func NewPublickeyCollectionGetParamsWithContext(ctx context.Context) *PublickeyCollectionGetParams {
	return &PublickeyCollectionGetParams{
		Context: ctx,
	}
}

// NewPublickeyCollectionGetParamsWithHTTPClient creates a new PublickeyCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPublickeyCollectionGetParamsWithHTTPClient(client *http.Client) *PublickeyCollectionGetParams {
	return &PublickeyCollectionGetParams{
		HTTPClient: client,
	}
}

/*
PublickeyCollectionGetParams contains all the parameters to send to the API endpoint

	for the publickey collection get operation.

	Typically these are written to a http.Request.
*/
type PublickeyCollectionGetParams struct {

	/* AccountName.

	   Filter by account.name
	*/
	AccountName *string

	/* Certificate.

	   Filter by certificate
	*/
	Certificate *string

	/* CertificateDetails.

	   Filter by certificate_details
	*/
	CertificateDetails *string

	/* CertificateExpired.

	   Filter by certificate_expired
	*/
	CertificateExpired *string

	/* CertificateRevoked.

	   Filter by certificate_revoked
	*/
	CertificateRevoked *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* ObfuscatedFingerprint.

	   Filter by obfuscated_fingerprint
	*/
	ObfuscatedFingerprint *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* PublicKey.

	   Filter by public_key
	*/
	PublicKey *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* ShaFingerprint.

	   Filter by sha_fingerprint
	*/
	ShaFingerprint *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the publickey collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PublickeyCollectionGetParams) WithDefaults() *PublickeyCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the publickey collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PublickeyCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := PublickeyCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithTimeout(timeout time.Duration) *PublickeyCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithContext(ctx context.Context) *PublickeyCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithHTTPClient(client *http.Client) *PublickeyCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithAccountName(accountName *string) *PublickeyCollectionGetParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetAccountName(accountName *string) {
	o.AccountName = accountName
}

// WithCertificate adds the certificate to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithCertificate(certificate *string) *PublickeyCollectionGetParams {
	o.SetCertificate(certificate)
	return o
}

// SetCertificate adds the certificate to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetCertificate(certificate *string) {
	o.Certificate = certificate
}

// WithCertificateDetails adds the certificateDetails to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithCertificateDetails(certificateDetails *string) *PublickeyCollectionGetParams {
	o.SetCertificateDetails(certificateDetails)
	return o
}

// SetCertificateDetails adds the certificateDetails to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetCertificateDetails(certificateDetails *string) {
	o.CertificateDetails = certificateDetails
}

// WithCertificateExpired adds the certificateExpired to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithCertificateExpired(certificateExpired *string) *PublickeyCollectionGetParams {
	o.SetCertificateExpired(certificateExpired)
	return o
}

// SetCertificateExpired adds the certificateExpired to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetCertificateExpired(certificateExpired *string) {
	o.CertificateExpired = certificateExpired
}

// WithCertificateRevoked adds the certificateRevoked to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithCertificateRevoked(certificateRevoked *string) *PublickeyCollectionGetParams {
	o.SetCertificateRevoked(certificateRevoked)
	return o
}

// SetCertificateRevoked adds the certificateRevoked to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetCertificateRevoked(certificateRevoked *string) {
	o.CertificateRevoked = certificateRevoked
}

// WithComment adds the comment to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithComment(comment *string) *PublickeyCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithFields adds the fields to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithFields(fields []string) *PublickeyCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIndex adds the index to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithIndex(index *int64) *PublickeyCollectionGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetIndex(index *int64) {
	o.Index = index
}

// WithMaxRecords adds the maxRecords to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithMaxRecords(maxRecords *int64) *PublickeyCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithObfuscatedFingerprint adds the obfuscatedFingerprint to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithObfuscatedFingerprint(obfuscatedFingerprint *string) *PublickeyCollectionGetParams {
	o.SetObfuscatedFingerprint(obfuscatedFingerprint)
	return o
}

// SetObfuscatedFingerprint adds the obfuscatedFingerprint to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetObfuscatedFingerprint(obfuscatedFingerprint *string) {
	o.ObfuscatedFingerprint = obfuscatedFingerprint
}

// WithOrderBy adds the orderBy to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithOrderBy(orderBy []string) *PublickeyCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwnerName adds the ownerName to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithOwnerName(ownerName *string) *PublickeyCollectionGetParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithOwnerUUID(ownerUUID *string) *PublickeyCollectionGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithPublicKey adds the publicKey to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithPublicKey(publicKey *string) *PublickeyCollectionGetParams {
	o.SetPublicKey(publicKey)
	return o
}

// SetPublicKey adds the publicKey to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetPublicKey(publicKey *string) {
	o.PublicKey = publicKey
}

// WithReturnRecords adds the returnRecords to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithReturnRecords(returnRecords *bool) *PublickeyCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *PublickeyCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithScope(scope *string) *PublickeyCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithShaFingerprint adds the shaFingerprint to the publickey collection get params
func (o *PublickeyCollectionGetParams) WithShaFingerprint(shaFingerprint *string) *PublickeyCollectionGetParams {
	o.SetShaFingerprint(shaFingerprint)
	return o
}

// SetShaFingerprint adds the shaFingerprint to the publickey collection get params
func (o *PublickeyCollectionGetParams) SetShaFingerprint(shaFingerprint *string) {
	o.ShaFingerprint = shaFingerprint
}

// WriteToRequest writes these params to a swagger request
func (o *PublickeyCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccountName != nil {

		// query param account.name
		var qrAccountName string

		if o.AccountName != nil {
			qrAccountName = *o.AccountName
		}
		qAccountName := qrAccountName
		if qAccountName != "" {

			if err := r.SetQueryParam("account.name", qAccountName); err != nil {
				return err
			}
		}
	}

	if o.Certificate != nil {

		// query param certificate
		var qrCertificate string

		if o.Certificate != nil {
			qrCertificate = *o.Certificate
		}
		qCertificate := qrCertificate
		if qCertificate != "" {

			if err := r.SetQueryParam("certificate", qCertificate); err != nil {
				return err
			}
		}
	}

	if o.CertificateDetails != nil {

		// query param certificate_details
		var qrCertificateDetails string

		if o.CertificateDetails != nil {
			qrCertificateDetails = *o.CertificateDetails
		}
		qCertificateDetails := qrCertificateDetails
		if qCertificateDetails != "" {

			if err := r.SetQueryParam("certificate_details", qCertificateDetails); err != nil {
				return err
			}
		}
	}

	if o.CertificateExpired != nil {

		// query param certificate_expired
		var qrCertificateExpired string

		if o.CertificateExpired != nil {
			qrCertificateExpired = *o.CertificateExpired
		}
		qCertificateExpired := qrCertificateExpired
		if qCertificateExpired != "" {

			if err := r.SetQueryParam("certificate_expired", qCertificateExpired); err != nil {
				return err
			}
		}
	}

	if o.CertificateRevoked != nil {

		// query param certificate_revoked
		var qrCertificateRevoked string

		if o.CertificateRevoked != nil {
			qrCertificateRevoked = *o.CertificateRevoked
		}
		qCertificateRevoked := qrCertificateRevoked
		if qCertificateRevoked != "" {

			if err := r.SetQueryParam("certificate_revoked", qCertificateRevoked); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.ObfuscatedFingerprint != nil {

		// query param obfuscated_fingerprint
		var qrObfuscatedFingerprint string

		if o.ObfuscatedFingerprint != nil {
			qrObfuscatedFingerprint = *o.ObfuscatedFingerprint
		}
		qObfuscatedFingerprint := qrObfuscatedFingerprint
		if qObfuscatedFingerprint != "" {

			if err := r.SetQueryParam("obfuscated_fingerprint", qObfuscatedFingerprint); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.PublicKey != nil {

		// query param public_key
		var qrPublicKey string

		if o.PublicKey != nil {
			qrPublicKey = *o.PublicKey
		}
		qPublicKey := qrPublicKey
		if qPublicKey != "" {

			if err := r.SetQueryParam("public_key", qPublicKey); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.ShaFingerprint != nil {

		// query param sha_fingerprint
		var qrShaFingerprint string

		if o.ShaFingerprint != nil {
			qrShaFingerprint = *o.ShaFingerprint
		}
		qShaFingerprint := qrShaFingerprint
		if qShaFingerprint != "" {

			if err := r.SetQueryParam("sha_fingerprint", qShaFingerprint); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPublickeyCollectionGet binds the parameter fields
func (o *PublickeyCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamPublickeyCollectionGet binds the parameter order_by
func (o *PublickeyCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
