// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPublickeyGetParams creates a new PublickeyGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPublickeyGetParams() *PublickeyGetParams {
	return &PublickeyGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPublickeyGetParamsWithTimeout creates a new PublickeyGetParams object
// with the ability to set a timeout on a request.
func NewPublickeyGetParamsWithTimeout(timeout time.Duration) *PublickeyGetParams {
	return &PublickeyGetParams{
		timeout: timeout,
	}
}

// NewPublickeyGetParamsWithContext creates a new PublickeyGetParams object
// with the ability to set a context for a request.
func NewPublickeyGetParamsWithContext(ctx context.Context) *PublickeyGetParams {
	return &PublickeyGetParams{
		Context: ctx,
	}
}

// NewPublickeyGetParamsWithHTTPClient creates a new PublickeyGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPublickeyGetParamsWithHTTPClient(client *http.Client) *PublickeyGetParams {
	return &PublickeyGetParams{
		HTTPClient: client,
	}
}

/*
PublickeyGetParams contains all the parameters to send to the API endpoint

	for the publickey get operation.

	Typically these are written to a http.Request.
*/
type PublickeyGetParams struct {

	/* AccountName.

	   User account name
	*/
	AccountName string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Index.

	   Index number for the public key (where there are multiple keys for the same account).
	*/
	Index int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OwnerUUID.

	   Account owner UUID
	*/
	OwnerUUID string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the publickey get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PublickeyGetParams) WithDefaults() *PublickeyGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the publickey get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PublickeyGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := PublickeyGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the publickey get params
func (o *PublickeyGetParams) WithTimeout(timeout time.Duration) *PublickeyGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the publickey get params
func (o *PublickeyGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the publickey get params
func (o *PublickeyGetParams) WithContext(ctx context.Context) *PublickeyGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the publickey get params
func (o *PublickeyGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the publickey get params
func (o *PublickeyGetParams) WithHTTPClient(client *http.Client) *PublickeyGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the publickey get params
func (o *PublickeyGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the publickey get params
func (o *PublickeyGetParams) WithAccountName(accountName string) *PublickeyGetParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the publickey get params
func (o *PublickeyGetParams) SetAccountName(accountName string) {
	o.AccountName = accountName
}

// WithFields adds the fields to the publickey get params
func (o *PublickeyGetParams) WithFields(fields []string) *PublickeyGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the publickey get params
func (o *PublickeyGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIndex adds the index to the publickey get params
func (o *PublickeyGetParams) WithIndex(index int64) *PublickeyGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the publickey get params
func (o *PublickeyGetParams) SetIndex(index int64) {
	o.Index = index
}

// WithMaxRecords adds the maxRecords to the publickey get params
func (o *PublickeyGetParams) WithMaxRecords(maxRecords *int64) *PublickeyGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the publickey get params
func (o *PublickeyGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the publickey get params
func (o *PublickeyGetParams) WithOrderBy(orderBy []string) *PublickeyGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the publickey get params
func (o *PublickeyGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwnerUUID adds the ownerUUID to the publickey get params
func (o *PublickeyGetParams) WithOwnerUUID(ownerUUID string) *PublickeyGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the publickey get params
func (o *PublickeyGetParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the publickey get params
func (o *PublickeyGetParams) WithReturnRecords(returnRecords *bool) *PublickeyGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the publickey get params
func (o *PublickeyGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the publickey get params
func (o *PublickeyGetParams) WithReturnTimeout(returnTimeout *int64) *PublickeyGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the publickey get params
func (o *PublickeyGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *PublickeyGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param account.name
	if err := r.SetPathParam("account.name", o.AccountName); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param index
	if err := r.SetPathParam("index", swag.FormatInt64(o.Index)); err != nil {
		return err
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPublickeyGet binds the parameter fields
func (o *PublickeyGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamPublickeyGet binds the parameter order_by
func (o *PublickeyGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
