// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PublickeyGetReader is a Reader for the PublickeyGet structure.
type PublickeyGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PublickeyGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPublickeyGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPublickeyGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPublickeyGetOK creates a PublickeyGetOK with default headers values
func NewPublickeyGetOK() *PublickeyGetOK {
	return &PublickeyGetOK{}
}

/*
PublickeyGetOK describes a response with status code 200, with default header values.

OK
*/
type PublickeyGetOK struct {
	Payload *models.Publickey
}

// IsSuccess returns true when this publickey get o k response has a 2xx status code
func (o *PublickeyGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this publickey get o k response has a 3xx status code
func (o *PublickeyGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this publickey get o k response has a 4xx status code
func (o *PublickeyGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this publickey get o k response has a 5xx status code
func (o *PublickeyGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this publickey get o k response a status code equal to that given
func (o *PublickeyGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the publickey get o k response
func (o *PublickeyGetOK) Code() int {
	return 200
}

func (o *PublickeyGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}][%d] publickeyGetOK %s", 200, payload)
}

func (o *PublickeyGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}][%d] publickeyGetOK %s", 200, payload)
}

func (o *PublickeyGetOK) GetPayload() *models.Publickey {
	return o.Payload
}

func (o *PublickeyGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Publickey)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPublickeyGetDefault creates a PublickeyGetDefault with default headers values
func NewPublickeyGetDefault(code int) *PublickeyGetDefault {
	return &PublickeyGetDefault{
		_statusCode: code,
	}
}

/*
PublickeyGetDefault describes a response with status code -1, with default header values.

Error
*/
type PublickeyGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this publickey get default response has a 2xx status code
func (o *PublickeyGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this publickey get default response has a 3xx status code
func (o *PublickeyGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this publickey get default response has a 4xx status code
func (o *PublickeyGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this publickey get default response has a 5xx status code
func (o *PublickeyGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this publickey get default response a status code equal to that given
func (o *PublickeyGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the publickey get default response
func (o *PublickeyGetDefault) Code() int {
	return o._statusCode
}

func (o *PublickeyGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}][%d] publickey_get default %s", o._statusCode, payload)
}

func (o *PublickeyGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}][%d] publickey_get default %s", o._statusCode, payload)
}

func (o *PublickeyGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PublickeyGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
