// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPublickeyModifyCollectionParams creates a new PublickeyModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPublickeyModifyCollectionParams() *PublickeyModifyCollectionParams {
	return &PublickeyModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPublickeyModifyCollectionParamsWithTimeout creates a new PublickeyModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewPublickeyModifyCollectionParamsWithTimeout(timeout time.Duration) *PublickeyModifyCollectionParams {
	return &PublickeyModifyCollectionParams{
		timeout: timeout,
	}
}

// NewPublickeyModifyCollectionParamsWithContext creates a new PublickeyModifyCollectionParams object
// with the ability to set a context for a request.
func NewPublickeyModifyCollectionParamsWithContext(ctx context.Context) *PublickeyModifyCollectionParams {
	return &PublickeyModifyCollectionParams{
		Context: ctx,
	}
}

// NewPublickeyModifyCollectionParamsWithHTTPClient creates a new PublickeyModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewPublickeyModifyCollectionParamsWithHTTPClient(client *http.Client) *PublickeyModifyCollectionParams {
	return &PublickeyModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
PublickeyModifyCollectionParams contains all the parameters to send to the API endpoint

	for the publickey modify collection operation.

	Typically these are written to a http.Request.
*/
type PublickeyModifyCollectionParams struct {

	/* AccountName.

	   Filter by account.name
	*/
	AccountName *string

	/* Certificate.

	   Filter by certificate
	*/
	Certificate *string

	/* CertificateDetails.

	   Filter by certificate_details
	*/
	CertificateDetails *string

	/* CertificateExpired.

	   Filter by certificate_expired
	*/
	CertificateExpired *string

	/* CertificateRevoked.

	   Filter by certificate_revoked
	*/
	CertificateRevoked *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* Info.

	   Info specification
	*/
	Info PublickeyModifyCollectionBody

	/* ObfuscatedFingerprint.

	   Filter by obfuscated_fingerprint
	*/
	ObfuscatedFingerprint *string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* PublicKey.

	   Filter by public_key
	*/
	PublicKey *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* ShaFingerprint.

	   Filter by sha_fingerprint
	*/
	ShaFingerprint *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the publickey modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PublickeyModifyCollectionParams) WithDefaults() *PublickeyModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the publickey modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PublickeyModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := PublickeyModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithTimeout(timeout time.Duration) *PublickeyModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithContext(ctx context.Context) *PublickeyModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithHTTPClient(client *http.Client) *PublickeyModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccountName adds the accountName to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithAccountName(accountName *string) *PublickeyModifyCollectionParams {
	o.SetAccountName(accountName)
	return o
}

// SetAccountName adds the accountName to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetAccountName(accountName *string) {
	o.AccountName = accountName
}

// WithCertificate adds the certificate to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithCertificate(certificate *string) *PublickeyModifyCollectionParams {
	o.SetCertificate(certificate)
	return o
}

// SetCertificate adds the certificate to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetCertificate(certificate *string) {
	o.Certificate = certificate
}

// WithCertificateDetails adds the certificateDetails to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithCertificateDetails(certificateDetails *string) *PublickeyModifyCollectionParams {
	o.SetCertificateDetails(certificateDetails)
	return o
}

// SetCertificateDetails adds the certificateDetails to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetCertificateDetails(certificateDetails *string) {
	o.CertificateDetails = certificateDetails
}

// WithCertificateExpired adds the certificateExpired to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithCertificateExpired(certificateExpired *string) *PublickeyModifyCollectionParams {
	o.SetCertificateExpired(certificateExpired)
	return o
}

// SetCertificateExpired adds the certificateExpired to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetCertificateExpired(certificateExpired *string) {
	o.CertificateExpired = certificateExpired
}

// WithCertificateRevoked adds the certificateRevoked to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithCertificateRevoked(certificateRevoked *string) *PublickeyModifyCollectionParams {
	o.SetCertificateRevoked(certificateRevoked)
	return o
}

// SetCertificateRevoked adds the certificateRevoked to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetCertificateRevoked(certificateRevoked *string) {
	o.CertificateRevoked = certificateRevoked
}

// WithComment adds the comment to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithComment(comment *string) *PublickeyModifyCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *PublickeyModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithIndex adds the index to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithIndex(index *int64) *PublickeyModifyCollectionParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetIndex(index *int64) {
	o.Index = index
}

// WithInfo adds the info to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithInfo(info PublickeyModifyCollectionBody) *PublickeyModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetInfo(info PublickeyModifyCollectionBody) {
	o.Info = info
}

// WithObfuscatedFingerprint adds the obfuscatedFingerprint to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithObfuscatedFingerprint(obfuscatedFingerprint *string) *PublickeyModifyCollectionParams {
	o.SetObfuscatedFingerprint(obfuscatedFingerprint)
	return o
}

// SetObfuscatedFingerprint adds the obfuscatedFingerprint to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetObfuscatedFingerprint(obfuscatedFingerprint *string) {
	o.ObfuscatedFingerprint = obfuscatedFingerprint
}

// WithOwnerName adds the ownerName to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithOwnerName(ownerName *string) *PublickeyModifyCollectionParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithOwnerUUID(ownerUUID *string) *PublickeyModifyCollectionParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithPublicKey adds the publicKey to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithPublicKey(publicKey *string) *PublickeyModifyCollectionParams {
	o.SetPublicKey(publicKey)
	return o
}

// SetPublicKey adds the publicKey to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetPublicKey(publicKey *string) {
	o.PublicKey = publicKey
}

// WithReturnRecords adds the returnRecords to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithReturnRecords(returnRecords *bool) *PublickeyModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *PublickeyModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithScope(scope *string) *PublickeyModifyCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithSerialRecords(serialRecords *bool) *PublickeyModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithShaFingerprint adds the shaFingerprint to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) WithShaFingerprint(shaFingerprint *string) *PublickeyModifyCollectionParams {
	o.SetShaFingerprint(shaFingerprint)
	return o
}

// SetShaFingerprint adds the shaFingerprint to the publickey modify collection params
func (o *PublickeyModifyCollectionParams) SetShaFingerprint(shaFingerprint *string) {
	o.ShaFingerprint = shaFingerprint
}

// WriteToRequest writes these params to a swagger request
func (o *PublickeyModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccountName != nil {

		// query param account.name
		var qrAccountName string

		if o.AccountName != nil {
			qrAccountName = *o.AccountName
		}
		qAccountName := qrAccountName
		if qAccountName != "" {

			if err := r.SetQueryParam("account.name", qAccountName); err != nil {
				return err
			}
		}
	}

	if o.Certificate != nil {

		// query param certificate
		var qrCertificate string

		if o.Certificate != nil {
			qrCertificate = *o.Certificate
		}
		qCertificate := qrCertificate
		if qCertificate != "" {

			if err := r.SetQueryParam("certificate", qCertificate); err != nil {
				return err
			}
		}
	}

	if o.CertificateDetails != nil {

		// query param certificate_details
		var qrCertificateDetails string

		if o.CertificateDetails != nil {
			qrCertificateDetails = *o.CertificateDetails
		}
		qCertificateDetails := qrCertificateDetails
		if qCertificateDetails != "" {

			if err := r.SetQueryParam("certificate_details", qCertificateDetails); err != nil {
				return err
			}
		}
	}

	if o.CertificateExpired != nil {

		// query param certificate_expired
		var qrCertificateExpired string

		if o.CertificateExpired != nil {
			qrCertificateExpired = *o.CertificateExpired
		}
		qCertificateExpired := qrCertificateExpired
		if qCertificateExpired != "" {

			if err := r.SetQueryParam("certificate_expired", qCertificateExpired); err != nil {
				return err
			}
		}
	}

	if o.CertificateRevoked != nil {

		// query param certificate_revoked
		var qrCertificateRevoked string

		if o.CertificateRevoked != nil {
			qrCertificateRevoked = *o.CertificateRevoked
		}
		qCertificateRevoked := qrCertificateRevoked
		if qCertificateRevoked != "" {

			if err := r.SetQueryParam("certificate_revoked", qCertificateRevoked); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.ObfuscatedFingerprint != nil {

		// query param obfuscated_fingerprint
		var qrObfuscatedFingerprint string

		if o.ObfuscatedFingerprint != nil {
			qrObfuscatedFingerprint = *o.ObfuscatedFingerprint
		}
		qObfuscatedFingerprint := qrObfuscatedFingerprint
		if qObfuscatedFingerprint != "" {

			if err := r.SetQueryParam("obfuscated_fingerprint", qObfuscatedFingerprint); err != nil {
				return err
			}
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.PublicKey != nil {

		// query param public_key
		var qrPublicKey string

		if o.PublicKey != nil {
			qrPublicKey = *o.PublicKey
		}
		qPublicKey := qrPublicKey
		if qPublicKey != "" {

			if err := r.SetQueryParam("public_key", qPublicKey); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.ShaFingerprint != nil {

		// query param sha_fingerprint
		var qrShaFingerprint string

		if o.ShaFingerprint != nil {
			qrShaFingerprint = *o.ShaFingerprint
		}
		qShaFingerprint := qrShaFingerprint
		if qShaFingerprint != "" {

			if err := r.SetQueryParam("sha_fingerprint", qShaFingerprint); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
