// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// RoleCollectionGetReader is a Reader for the RoleCollectionGet structure.
type RoleCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RoleCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRoleCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRoleCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRoleCollectionGetOK creates a RoleCollectionGetOK with default headers values
func NewRoleCollectionGetOK() *RoleCollectionGetOK {
	return &RoleCollectionGetOK{}
}

/*
RoleCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type RoleCollectionGetOK struct {
	Payload *models.RoleResponse
}

// IsSuccess returns true when this role collection get o k response has a 2xx status code
func (o *RoleCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this role collection get o k response has a 3xx status code
func (o *RoleCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this role collection get o k response has a 4xx status code
func (o *RoleCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this role collection get o k response has a 5xx status code
func (o *RoleCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this role collection get o k response a status code equal to that given
func (o *RoleCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the role collection get o k response
func (o *RoleCollectionGetOK) Code() int {
	return 200
}

func (o *RoleCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles][%d] roleCollectionGetOK %s", 200, payload)
}

func (o *RoleCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles][%d] roleCollectionGetOK %s", 200, payload)
}

func (o *RoleCollectionGetOK) GetPayload() *models.RoleResponse {
	return o.Payload
}

func (o *RoleCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RoleResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRoleCollectionGetDefault creates a RoleCollectionGetDefault with default headers values
func NewRoleCollectionGetDefault(code int) *RoleCollectionGetDefault {
	return &RoleCollectionGetDefault{
		_statusCode: code,
	}
}

/*
RoleCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type RoleCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this role collection get default response has a 2xx status code
func (o *RoleCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this role collection get default response has a 3xx status code
func (o *RoleCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this role collection get default response has a 4xx status code
func (o *RoleCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this role collection get default response has a 5xx status code
func (o *RoleCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this role collection get default response a status code equal to that given
func (o *RoleCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the role collection get default response
func (o *RoleCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *RoleCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles][%d] role_collection_get default %s", o._statusCode, payload)
}

func (o *RoleCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles][%d] role_collection_get default %s", o._statusCode, payload)
}

func (o *RoleCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RoleCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
