// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// RoleCreateReader is a Reader for the RoleCreate structure.
type RoleCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RoleCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewRoleCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRoleCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRoleCreateCreated creates a RoleCreateCreated with default headers values
func NewRoleCreateCreated() *RoleCreateCreated {
	return &RoleCreateCreated{}
}

/*
RoleCreateCreated describes a response with status code 201, with default header values.

Created
*/
type RoleCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this role create created response has a 2xx status code
func (o *RoleCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this role create created response has a 3xx status code
func (o *RoleCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this role create created response has a 4xx status code
func (o *RoleCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this role create created response has a 5xx status code
func (o *RoleCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this role create created response a status code equal to that given
func (o *RoleCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the role create created response
func (o *RoleCreateCreated) Code() int {
	return 201
}

func (o *RoleCreateCreated) Error() string {
	return fmt.Sprintf("[POST /security/roles][%d] roleCreateCreated", 201)
}

func (o *RoleCreateCreated) String() string {
	return fmt.Sprintf("[POST /security/roles][%d] roleCreateCreated", 201)
}

func (o *RoleCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewRoleCreateDefault creates a RoleCreateDefault with default headers values
func NewRoleCreateDefault(code int) *RoleCreateDefault {
	return &RoleCreateDefault{
		_statusCode: code,
	}
}

/*
	RoleCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1263347 | Cannot modify pre-defined roles |
| 2621462 | The supplied SVM does not exist. |
| 5636129 | Role with given name has not been defined. |
| 5636143 | Vserver admin cannot use the API with this access level. |
| 5636144 | Invalid value specified for access level. |
| 5636168 | This role is mapped to a REST role and can only be modified by updating the REST role. |
| 5636169 | Invalid character in URI. |
| 5636170 | URI does not exist. |
| 5636171 | Role already exists in legacy role table. |
| 5636184 | Expanded REST roles for granular resource control feature is currently disabled. |
| 5636185 | The specified UUID was not found. |
| 5636186 | Expanded REST roles for granular resource control requires an effective cluster version of 9.10.1 or later. |
| 5636191 | The "path" parameter in a "privileges" tuple can contain only API endpoint entries or only command and command directory entries. |
| 5636192 | The query parameter cannot be specified for the privileges tuple with API endpoint entries. |
| 5636200 | The specified value of the access parameter is invalid, if a command or command directory is specified in the path parameter. |
| 5636210 | User creation failed because LDAP is not configured for the SVM or the LDAP connection is not secure.<personalities supports=aiml> |
| 5636259 | The specified child AIDE object was not found within the specified parent AIDE object. |
| 5636261 | The specified grandchild AIDE object was not found within the specified child AIDE object that belongs to the specified parent AIDE object.</personalities> |
| 5636262 | Cannot create a role with the specified role name because it is reserved by the system. |
| 13434890 | Vserver-ID failed for Vserver roles. |
| 13434891 | UUID lookup failed for Vserver roles. |
| 13434892 | Roles is a required field. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type RoleCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this role create default response has a 2xx status code
func (o *RoleCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this role create default response has a 3xx status code
func (o *RoleCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this role create default response has a 4xx status code
func (o *RoleCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this role create default response has a 5xx status code
func (o *RoleCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this role create default response a status code equal to that given
func (o *RoleCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the role create default response
func (o *RoleCreateDefault) Code() int {
	return o._statusCode
}

func (o *RoleCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/roles][%d] role_create default %s", o._statusCode, payload)
}

func (o *RoleCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/roles][%d] role_create default %s", o._statusCode, payload)
}

func (o *RoleCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RoleCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
