// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRoleDeleteCollectionParams creates a new RoleDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRoleDeleteCollectionParams() *RoleDeleteCollectionParams {
	return &RoleDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRoleDeleteCollectionParamsWithTimeout creates a new RoleDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewRoleDeleteCollectionParamsWithTimeout(timeout time.Duration) *RoleDeleteCollectionParams {
	return &RoleDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewRoleDeleteCollectionParamsWithContext creates a new RoleDeleteCollectionParams object
// with the ability to set a context for a request.
func NewRoleDeleteCollectionParamsWithContext(ctx context.Context) *RoleDeleteCollectionParams {
	return &RoleDeleteCollectionParams{
		Context: ctx,
	}
}

// NewRoleDeleteCollectionParamsWithHTTPClient creates a new RoleDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewRoleDeleteCollectionParamsWithHTTPClient(client *http.Client) *RoleDeleteCollectionParams {
	return &RoleDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
RoleDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the role delete collection operation.

	Typically these are written to a http.Request.
*/
type RoleDeleteCollectionParams struct {

	/* Builtin.

	   Filter by builtin
	*/
	Builtin *bool

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info RoleDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* PrivilegesAccess.

	   Filter by privileges.access
	*/
	PrivilegesAccess *string

	/* PrivilegesPath.

	   Filter by privileges.path
	*/
	PrivilegesPath *string

	/* PrivilegesQuery.

	   Filter by privileges.query
	*/
	PrivilegesQuery *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the role delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RoleDeleteCollectionParams) WithDefaults() *RoleDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the role delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RoleDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := RoleDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the role delete collection params
func (o *RoleDeleteCollectionParams) WithTimeout(timeout time.Duration) *RoleDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the role delete collection params
func (o *RoleDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the role delete collection params
func (o *RoleDeleteCollectionParams) WithContext(ctx context.Context) *RoleDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the role delete collection params
func (o *RoleDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the role delete collection params
func (o *RoleDeleteCollectionParams) WithHTTPClient(client *http.Client) *RoleDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the role delete collection params
func (o *RoleDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBuiltin adds the builtin to the role delete collection params
func (o *RoleDeleteCollectionParams) WithBuiltin(builtin *bool) *RoleDeleteCollectionParams {
	o.SetBuiltin(builtin)
	return o
}

// SetBuiltin adds the builtin to the role delete collection params
func (o *RoleDeleteCollectionParams) SetBuiltin(builtin *bool) {
	o.Builtin = builtin
}

// WithContinueOnFailure adds the continueOnFailure to the role delete collection params
func (o *RoleDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *RoleDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the role delete collection params
func (o *RoleDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the role delete collection params
func (o *RoleDeleteCollectionParams) WithInfo(info RoleDeleteCollectionBody) *RoleDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the role delete collection params
func (o *RoleDeleteCollectionParams) SetInfo(info RoleDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the role delete collection params
func (o *RoleDeleteCollectionParams) WithName(name *string) *RoleDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the role delete collection params
func (o *RoleDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOwnerName adds the ownerName to the role delete collection params
func (o *RoleDeleteCollectionParams) WithOwnerName(ownerName *string) *RoleDeleteCollectionParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the role delete collection params
func (o *RoleDeleteCollectionParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the role delete collection params
func (o *RoleDeleteCollectionParams) WithOwnerUUID(ownerUUID *string) *RoleDeleteCollectionParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the role delete collection params
func (o *RoleDeleteCollectionParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithPrivilegesAccess adds the privilegesAccess to the role delete collection params
func (o *RoleDeleteCollectionParams) WithPrivilegesAccess(privilegesAccess *string) *RoleDeleteCollectionParams {
	o.SetPrivilegesAccess(privilegesAccess)
	return o
}

// SetPrivilegesAccess adds the privilegesAccess to the role delete collection params
func (o *RoleDeleteCollectionParams) SetPrivilegesAccess(privilegesAccess *string) {
	o.PrivilegesAccess = privilegesAccess
}

// WithPrivilegesPath adds the privilegesPath to the role delete collection params
func (o *RoleDeleteCollectionParams) WithPrivilegesPath(privilegesPath *string) *RoleDeleteCollectionParams {
	o.SetPrivilegesPath(privilegesPath)
	return o
}

// SetPrivilegesPath adds the privilegesPath to the role delete collection params
func (o *RoleDeleteCollectionParams) SetPrivilegesPath(privilegesPath *string) {
	o.PrivilegesPath = privilegesPath
}

// WithPrivilegesQuery adds the privilegesQuery to the role delete collection params
func (o *RoleDeleteCollectionParams) WithPrivilegesQuery(privilegesQuery *string) *RoleDeleteCollectionParams {
	o.SetPrivilegesQuery(privilegesQuery)
	return o
}

// SetPrivilegesQuery adds the privilegesQuery to the role delete collection params
func (o *RoleDeleteCollectionParams) SetPrivilegesQuery(privilegesQuery *string) {
	o.PrivilegesQuery = privilegesQuery
}

// WithReturnRecords adds the returnRecords to the role delete collection params
func (o *RoleDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *RoleDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the role delete collection params
func (o *RoleDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the role delete collection params
func (o *RoleDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *RoleDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the role delete collection params
func (o *RoleDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the role delete collection params
func (o *RoleDeleteCollectionParams) WithScope(scope *string) *RoleDeleteCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the role delete collection params
func (o *RoleDeleteCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the role delete collection params
func (o *RoleDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *RoleDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the role delete collection params
func (o *RoleDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WriteToRequest writes these params to a swagger request
func (o *RoleDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Builtin != nil {

		// query param builtin
		var qrBuiltin bool

		if o.Builtin != nil {
			qrBuiltin = *o.Builtin
		}
		qBuiltin := swag.FormatBool(qrBuiltin)
		if qBuiltin != "" {

			if err := r.SetQueryParam("builtin", qBuiltin); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.PrivilegesAccess != nil {

		// query param privileges.access
		var qrPrivilegesAccess string

		if o.PrivilegesAccess != nil {
			qrPrivilegesAccess = *o.PrivilegesAccess
		}
		qPrivilegesAccess := qrPrivilegesAccess
		if qPrivilegesAccess != "" {

			if err := r.SetQueryParam("privileges.access", qPrivilegesAccess); err != nil {
				return err
			}
		}
	}

	if o.PrivilegesPath != nil {

		// query param privileges.path
		var qrPrivilegesPath string

		if o.PrivilegesPath != nil {
			qrPrivilegesPath = *o.PrivilegesPath
		}
		qPrivilegesPath := qrPrivilegesPath
		if qPrivilegesPath != "" {

			if err := r.SetQueryParam("privileges.path", qPrivilegesPath); err != nil {
				return err
			}
		}
	}

	if o.PrivilegesQuery != nil {

		// query param privileges.query
		var qrPrivilegesQuery string

		if o.PrivilegesQuery != nil {
			qrPrivilegesQuery = *o.PrivilegesQuery
		}
		qPrivilegesQuery := qrPrivilegesQuery
		if qPrivilegesQuery != "" {

			if err := r.SetQueryParam("privileges.query", qPrivilegesQuery); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
