// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// RoleDeleteCollectionReader is a Reader for the RoleDeleteCollection structure.
type RoleDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RoleDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRoleDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRoleDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRoleDeleteCollectionOK creates a RoleDeleteCollectionOK with default headers values
func NewRoleDeleteCollectionOK() *RoleDeleteCollectionOK {
	return &RoleDeleteCollectionOK{}
}

/*
RoleDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type RoleDeleteCollectionOK struct {
}

// IsSuccess returns true when this role delete collection o k response has a 2xx status code
func (o *RoleDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this role delete collection o k response has a 3xx status code
func (o *RoleDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this role delete collection o k response has a 4xx status code
func (o *RoleDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this role delete collection o k response has a 5xx status code
func (o *RoleDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this role delete collection o k response a status code equal to that given
func (o *RoleDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the role delete collection o k response
func (o *RoleDeleteCollectionOK) Code() int {
	return 200
}

func (o *RoleDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/roles][%d] roleDeleteCollectionOK", 200)
}

func (o *RoleDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/roles][%d] roleDeleteCollectionOK", 200)
}

func (o *RoleDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRoleDeleteCollectionDefault creates a RoleDeleteCollectionDefault with default headers values
func NewRoleDeleteCollectionDefault(code int) *RoleDeleteCollectionDefault {
	return &RoleDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	RoleDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1263347 | Cannot modify pre-defined roles. |
| 5636169 | Specified URI path is invalid or not supported. Resource-qualified endpoints are not supported. |
| 5636170 | URI does not exist. |
| 5636172 | User accounts detected with this role assigned. Update or delete those accounts before deleting this role. |
| 5636173 | Features require an effective cluster version of 9.6 or later. |
| 5636184 | Expanded REST roles for granular resource control feature is currently disabled. |
| 5636185 | The specified UUID was not found. |
| 5636186 | Expanded REST roles for granular resource control requires an effective cluster version of 9.10.1 or later. |
| 5636245 | Failed to delete the role because it is part of the group role-mapping configuration. |
| 5636246 | Failed to delete the rest role because it is part of the group role-mapping configuration. |
| 5636247 | Failed to delete the rest role because it is part of the external-role-mapping configuration. |
| 5636249 | Failed to delete the role because it is part of the external-role-mapping configuration. |
| 5636258 | The maximum allowed length for a role name is 256 characters.<personalities supports=aiml> |
| 5636259 | The specified child AIDE object was not found within the specified parent AIDE object. |
| 5636261 | The specified grandchild AIDE object was not found within the specified child AIDE object that belongs to the specified parent AIDE object.</personalities> |
| 13434890 | Vserver-ID failed for Vserver roles. |
| 13434893 | The SVM does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type RoleDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this role delete collection default response has a 2xx status code
func (o *RoleDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this role delete collection default response has a 3xx status code
func (o *RoleDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this role delete collection default response has a 4xx status code
func (o *RoleDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this role delete collection default response has a 5xx status code
func (o *RoleDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this role delete collection default response a status code equal to that given
func (o *RoleDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the role delete collection default response
func (o *RoleDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *RoleDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/roles][%d] role_delete_collection default %s", o._statusCode, payload)
}

func (o *RoleDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/roles][%d] role_delete_collection default %s", o._statusCode, payload)
}

func (o *RoleDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RoleDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
RoleDeleteCollectionBody role delete collection body
swagger:model RoleDeleteCollectionBody
*/
type RoleDeleteCollectionBody struct {

	// role response inline records
	RoleResponseInlineRecords []*models.Role `json:"records,omitempty"`
}

// Validate validates this role delete collection body
func (o *RoleDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRoleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RoleDeleteCollectionBody) validateRoleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.RoleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.RoleResponseInlineRecords); i++ {
		if swag.IsZero(o.RoleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.RoleResponseInlineRecords[i] != nil {
			if err := o.RoleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this role delete collection body based on the context it is used
func (o *RoleDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRoleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RoleDeleteCollectionBody) contextValidateRoleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.RoleResponseInlineRecords); i++ {

		if o.RoleResponseInlineRecords[i] != nil {
			if err := o.RoleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *RoleDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *RoleDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res RoleDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
