// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewRoleDeleteParams creates a new RoleDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRoleDeleteParams() *RoleDeleteParams {
	return &RoleDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRoleDeleteParamsWithTimeout creates a new RoleDeleteParams object
// with the ability to set a timeout on a request.
func NewRoleDeleteParamsWithTimeout(timeout time.Duration) *RoleDeleteParams {
	return &RoleDeleteParams{
		timeout: timeout,
	}
}

// NewRoleDeleteParamsWithContext creates a new RoleDeleteParams object
// with the ability to set a context for a request.
func NewRoleDeleteParamsWithContext(ctx context.Context) *RoleDeleteParams {
	return &RoleDeleteParams{
		Context: ctx,
	}
}

// NewRoleDeleteParamsWithHTTPClient creates a new RoleDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewRoleDeleteParamsWithHTTPClient(client *http.Client) *RoleDeleteParams {
	return &RoleDeleteParams{
		HTTPClient: client,
	}
}

/*
RoleDeleteParams contains all the parameters to send to the API endpoint

	for the role delete operation.

	Typically these are written to a http.Request.
*/
type RoleDeleteParams struct {

	/* Name.

	   Role name to be deleted.
	*/
	Name string

	/* OwnerUUID.

	   Role owner UUID
	*/
	OwnerUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the role delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RoleDeleteParams) WithDefaults() *RoleDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the role delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RoleDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the role delete params
func (o *RoleDeleteParams) WithTimeout(timeout time.Duration) *RoleDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the role delete params
func (o *RoleDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the role delete params
func (o *RoleDeleteParams) WithContext(ctx context.Context) *RoleDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the role delete params
func (o *RoleDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the role delete params
func (o *RoleDeleteParams) WithHTTPClient(client *http.Client) *RoleDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the role delete params
func (o *RoleDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the role delete params
func (o *RoleDeleteParams) WithName(name string) *RoleDeleteParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the role delete params
func (o *RoleDeleteParams) SetName(name string) {
	o.Name = name
}

// WithOwnerUUID adds the ownerUUID to the role delete params
func (o *RoleDeleteParams) WithOwnerUUID(ownerUUID string) *RoleDeleteParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the role delete params
func (o *RoleDeleteParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WriteToRequest writes these params to a swagger request
func (o *RoleDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
