// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// RolePrivilegeCollectionGetReader is a Reader for the RolePrivilegeCollectionGet structure.
type RolePrivilegeCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RolePrivilegeCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRolePrivilegeCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRolePrivilegeCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRolePrivilegeCollectionGetOK creates a RolePrivilegeCollectionGetOK with default headers values
func NewRolePrivilegeCollectionGetOK() *RolePrivilegeCollectionGetOK {
	return &RolePrivilegeCollectionGetOK{}
}

/*
RolePrivilegeCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type RolePrivilegeCollectionGetOK struct {
	Payload *models.RolePrivilegeResponse
}

// IsSuccess returns true when this role privilege collection get o k response has a 2xx status code
func (o *RolePrivilegeCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this role privilege collection get o k response has a 3xx status code
func (o *RolePrivilegeCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this role privilege collection get o k response has a 4xx status code
func (o *RolePrivilegeCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this role privilege collection get o k response has a 5xx status code
func (o *RolePrivilegeCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this role privilege collection get o k response a status code equal to that given
func (o *RolePrivilegeCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the role privilege collection get o k response
func (o *RolePrivilegeCollectionGetOK) Code() int {
	return 200
}

func (o *RolePrivilegeCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles/{owner.uuid}/{name}/privileges][%d] rolePrivilegeCollectionGetOK %s", 200, payload)
}

func (o *RolePrivilegeCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles/{owner.uuid}/{name}/privileges][%d] rolePrivilegeCollectionGetOK %s", 200, payload)
}

func (o *RolePrivilegeCollectionGetOK) GetPayload() *models.RolePrivilegeResponse {
	return o.Payload
}

func (o *RolePrivilegeCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RolePrivilegeResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRolePrivilegeCollectionGetDefault creates a RolePrivilegeCollectionGetDefault with default headers values
func NewRolePrivilegeCollectionGetDefault(code int) *RolePrivilegeCollectionGetDefault {
	return &RolePrivilegeCollectionGetDefault{
		_statusCode: code,
	}
}

/*
RolePrivilegeCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type RolePrivilegeCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this role privilege collection get default response has a 2xx status code
func (o *RolePrivilegeCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this role privilege collection get default response has a 3xx status code
func (o *RolePrivilegeCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this role privilege collection get default response has a 4xx status code
func (o *RolePrivilegeCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this role privilege collection get default response has a 5xx status code
func (o *RolePrivilegeCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this role privilege collection get default response a status code equal to that given
func (o *RolePrivilegeCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the role privilege collection get default response
func (o *RolePrivilegeCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *RolePrivilegeCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles/{owner.uuid}/{name}/privileges][%d] role_privilege_collection_get default %s", o._statusCode, payload)
}

func (o *RolePrivilegeCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles/{owner.uuid}/{name}/privileges][%d] role_privilege_collection_get default %s", o._statusCode, payload)
}

func (o *RolePrivilegeCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RolePrivilegeCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
