// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// RolePrivilegeCreateReader is a Reader for the RolePrivilegeCreate structure.
type RolePrivilegeCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RolePrivilegeCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewRolePrivilegeCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRolePrivilegeCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRolePrivilegeCreateCreated creates a RolePrivilegeCreateCreated with default headers values
func NewRolePrivilegeCreateCreated() *RolePrivilegeCreateCreated {
	return &RolePrivilegeCreateCreated{}
}

/*
RolePrivilegeCreateCreated describes a response with status code 201, with default header values.

Created
*/
type RolePrivilegeCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this role privilege create created response has a 2xx status code
func (o *RolePrivilegeCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this role privilege create created response has a 3xx status code
func (o *RolePrivilegeCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this role privilege create created response has a 4xx status code
func (o *RolePrivilegeCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this role privilege create created response has a 5xx status code
func (o *RolePrivilegeCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this role privilege create created response a status code equal to that given
func (o *RolePrivilegeCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the role privilege create created response
func (o *RolePrivilegeCreateCreated) Code() int {
	return 201
}

func (o *RolePrivilegeCreateCreated) Error() string {
	return fmt.Sprintf("[POST /security/roles/{owner.uuid}/{name}/privileges][%d] rolePrivilegeCreateCreated", 201)
}

func (o *RolePrivilegeCreateCreated) String() string {
	return fmt.Sprintf("[POST /security/roles/{owner.uuid}/{name}/privileges][%d] rolePrivilegeCreateCreated", 201)
}

func (o *RolePrivilegeCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewRolePrivilegeCreateDefault creates a RolePrivilegeCreateDefault with default headers values
func NewRolePrivilegeCreateDefault(code int) *RolePrivilegeCreateDefault {
	return &RolePrivilegeCreateDefault{
		_statusCode: code,
	}
}

/*
	RolePrivilegeCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1263347 | Cannot modify pre-defined roles. |
| 5636129 | A role with given name has not been defined. |
| 5636143 | A Vserver admin cannot use the API with this access level. |
| 5636144 | The value specified for the access level is not valid. |
| 5636168 | This role is mapped to a REST role and can only be modified by updating the REST role.<personalities supports=aiml> |
| 5636169 | A character in the URI is not valid. |
| 5636170 | The URI does not exist. |
| 5636173 | This feature requires an effective cluster version of 9.6 or later. |
| 5636175 | Vserver admin cannot have access to given API. |
| 5636184 | The expanded REST roles for granular resource control feature is currently disabled. |
| 5636185 | The specified UUID was not found. |
| 5636186 | Expanded REST roles for granular resource control requires an effective cluster version of 9.10.1 or later. |
| 5636192 | The query parameter cannot be specified for the privileges tuple with API endpoint entries. |
| 5636200 | The specified value of the access parameter is invalid, if a command or command directory is specified in the path parameter. |
| 5636259 | The specified child AIDE object was not found within the specified parent AIDE object. |
| 5636261 | The specified grandchild AIDE object was not found within the specified child AIDE object that belongs to the specified parent AIDE object.</personalities> |
| 5636262 | Cannot create a role with the specified role name because it is reserved by the system. |
| 13434890 | Vserver-ID failed for Vserver roles. |
| 13434891 | UUID LookUp failed for Vserver roles. |
| 13434892 | Roles is a required field. |
| 13434893 | The SVM does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type RolePrivilegeCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this role privilege create default response has a 2xx status code
func (o *RolePrivilegeCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this role privilege create default response has a 3xx status code
func (o *RolePrivilegeCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this role privilege create default response has a 4xx status code
func (o *RolePrivilegeCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this role privilege create default response has a 5xx status code
func (o *RolePrivilegeCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this role privilege create default response a status code equal to that given
func (o *RolePrivilegeCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the role privilege create default response
func (o *RolePrivilegeCreateDefault) Code() int {
	return o._statusCode
}

func (o *RolePrivilegeCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/roles/{owner.uuid}/{name}/privileges][%d] role_privilege_create default %s", o._statusCode, payload)
}

func (o *RolePrivilegeCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/roles/{owner.uuid}/{name}/privileges][%d] role_privilege_create default %s", o._statusCode, payload)
}

func (o *RolePrivilegeCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RolePrivilegeCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
