// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// RolePrivilegeDeleteCollectionReader is a Reader for the RolePrivilegeDeleteCollection structure.
type RolePrivilegeDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RolePrivilegeDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRolePrivilegeDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRolePrivilegeDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRolePrivilegeDeleteCollectionOK creates a RolePrivilegeDeleteCollectionOK with default headers values
func NewRolePrivilegeDeleteCollectionOK() *RolePrivilegeDeleteCollectionOK {
	return &RolePrivilegeDeleteCollectionOK{}
}

/*
RolePrivilegeDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type RolePrivilegeDeleteCollectionOK struct {
}

// IsSuccess returns true when this role privilege delete collection o k response has a 2xx status code
func (o *RolePrivilegeDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this role privilege delete collection o k response has a 3xx status code
func (o *RolePrivilegeDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this role privilege delete collection o k response has a 4xx status code
func (o *RolePrivilegeDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this role privilege delete collection o k response has a 5xx status code
func (o *RolePrivilegeDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this role privilege delete collection o k response a status code equal to that given
func (o *RolePrivilegeDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the role privilege delete collection o k response
func (o *RolePrivilegeDeleteCollectionOK) Code() int {
	return 200
}

func (o *RolePrivilegeDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/roles/{owner.uuid}/{name}/privileges][%d] rolePrivilegeDeleteCollectionOK", 200)
}

func (o *RolePrivilegeDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/roles/{owner.uuid}/{name}/privileges][%d] rolePrivilegeDeleteCollectionOK", 200)
}

func (o *RolePrivilegeDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRolePrivilegeDeleteCollectionDefault creates a RolePrivilegeDeleteCollectionDefault with default headers values
func NewRolePrivilegeDeleteCollectionDefault(code int) *RolePrivilegeDeleteCollectionDefault {
	return &RolePrivilegeDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	RolePrivilegeDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1263347 | Cannot modify pre-defined roles. |
| 5636168 | This role is mapped to a REST role and can only be modified by updating the REST role.<personalities supports=aiml> |
| 5636169 | Specified URI path is invalid or not supported. Resource-qualified endpoints are not supported. |
| 5636170 | URI does not exist. |
| 5636172 | User accounts detected with this role assigned. Update or delete those accounts before deleting this role. |
| 5636173 | This feature requires an effective cluster version of 9.6 or later. |
| 5636184 | Expanded REST roles for granular resource control feature is currently disabled. |
| 5636185 | The specified UUID was not found. |
| 5636186 | Expanded REST roles for granular resource control requires an effective cluster version of 9.10.1 or later. |
| 5636259 | The specified child AIDE object was not found within the specified parent AIDE object. |
| 5636261 | The specified grandchild AIDE object was not found within the specified child AIDE object that belongs to the specified parent AIDE object.</personalities> |
| 13434890 | Vserver-ID failed for Vserver roles. |
| 13434893 | The SVM does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type RolePrivilegeDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this role privilege delete collection default response has a 2xx status code
func (o *RolePrivilegeDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this role privilege delete collection default response has a 3xx status code
func (o *RolePrivilegeDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this role privilege delete collection default response has a 4xx status code
func (o *RolePrivilegeDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this role privilege delete collection default response has a 5xx status code
func (o *RolePrivilegeDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this role privilege delete collection default response a status code equal to that given
func (o *RolePrivilegeDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the role privilege delete collection default response
func (o *RolePrivilegeDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *RolePrivilegeDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/roles/{owner.uuid}/{name}/privileges][%d] role_privilege_delete_collection default %s", o._statusCode, payload)
}

func (o *RolePrivilegeDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/roles/{owner.uuid}/{name}/privileges][%d] role_privilege_delete_collection default %s", o._statusCode, payload)
}

func (o *RolePrivilegeDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RolePrivilegeDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
RolePrivilegeDeleteCollectionBody role privilege delete collection body
swagger:model RolePrivilegeDeleteCollectionBody
*/
type RolePrivilegeDeleteCollectionBody struct {

	// role privilege response inline records
	RolePrivilegeResponseInlineRecords []*models.RolePrivilege `json:"records,omitempty"`
}

// Validate validates this role privilege delete collection body
func (o *RolePrivilegeDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRolePrivilegeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RolePrivilegeDeleteCollectionBody) validateRolePrivilegeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.RolePrivilegeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.RolePrivilegeResponseInlineRecords); i++ {
		if swag.IsZero(o.RolePrivilegeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.RolePrivilegeResponseInlineRecords[i] != nil {
			if err := o.RolePrivilegeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this role privilege delete collection body based on the context it is used
func (o *RolePrivilegeDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRolePrivilegeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RolePrivilegeDeleteCollectionBody) contextValidateRolePrivilegeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.RolePrivilegeResponseInlineRecords); i++ {

		if o.RolePrivilegeResponseInlineRecords[i] != nil {
			if err := o.RolePrivilegeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *RolePrivilegeDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *RolePrivilegeDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res RolePrivilegeDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
