// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRolePrivilegeGetParams creates a new RolePrivilegeGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRolePrivilegeGetParams() *RolePrivilegeGetParams {
	return &RolePrivilegeGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRolePrivilegeGetParamsWithTimeout creates a new RolePrivilegeGetParams object
// with the ability to set a timeout on a request.
func NewRolePrivilegeGetParamsWithTimeout(timeout time.Duration) *RolePrivilegeGetParams {
	return &RolePrivilegeGetParams{
		timeout: timeout,
	}
}

// NewRolePrivilegeGetParamsWithContext creates a new RolePrivilegeGetParams object
// with the ability to set a context for a request.
func NewRolePrivilegeGetParamsWithContext(ctx context.Context) *RolePrivilegeGetParams {
	return &RolePrivilegeGetParams{
		Context: ctx,
	}
}

// NewRolePrivilegeGetParamsWithHTTPClient creates a new RolePrivilegeGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewRolePrivilegeGetParamsWithHTTPClient(client *http.Client) *RolePrivilegeGetParams {
	return &RolePrivilegeGetParams{
		HTTPClient: client,
	}
}

/*
RolePrivilegeGetParams contains all the parameters to send to the API endpoint

	for the role privilege get operation.

	Typically these are written to a http.Request.
*/
type RolePrivilegeGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   Role name
	*/
	Name string

	/* OwnerUUID.

	   Role owner UUID
	*/
	OwnerUUID string

	/* Path.

	   REST API path or command/command directory path
	*/
	Path string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the role privilege get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RolePrivilegeGetParams) WithDefaults() *RolePrivilegeGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the role privilege get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RolePrivilegeGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the role privilege get params
func (o *RolePrivilegeGetParams) WithTimeout(timeout time.Duration) *RolePrivilegeGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the role privilege get params
func (o *RolePrivilegeGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the role privilege get params
func (o *RolePrivilegeGetParams) WithContext(ctx context.Context) *RolePrivilegeGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the role privilege get params
func (o *RolePrivilegeGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the role privilege get params
func (o *RolePrivilegeGetParams) WithHTTPClient(client *http.Client) *RolePrivilegeGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the role privilege get params
func (o *RolePrivilegeGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the role privilege get params
func (o *RolePrivilegeGetParams) WithFields(fields []string) *RolePrivilegeGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the role privilege get params
func (o *RolePrivilegeGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the role privilege get params
func (o *RolePrivilegeGetParams) WithName(name string) *RolePrivilegeGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the role privilege get params
func (o *RolePrivilegeGetParams) SetName(name string) {
	o.Name = name
}

// WithOwnerUUID adds the ownerUUID to the role privilege get params
func (o *RolePrivilegeGetParams) WithOwnerUUID(ownerUUID string) *RolePrivilegeGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the role privilege get params
func (o *RolePrivilegeGetParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WithPath adds the path to the role privilege get params
func (o *RolePrivilegeGetParams) WithPath(path string) *RolePrivilegeGetParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the role privilege get params
func (o *RolePrivilegeGetParams) SetPath(path string) {
	o.Path = path
}

// WriteToRequest writes these params to a swagger request
func (o *RolePrivilegeGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamRolePrivilegeGet binds the parameter fields
func (o *RolePrivilegeGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
