// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// RolePrivilegeGetReader is a Reader for the RolePrivilegeGet structure.
type RolePrivilegeGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RolePrivilegeGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRolePrivilegeGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRolePrivilegeGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRolePrivilegeGetOK creates a RolePrivilegeGetOK with default headers values
func NewRolePrivilegeGetOK() *RolePrivilegeGetOK {
	return &RolePrivilegeGetOK{}
}

/*
RolePrivilegeGetOK describes a response with status code 200, with default header values.

OK
*/
type RolePrivilegeGetOK struct {
	Payload *models.RolePrivilege
}

// IsSuccess returns true when this role privilege get o k response has a 2xx status code
func (o *RolePrivilegeGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this role privilege get o k response has a 3xx status code
func (o *RolePrivilegeGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this role privilege get o k response has a 4xx status code
func (o *RolePrivilegeGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this role privilege get o k response has a 5xx status code
func (o *RolePrivilegeGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this role privilege get o k response a status code equal to that given
func (o *RolePrivilegeGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the role privilege get o k response
func (o *RolePrivilegeGetOK) Code() int {
	return 200
}

func (o *RolePrivilegeGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles/{owner.uuid}/{name}/privileges/{path}][%d] rolePrivilegeGetOK %s", 200, payload)
}

func (o *RolePrivilegeGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles/{owner.uuid}/{name}/privileges/{path}][%d] rolePrivilegeGetOK %s", 200, payload)
}

func (o *RolePrivilegeGetOK) GetPayload() *models.RolePrivilege {
	return o.Payload
}

func (o *RolePrivilegeGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RolePrivilege)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRolePrivilegeGetDefault creates a RolePrivilegeGetDefault with default headers values
func NewRolePrivilegeGetDefault(code int) *RolePrivilegeGetDefault {
	return &RolePrivilegeGetDefault{
		_statusCode: code,
	}
}

/*
RolePrivilegeGetDefault describes a response with status code -1, with default header values.

Error
*/
type RolePrivilegeGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this role privilege get default response has a 2xx status code
func (o *RolePrivilegeGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this role privilege get default response has a 3xx status code
func (o *RolePrivilegeGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this role privilege get default response has a 4xx status code
func (o *RolePrivilegeGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this role privilege get default response has a 5xx status code
func (o *RolePrivilegeGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this role privilege get default response a status code equal to that given
func (o *RolePrivilegeGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the role privilege get default response
func (o *RolePrivilegeGetDefault) Code() int {
	return o._statusCode
}

func (o *RolePrivilegeGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles/{owner.uuid}/{name}/privileges/{path}][%d] role_privilege_get default %s", o._statusCode, payload)
}

func (o *RolePrivilegeGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/roles/{owner.uuid}/{name}/privileges/{path}][%d] role_privilege_get default %s", o._statusCode, payload)
}

func (o *RolePrivilegeGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RolePrivilegeGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
