// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRolePrivilegeModifyCollectionParams creates a new RolePrivilegeModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRolePrivilegeModifyCollectionParams() *RolePrivilegeModifyCollectionParams {
	return &RolePrivilegeModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRolePrivilegeModifyCollectionParamsWithTimeout creates a new RolePrivilegeModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewRolePrivilegeModifyCollectionParamsWithTimeout(timeout time.Duration) *RolePrivilegeModifyCollectionParams {
	return &RolePrivilegeModifyCollectionParams{
		timeout: timeout,
	}
}

// NewRolePrivilegeModifyCollectionParamsWithContext creates a new RolePrivilegeModifyCollectionParams object
// with the ability to set a context for a request.
func NewRolePrivilegeModifyCollectionParamsWithContext(ctx context.Context) *RolePrivilegeModifyCollectionParams {
	return &RolePrivilegeModifyCollectionParams{
		Context: ctx,
	}
}

// NewRolePrivilegeModifyCollectionParamsWithHTTPClient creates a new RolePrivilegeModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewRolePrivilegeModifyCollectionParamsWithHTTPClient(client *http.Client) *RolePrivilegeModifyCollectionParams {
	return &RolePrivilegeModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
RolePrivilegeModifyCollectionParams contains all the parameters to send to the API endpoint

	for the role privilege modify collection operation.

	Typically these are written to a http.Request.
*/
type RolePrivilegeModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info RolePrivilegeModifyCollectionBody

	/* Name.

	   Role name
	*/
	Name string

	/* OwnerUUID.

	   Role owner UUID
	*/
	OwnerUUID string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the role privilege modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RolePrivilegeModifyCollectionParams) WithDefaults() *RolePrivilegeModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the role privilege modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RolePrivilegeModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := RolePrivilegeModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) WithTimeout(timeout time.Duration) *RolePrivilegeModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) WithContext(ctx context.Context) *RolePrivilegeModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) WithHTTPClient(client *http.Client) *RolePrivilegeModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *RolePrivilegeModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) WithInfo(info RolePrivilegeModifyCollectionBody) *RolePrivilegeModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) SetInfo(info RolePrivilegeModifyCollectionBody) {
	o.Info = info
}

// WithName adds the name to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) WithName(name string) *RolePrivilegeModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) SetName(name string) {
	o.Name = name
}

// WithOwnerUUID adds the ownerUUID to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) WithOwnerUUID(ownerUUID string) *RolePrivilegeModifyCollectionParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) WithReturnRecords(returnRecords *bool) *RolePrivilegeModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *RolePrivilegeModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) WithSerialRecords(serialRecords *bool) *RolePrivilegeModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the role privilege modify collection params
func (o *RolePrivilegeModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WriteToRequest writes these params to a swagger request
func (o *RolePrivilegeModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
