// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// RolePrivilegeModifyCollectionReader is a Reader for the RolePrivilegeModifyCollection structure.
type RolePrivilegeModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RolePrivilegeModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRolePrivilegeModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRolePrivilegeModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRolePrivilegeModifyCollectionOK creates a RolePrivilegeModifyCollectionOK with default headers values
func NewRolePrivilegeModifyCollectionOK() *RolePrivilegeModifyCollectionOK {
	return &RolePrivilegeModifyCollectionOK{}
}

/*
RolePrivilegeModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type RolePrivilegeModifyCollectionOK struct {
}

// IsSuccess returns true when this role privilege modify collection o k response has a 2xx status code
func (o *RolePrivilegeModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this role privilege modify collection o k response has a 3xx status code
func (o *RolePrivilegeModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this role privilege modify collection o k response has a 4xx status code
func (o *RolePrivilegeModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this role privilege modify collection o k response has a 5xx status code
func (o *RolePrivilegeModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this role privilege modify collection o k response a status code equal to that given
func (o *RolePrivilegeModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the role privilege modify collection o k response
func (o *RolePrivilegeModifyCollectionOK) Code() int {
	return 200
}

func (o *RolePrivilegeModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/roles/{owner.uuid}/{name}/privileges][%d] rolePrivilegeModifyCollectionOK", 200)
}

func (o *RolePrivilegeModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/roles/{owner.uuid}/{name}/privileges][%d] rolePrivilegeModifyCollectionOK", 200)
}

func (o *RolePrivilegeModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewRolePrivilegeModifyCollectionDefault creates a RolePrivilegeModifyCollectionDefault with default headers values
func NewRolePrivilegeModifyCollectionDefault(code int) *RolePrivilegeModifyCollectionDefault {
	return &RolePrivilegeModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	RolePrivilegeModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5636168 | This role is mapped to a REST role and can only be modified by updating the REST role. |
| 5636192 | The query parameter cannot be specified for the privileges tuple with API endpoint entries. |
| 5636200 | The specified value of the access parameter is invalid, if a command or command directory is specified in the path parameter.<personalities supports=aiml> |
| 5636259 | The specified child AIDE object was not found within the specified parent AIDE object. |
| 5636261 | The specified grandchild AIDE object was not found within the specified child AIDE object that belongs to the specified parent AIDE object.</personalities> |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type RolePrivilegeModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this role privilege modify collection default response has a 2xx status code
func (o *RolePrivilegeModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this role privilege modify collection default response has a 3xx status code
func (o *RolePrivilegeModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this role privilege modify collection default response has a 4xx status code
func (o *RolePrivilegeModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this role privilege modify collection default response has a 5xx status code
func (o *RolePrivilegeModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this role privilege modify collection default response a status code equal to that given
func (o *RolePrivilegeModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the role privilege modify collection default response
func (o *RolePrivilegeModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *RolePrivilegeModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/roles/{owner.uuid}/{name}/privileges][%d] role_privilege_modify_collection default %s", o._statusCode, payload)
}

func (o *RolePrivilegeModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/roles/{owner.uuid}/{name}/privileges][%d] role_privilege_modify_collection default %s", o._statusCode, payload)
}

func (o *RolePrivilegeModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *RolePrivilegeModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
RolePrivilegeModifyCollectionBody role privilege modify collection body
swagger:model RolePrivilegeModifyCollectionBody
*/
type RolePrivilegeModifyCollectionBody struct {

	// links
	Links *models.RolePrivilegeInlineLinks `json:"_links,omitempty"`

	// access
	Access *models.RolePrivilegeLevel `json:"access,omitempty"`

	// Either of REST URI/endpoint OR command/command directory path.
	// Example: volume move start
	Path *string `json:"path,omitempty"`

	// Optional attribute that can be specified only if the "path" attribute refers to a command/command directory path. The privilege tuple implicitly defines a set of objects the role can or cannot access at the specified access level. The query further reduces this set of objects to a subset of objects that the role is allowed to access. The query attribute must be applicable to the command/command directory specified by the "path" attribute. It is defined using one or more parameters of the command/command directory path specified by the "path" attribute.
	// Example: -vserver vs1|vs2|vs3 -destination-aggregate aggr1|aggr2
	Query *string `json:"query,omitempty"`

	// role privilege response inline records
	RolePrivilegeResponseInlineRecords []*models.RolePrivilege `json:"records,omitempty"`
}

// Validate validates this role privilege modify collection body
func (o *RolePrivilegeModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRolePrivilegeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RolePrivilegeModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *RolePrivilegeModifyCollectionBody) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(o.Access) { // not required
		return nil
	}

	if o.Access != nil {
		if err := o.Access.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (o *RolePrivilegeModifyCollectionBody) validateRolePrivilegeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.RolePrivilegeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.RolePrivilegeResponseInlineRecords); i++ {
		if swag.IsZero(o.RolePrivilegeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.RolePrivilegeResponseInlineRecords[i] != nil {
			if err := o.RolePrivilegeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this role privilege modify collection body based on the context it is used
func (o *RolePrivilegeModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRolePrivilegeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RolePrivilegeModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *RolePrivilegeModifyCollectionBody) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if o.Access != nil {
		if err := o.Access.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "access")
			}
			return err
		}
	}

	return nil
}

func (o *RolePrivilegeModifyCollectionBody) contextValidateRolePrivilegeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.RolePrivilegeResponseInlineRecords); i++ {

		if o.RolePrivilegeResponseInlineRecords[i] != nil {
			if err := o.RolePrivilegeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *RolePrivilegeModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *RolePrivilegeModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res RolePrivilegeModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
RolePrivilegeInlineLinks role privilege inline links
swagger:model role_privilege_inline__links
*/
type RolePrivilegeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this role privilege inline links
func (o *RolePrivilegeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RolePrivilegeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this role privilege inline links based on the context it is used
func (o *RolePrivilegeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *RolePrivilegeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *RolePrivilegeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *RolePrivilegeInlineLinks) UnmarshalBinary(b []byte) error {
	var res RolePrivilegeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
