// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityAssociationCollectionGetParams creates a new SecurityAssociationCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityAssociationCollectionGetParams() *SecurityAssociationCollectionGetParams {
	return &SecurityAssociationCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityAssociationCollectionGetParamsWithTimeout creates a new SecurityAssociationCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSecurityAssociationCollectionGetParamsWithTimeout(timeout time.Duration) *SecurityAssociationCollectionGetParams {
	return &SecurityAssociationCollectionGetParams{
		timeout: timeout,
	}
}

// NewSecurityAssociationCollectionGetParamsWithContext creates a new SecurityAssociationCollectionGetParams object
// with the ability to set a context for a request.
func NewSecurityAssociationCollectionGetParamsWithContext(ctx context.Context) *SecurityAssociationCollectionGetParams {
	return &SecurityAssociationCollectionGetParams{
		Context: ctx,
	}
}

// NewSecurityAssociationCollectionGetParamsWithHTTPClient creates a new SecurityAssociationCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityAssociationCollectionGetParamsWithHTTPClient(client *http.Client) *SecurityAssociationCollectionGetParams {
	return &SecurityAssociationCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SecurityAssociationCollectionGetParams contains all the parameters to send to the API endpoint

	for the security association collection get operation.

	Typically these are written to a http.Request.
*/
type SecurityAssociationCollectionGetParams struct {

	/* CipherSuite.

	   Filter by cipher_suite
	*/
	CipherSuite *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IkeAuthentication.

	   Filter by ike.authentication
	*/
	IkeAuthentication *string

	/* IkeInitiatorSecurityParameterIndex.

	   Filter by ike.initiator_security_parameter_index
	*/
	IkeInitiatorSecurityParameterIndex *string

	/* IkeIsInitiator.

	   Filter by ike.is_initiator
	*/
	IkeIsInitiator *bool

	/* IkeResponderSecurityParameterIndex.

	   Filter by ike.responder_security_parameter_index
	*/
	IkeResponderSecurityParameterIndex *string

	/* IkeState.

	   Filter by ike.state
	*/
	IkeState *string

	/* IkeVersion.

	   Filter by ike.version
	*/
	IkeVersion *int64

	/* IpsecAction.

	   Filter by ipsec.action
	*/
	IpsecAction *string

	/* IpsecInboundBytes.

	   Filter by ipsec.inbound.bytes
	*/
	IpsecInboundBytes *int64

	/* IpsecInboundOffloadBytes.

	   Filter by ipsec.inbound.offload_bytes
	*/
	IpsecInboundOffloadBytes *int64

	/* IpsecInboundOffloadPackets.

	   Filter by ipsec.inbound.offload_packets
	*/
	IpsecInboundOffloadPackets *int64

	/* IpsecInboundPackets.

	   Filter by ipsec.inbound.packets
	*/
	IpsecInboundPackets *int64

	/* IpsecInboundSecurityParameterIndex.

	   Filter by ipsec.inbound.security_parameter_index
	*/
	IpsecInboundSecurityParameterIndex *string

	/* IpsecOutboundBytes.

	   Filter by ipsec.outbound.bytes
	*/
	IpsecOutboundBytes *int64

	/* IpsecOutboundOffloadBytes.

	   Filter by ipsec.outbound.offload_bytes
	*/
	IpsecOutboundOffloadBytes *int64

	/* IpsecOutboundOffloadPackets.

	   Filter by ipsec.outbound.offload_packets
	*/
	IpsecOutboundOffloadPackets *int64

	/* IpsecOutboundPackets.

	   Filter by ipsec.outbound.packets
	*/
	IpsecOutboundPackets *int64

	/* IpsecOutboundSecurityParameterIndex.

	   Filter by ipsec.outbound.security_parameter_index
	*/
	IpsecOutboundSecurityParameterIndex *string

	/* IpsecState.

	   Filter by ipsec.state
	*/
	IpsecState *string

	/* Lifetime.

	   Filter by lifetime
	*/
	Lifetime *int64

	/* LocalAddress.

	   Filter by local_address
	*/
	LocalAddress *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PolicyName.

	   Filter by policy_name
	*/
	PolicyName *string

	/* RemoteAddress.

	   Filter by remote_address
	*/
	RemoteAddress *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security association collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityAssociationCollectionGetParams) WithDefaults() *SecurityAssociationCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security association collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityAssociationCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SecurityAssociationCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithTimeout(timeout time.Duration) *SecurityAssociationCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithContext(ctx context.Context) *SecurityAssociationCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithHTTPClient(client *http.Client) *SecurityAssociationCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCipherSuite adds the cipherSuite to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithCipherSuite(cipherSuite *string) *SecurityAssociationCollectionGetParams {
	o.SetCipherSuite(cipherSuite)
	return o
}

// SetCipherSuite adds the cipherSuite to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetCipherSuite(cipherSuite *string) {
	o.CipherSuite = cipherSuite
}

// WithFields adds the fields to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithFields(fields []string) *SecurityAssociationCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIkeAuthentication adds the ikeAuthentication to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIkeAuthentication(ikeAuthentication *string) *SecurityAssociationCollectionGetParams {
	o.SetIkeAuthentication(ikeAuthentication)
	return o
}

// SetIkeAuthentication adds the ikeAuthentication to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIkeAuthentication(ikeAuthentication *string) {
	o.IkeAuthentication = ikeAuthentication
}

// WithIkeInitiatorSecurityParameterIndex adds the ikeInitiatorSecurityParameterIndex to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIkeInitiatorSecurityParameterIndex(ikeInitiatorSecurityParameterIndex *string) *SecurityAssociationCollectionGetParams {
	o.SetIkeInitiatorSecurityParameterIndex(ikeInitiatorSecurityParameterIndex)
	return o
}

// SetIkeInitiatorSecurityParameterIndex adds the ikeInitiatorSecurityParameterIndex to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIkeInitiatorSecurityParameterIndex(ikeInitiatorSecurityParameterIndex *string) {
	o.IkeInitiatorSecurityParameterIndex = ikeInitiatorSecurityParameterIndex
}

// WithIkeIsInitiator adds the ikeIsInitiator to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIkeIsInitiator(ikeIsInitiator *bool) *SecurityAssociationCollectionGetParams {
	o.SetIkeIsInitiator(ikeIsInitiator)
	return o
}

// SetIkeIsInitiator adds the ikeIsInitiator to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIkeIsInitiator(ikeIsInitiator *bool) {
	o.IkeIsInitiator = ikeIsInitiator
}

// WithIkeResponderSecurityParameterIndex adds the ikeResponderSecurityParameterIndex to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIkeResponderSecurityParameterIndex(ikeResponderSecurityParameterIndex *string) *SecurityAssociationCollectionGetParams {
	o.SetIkeResponderSecurityParameterIndex(ikeResponderSecurityParameterIndex)
	return o
}

// SetIkeResponderSecurityParameterIndex adds the ikeResponderSecurityParameterIndex to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIkeResponderSecurityParameterIndex(ikeResponderSecurityParameterIndex *string) {
	o.IkeResponderSecurityParameterIndex = ikeResponderSecurityParameterIndex
}

// WithIkeState adds the ikeState to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIkeState(ikeState *string) *SecurityAssociationCollectionGetParams {
	o.SetIkeState(ikeState)
	return o
}

// SetIkeState adds the ikeState to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIkeState(ikeState *string) {
	o.IkeState = ikeState
}

// WithIkeVersion adds the ikeVersion to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIkeVersion(ikeVersion *int64) *SecurityAssociationCollectionGetParams {
	o.SetIkeVersion(ikeVersion)
	return o
}

// SetIkeVersion adds the ikeVersion to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIkeVersion(ikeVersion *int64) {
	o.IkeVersion = ikeVersion
}

// WithIpsecAction adds the ipsecAction to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecAction(ipsecAction *string) *SecurityAssociationCollectionGetParams {
	o.SetIpsecAction(ipsecAction)
	return o
}

// SetIpsecAction adds the ipsecAction to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecAction(ipsecAction *string) {
	o.IpsecAction = ipsecAction
}

// WithIpsecInboundBytes adds the ipsecInboundBytes to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecInboundBytes(ipsecInboundBytes *int64) *SecurityAssociationCollectionGetParams {
	o.SetIpsecInboundBytes(ipsecInboundBytes)
	return o
}

// SetIpsecInboundBytes adds the ipsecInboundBytes to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecInboundBytes(ipsecInboundBytes *int64) {
	o.IpsecInboundBytes = ipsecInboundBytes
}

// WithIpsecInboundOffloadBytes adds the ipsecInboundOffloadBytes to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecInboundOffloadBytes(ipsecInboundOffloadBytes *int64) *SecurityAssociationCollectionGetParams {
	o.SetIpsecInboundOffloadBytes(ipsecInboundOffloadBytes)
	return o
}

// SetIpsecInboundOffloadBytes adds the ipsecInboundOffloadBytes to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecInboundOffloadBytes(ipsecInboundOffloadBytes *int64) {
	o.IpsecInboundOffloadBytes = ipsecInboundOffloadBytes
}

// WithIpsecInboundOffloadPackets adds the ipsecInboundOffloadPackets to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecInboundOffloadPackets(ipsecInboundOffloadPackets *int64) *SecurityAssociationCollectionGetParams {
	o.SetIpsecInboundOffloadPackets(ipsecInboundOffloadPackets)
	return o
}

// SetIpsecInboundOffloadPackets adds the ipsecInboundOffloadPackets to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecInboundOffloadPackets(ipsecInboundOffloadPackets *int64) {
	o.IpsecInboundOffloadPackets = ipsecInboundOffloadPackets
}

// WithIpsecInboundPackets adds the ipsecInboundPackets to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecInboundPackets(ipsecInboundPackets *int64) *SecurityAssociationCollectionGetParams {
	o.SetIpsecInboundPackets(ipsecInboundPackets)
	return o
}

// SetIpsecInboundPackets adds the ipsecInboundPackets to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecInboundPackets(ipsecInboundPackets *int64) {
	o.IpsecInboundPackets = ipsecInboundPackets
}

// WithIpsecInboundSecurityParameterIndex adds the ipsecInboundSecurityParameterIndex to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecInboundSecurityParameterIndex(ipsecInboundSecurityParameterIndex *string) *SecurityAssociationCollectionGetParams {
	o.SetIpsecInboundSecurityParameterIndex(ipsecInboundSecurityParameterIndex)
	return o
}

// SetIpsecInboundSecurityParameterIndex adds the ipsecInboundSecurityParameterIndex to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecInboundSecurityParameterIndex(ipsecInboundSecurityParameterIndex *string) {
	o.IpsecInboundSecurityParameterIndex = ipsecInboundSecurityParameterIndex
}

// WithIpsecOutboundBytes adds the ipsecOutboundBytes to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecOutboundBytes(ipsecOutboundBytes *int64) *SecurityAssociationCollectionGetParams {
	o.SetIpsecOutboundBytes(ipsecOutboundBytes)
	return o
}

// SetIpsecOutboundBytes adds the ipsecOutboundBytes to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecOutboundBytes(ipsecOutboundBytes *int64) {
	o.IpsecOutboundBytes = ipsecOutboundBytes
}

// WithIpsecOutboundOffloadBytes adds the ipsecOutboundOffloadBytes to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecOutboundOffloadBytes(ipsecOutboundOffloadBytes *int64) *SecurityAssociationCollectionGetParams {
	o.SetIpsecOutboundOffloadBytes(ipsecOutboundOffloadBytes)
	return o
}

// SetIpsecOutboundOffloadBytes adds the ipsecOutboundOffloadBytes to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecOutboundOffloadBytes(ipsecOutboundOffloadBytes *int64) {
	o.IpsecOutboundOffloadBytes = ipsecOutboundOffloadBytes
}

// WithIpsecOutboundOffloadPackets adds the ipsecOutboundOffloadPackets to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecOutboundOffloadPackets(ipsecOutboundOffloadPackets *int64) *SecurityAssociationCollectionGetParams {
	o.SetIpsecOutboundOffloadPackets(ipsecOutboundOffloadPackets)
	return o
}

// SetIpsecOutboundOffloadPackets adds the ipsecOutboundOffloadPackets to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecOutboundOffloadPackets(ipsecOutboundOffloadPackets *int64) {
	o.IpsecOutboundOffloadPackets = ipsecOutboundOffloadPackets
}

// WithIpsecOutboundPackets adds the ipsecOutboundPackets to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecOutboundPackets(ipsecOutboundPackets *int64) *SecurityAssociationCollectionGetParams {
	o.SetIpsecOutboundPackets(ipsecOutboundPackets)
	return o
}

// SetIpsecOutboundPackets adds the ipsecOutboundPackets to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecOutboundPackets(ipsecOutboundPackets *int64) {
	o.IpsecOutboundPackets = ipsecOutboundPackets
}

// WithIpsecOutboundSecurityParameterIndex adds the ipsecOutboundSecurityParameterIndex to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecOutboundSecurityParameterIndex(ipsecOutboundSecurityParameterIndex *string) *SecurityAssociationCollectionGetParams {
	o.SetIpsecOutboundSecurityParameterIndex(ipsecOutboundSecurityParameterIndex)
	return o
}

// SetIpsecOutboundSecurityParameterIndex adds the ipsecOutboundSecurityParameterIndex to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecOutboundSecurityParameterIndex(ipsecOutboundSecurityParameterIndex *string) {
	o.IpsecOutboundSecurityParameterIndex = ipsecOutboundSecurityParameterIndex
}

// WithIpsecState adds the ipsecState to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithIpsecState(ipsecState *string) *SecurityAssociationCollectionGetParams {
	o.SetIpsecState(ipsecState)
	return o
}

// SetIpsecState adds the ipsecState to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetIpsecState(ipsecState *string) {
	o.IpsecState = ipsecState
}

// WithLifetime adds the lifetime to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithLifetime(lifetime *int64) *SecurityAssociationCollectionGetParams {
	o.SetLifetime(lifetime)
	return o
}

// SetLifetime adds the lifetime to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetLifetime(lifetime *int64) {
	o.Lifetime = lifetime
}

// WithLocalAddress adds the localAddress to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithLocalAddress(localAddress *string) *SecurityAssociationCollectionGetParams {
	o.SetLocalAddress(localAddress)
	return o
}

// SetLocalAddress adds the localAddress to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetLocalAddress(localAddress *string) {
	o.LocalAddress = localAddress
}

// WithMaxRecords adds the maxRecords to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithMaxRecords(maxRecords *int64) *SecurityAssociationCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithNodeName(nodeName *string) *SecurityAssociationCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithNodeUUID(nodeUUID *string) *SecurityAssociationCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithOrderBy(orderBy []string) *SecurityAssociationCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPolicyName adds the policyName to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithPolicyName(policyName *string) *SecurityAssociationCollectionGetParams {
	o.SetPolicyName(policyName)
	return o
}

// SetPolicyName adds the policyName to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetPolicyName(policyName *string) {
	o.PolicyName = policyName
}

// WithRemoteAddress adds the remoteAddress to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithRemoteAddress(remoteAddress *string) *SecurityAssociationCollectionGetParams {
	o.SetRemoteAddress(remoteAddress)
	return o
}

// SetRemoteAddress adds the remoteAddress to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetRemoteAddress(remoteAddress *string) {
	o.RemoteAddress = remoteAddress
}

// WithReturnRecords adds the returnRecords to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithReturnRecords(returnRecords *bool) *SecurityAssociationCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SecurityAssociationCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithScope(scope *string) *SecurityAssociationCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSvmName adds the svmName to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithSvmName(svmName *string) *SecurityAssociationCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithSvmUUID(svmUUID *string) *SecurityAssociationCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithType(typeVar *string) *SecurityAssociationCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) WithUUID(uuid *string) *SecurityAssociationCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the security association collection get params
func (o *SecurityAssociationCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityAssociationCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CipherSuite != nil {

		// query param cipher_suite
		var qrCipherSuite string

		if o.CipherSuite != nil {
			qrCipherSuite = *o.CipherSuite
		}
		qCipherSuite := qrCipherSuite
		if qCipherSuite != "" {

			if err := r.SetQueryParam("cipher_suite", qCipherSuite); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IkeAuthentication != nil {

		// query param ike.authentication
		var qrIkeAuthentication string

		if o.IkeAuthentication != nil {
			qrIkeAuthentication = *o.IkeAuthentication
		}
		qIkeAuthentication := qrIkeAuthentication
		if qIkeAuthentication != "" {

			if err := r.SetQueryParam("ike.authentication", qIkeAuthentication); err != nil {
				return err
			}
		}
	}

	if o.IkeInitiatorSecurityParameterIndex != nil {

		// query param ike.initiator_security_parameter_index
		var qrIkeInitiatorSecurityParameterIndex string

		if o.IkeInitiatorSecurityParameterIndex != nil {
			qrIkeInitiatorSecurityParameterIndex = *o.IkeInitiatorSecurityParameterIndex
		}
		qIkeInitiatorSecurityParameterIndex := qrIkeInitiatorSecurityParameterIndex
		if qIkeInitiatorSecurityParameterIndex != "" {

			if err := r.SetQueryParam("ike.initiator_security_parameter_index", qIkeInitiatorSecurityParameterIndex); err != nil {
				return err
			}
		}
	}

	if o.IkeIsInitiator != nil {

		// query param ike.is_initiator
		var qrIkeIsInitiator bool

		if o.IkeIsInitiator != nil {
			qrIkeIsInitiator = *o.IkeIsInitiator
		}
		qIkeIsInitiator := swag.FormatBool(qrIkeIsInitiator)
		if qIkeIsInitiator != "" {

			if err := r.SetQueryParam("ike.is_initiator", qIkeIsInitiator); err != nil {
				return err
			}
		}
	}

	if o.IkeResponderSecurityParameterIndex != nil {

		// query param ike.responder_security_parameter_index
		var qrIkeResponderSecurityParameterIndex string

		if o.IkeResponderSecurityParameterIndex != nil {
			qrIkeResponderSecurityParameterIndex = *o.IkeResponderSecurityParameterIndex
		}
		qIkeResponderSecurityParameterIndex := qrIkeResponderSecurityParameterIndex
		if qIkeResponderSecurityParameterIndex != "" {

			if err := r.SetQueryParam("ike.responder_security_parameter_index", qIkeResponderSecurityParameterIndex); err != nil {
				return err
			}
		}
	}

	if o.IkeState != nil {

		// query param ike.state
		var qrIkeState string

		if o.IkeState != nil {
			qrIkeState = *o.IkeState
		}
		qIkeState := qrIkeState
		if qIkeState != "" {

			if err := r.SetQueryParam("ike.state", qIkeState); err != nil {
				return err
			}
		}
	}

	if o.IkeVersion != nil {

		// query param ike.version
		var qrIkeVersion int64

		if o.IkeVersion != nil {
			qrIkeVersion = *o.IkeVersion
		}
		qIkeVersion := swag.FormatInt64(qrIkeVersion)
		if qIkeVersion != "" {

			if err := r.SetQueryParam("ike.version", qIkeVersion); err != nil {
				return err
			}
		}
	}

	if o.IpsecAction != nil {

		// query param ipsec.action
		var qrIpsecAction string

		if o.IpsecAction != nil {
			qrIpsecAction = *o.IpsecAction
		}
		qIpsecAction := qrIpsecAction
		if qIpsecAction != "" {

			if err := r.SetQueryParam("ipsec.action", qIpsecAction); err != nil {
				return err
			}
		}
	}

	if o.IpsecInboundBytes != nil {

		// query param ipsec.inbound.bytes
		var qrIpsecInboundBytes int64

		if o.IpsecInboundBytes != nil {
			qrIpsecInboundBytes = *o.IpsecInboundBytes
		}
		qIpsecInboundBytes := swag.FormatInt64(qrIpsecInboundBytes)
		if qIpsecInboundBytes != "" {

			if err := r.SetQueryParam("ipsec.inbound.bytes", qIpsecInboundBytes); err != nil {
				return err
			}
		}
	}

	if o.IpsecInboundOffloadBytes != nil {

		// query param ipsec.inbound.offload_bytes
		var qrIpsecInboundOffloadBytes int64

		if o.IpsecInboundOffloadBytes != nil {
			qrIpsecInboundOffloadBytes = *o.IpsecInboundOffloadBytes
		}
		qIpsecInboundOffloadBytes := swag.FormatInt64(qrIpsecInboundOffloadBytes)
		if qIpsecInboundOffloadBytes != "" {

			if err := r.SetQueryParam("ipsec.inbound.offload_bytes", qIpsecInboundOffloadBytes); err != nil {
				return err
			}
		}
	}

	if o.IpsecInboundOffloadPackets != nil {

		// query param ipsec.inbound.offload_packets
		var qrIpsecInboundOffloadPackets int64

		if o.IpsecInboundOffloadPackets != nil {
			qrIpsecInboundOffloadPackets = *o.IpsecInboundOffloadPackets
		}
		qIpsecInboundOffloadPackets := swag.FormatInt64(qrIpsecInboundOffloadPackets)
		if qIpsecInboundOffloadPackets != "" {

			if err := r.SetQueryParam("ipsec.inbound.offload_packets", qIpsecInboundOffloadPackets); err != nil {
				return err
			}
		}
	}

	if o.IpsecInboundPackets != nil {

		// query param ipsec.inbound.packets
		var qrIpsecInboundPackets int64

		if o.IpsecInboundPackets != nil {
			qrIpsecInboundPackets = *o.IpsecInboundPackets
		}
		qIpsecInboundPackets := swag.FormatInt64(qrIpsecInboundPackets)
		if qIpsecInboundPackets != "" {

			if err := r.SetQueryParam("ipsec.inbound.packets", qIpsecInboundPackets); err != nil {
				return err
			}
		}
	}

	if o.IpsecInboundSecurityParameterIndex != nil {

		// query param ipsec.inbound.security_parameter_index
		var qrIpsecInboundSecurityParameterIndex string

		if o.IpsecInboundSecurityParameterIndex != nil {
			qrIpsecInboundSecurityParameterIndex = *o.IpsecInboundSecurityParameterIndex
		}
		qIpsecInboundSecurityParameterIndex := qrIpsecInboundSecurityParameterIndex
		if qIpsecInboundSecurityParameterIndex != "" {

			if err := r.SetQueryParam("ipsec.inbound.security_parameter_index", qIpsecInboundSecurityParameterIndex); err != nil {
				return err
			}
		}
	}

	if o.IpsecOutboundBytes != nil {

		// query param ipsec.outbound.bytes
		var qrIpsecOutboundBytes int64

		if o.IpsecOutboundBytes != nil {
			qrIpsecOutboundBytes = *o.IpsecOutboundBytes
		}
		qIpsecOutboundBytes := swag.FormatInt64(qrIpsecOutboundBytes)
		if qIpsecOutboundBytes != "" {

			if err := r.SetQueryParam("ipsec.outbound.bytes", qIpsecOutboundBytes); err != nil {
				return err
			}
		}
	}

	if o.IpsecOutboundOffloadBytes != nil {

		// query param ipsec.outbound.offload_bytes
		var qrIpsecOutboundOffloadBytes int64

		if o.IpsecOutboundOffloadBytes != nil {
			qrIpsecOutboundOffloadBytes = *o.IpsecOutboundOffloadBytes
		}
		qIpsecOutboundOffloadBytes := swag.FormatInt64(qrIpsecOutboundOffloadBytes)
		if qIpsecOutboundOffloadBytes != "" {

			if err := r.SetQueryParam("ipsec.outbound.offload_bytes", qIpsecOutboundOffloadBytes); err != nil {
				return err
			}
		}
	}

	if o.IpsecOutboundOffloadPackets != nil {

		// query param ipsec.outbound.offload_packets
		var qrIpsecOutboundOffloadPackets int64

		if o.IpsecOutboundOffloadPackets != nil {
			qrIpsecOutboundOffloadPackets = *o.IpsecOutboundOffloadPackets
		}
		qIpsecOutboundOffloadPackets := swag.FormatInt64(qrIpsecOutboundOffloadPackets)
		if qIpsecOutboundOffloadPackets != "" {

			if err := r.SetQueryParam("ipsec.outbound.offload_packets", qIpsecOutboundOffloadPackets); err != nil {
				return err
			}
		}
	}

	if o.IpsecOutboundPackets != nil {

		// query param ipsec.outbound.packets
		var qrIpsecOutboundPackets int64

		if o.IpsecOutboundPackets != nil {
			qrIpsecOutboundPackets = *o.IpsecOutboundPackets
		}
		qIpsecOutboundPackets := swag.FormatInt64(qrIpsecOutboundPackets)
		if qIpsecOutboundPackets != "" {

			if err := r.SetQueryParam("ipsec.outbound.packets", qIpsecOutboundPackets); err != nil {
				return err
			}
		}
	}

	if o.IpsecOutboundSecurityParameterIndex != nil {

		// query param ipsec.outbound.security_parameter_index
		var qrIpsecOutboundSecurityParameterIndex string

		if o.IpsecOutboundSecurityParameterIndex != nil {
			qrIpsecOutboundSecurityParameterIndex = *o.IpsecOutboundSecurityParameterIndex
		}
		qIpsecOutboundSecurityParameterIndex := qrIpsecOutboundSecurityParameterIndex
		if qIpsecOutboundSecurityParameterIndex != "" {

			if err := r.SetQueryParam("ipsec.outbound.security_parameter_index", qIpsecOutboundSecurityParameterIndex); err != nil {
				return err
			}
		}
	}

	if o.IpsecState != nil {

		// query param ipsec.state
		var qrIpsecState string

		if o.IpsecState != nil {
			qrIpsecState = *o.IpsecState
		}
		qIpsecState := qrIpsecState
		if qIpsecState != "" {

			if err := r.SetQueryParam("ipsec.state", qIpsecState); err != nil {
				return err
			}
		}
	}

	if o.Lifetime != nil {

		// query param lifetime
		var qrLifetime int64

		if o.Lifetime != nil {
			qrLifetime = *o.Lifetime
		}
		qLifetime := swag.FormatInt64(qrLifetime)
		if qLifetime != "" {

			if err := r.SetQueryParam("lifetime", qLifetime); err != nil {
				return err
			}
		}
	}

	if o.LocalAddress != nil {

		// query param local_address
		var qrLocalAddress string

		if o.LocalAddress != nil {
			qrLocalAddress = *o.LocalAddress
		}
		qLocalAddress := qrLocalAddress
		if qLocalAddress != "" {

			if err := r.SetQueryParam("local_address", qLocalAddress); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PolicyName != nil {

		// query param policy_name
		var qrPolicyName string

		if o.PolicyName != nil {
			qrPolicyName = *o.PolicyName
		}
		qPolicyName := qrPolicyName
		if qPolicyName != "" {

			if err := r.SetQueryParam("policy_name", qPolicyName); err != nil {
				return err
			}
		}
	}

	if o.RemoteAddress != nil {

		// query param remote_address
		var qrRemoteAddress string

		if o.RemoteAddress != nil {
			qrRemoteAddress = *o.RemoteAddress
		}
		qRemoteAddress := qrRemoteAddress
		if qRemoteAddress != "" {

			if err := r.SetQueryParam("remote_address", qRemoteAddress); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityAssociationCollectionGet binds the parameter fields
func (o *SecurityAssociationCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSecurityAssociationCollectionGet binds the parameter order_by
func (o *SecurityAssociationCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
