// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityAssociationGetParams creates a new SecurityAssociationGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityAssociationGetParams() *SecurityAssociationGetParams {
	return &SecurityAssociationGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityAssociationGetParamsWithTimeout creates a new SecurityAssociationGetParams object
// with the ability to set a timeout on a request.
func NewSecurityAssociationGetParamsWithTimeout(timeout time.Duration) *SecurityAssociationGetParams {
	return &SecurityAssociationGetParams{
		timeout: timeout,
	}
}

// NewSecurityAssociationGetParamsWithContext creates a new SecurityAssociationGetParams object
// with the ability to set a context for a request.
func NewSecurityAssociationGetParamsWithContext(ctx context.Context) *SecurityAssociationGetParams {
	return &SecurityAssociationGetParams{
		Context: ctx,
	}
}

// NewSecurityAssociationGetParamsWithHTTPClient creates a new SecurityAssociationGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityAssociationGetParamsWithHTTPClient(client *http.Client) *SecurityAssociationGetParams {
	return &SecurityAssociationGetParams{
		HTTPClient: client,
	}
}

/*
SecurityAssociationGetParams contains all the parameters to send to the API endpoint

	for the security association get operation.

	Typically these are written to a http.Request.
*/
type SecurityAssociationGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   UUID of IPsec or IKE security association.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security association get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityAssociationGetParams) WithDefaults() *SecurityAssociationGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security association get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityAssociationGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security association get params
func (o *SecurityAssociationGetParams) WithTimeout(timeout time.Duration) *SecurityAssociationGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security association get params
func (o *SecurityAssociationGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security association get params
func (o *SecurityAssociationGetParams) WithContext(ctx context.Context) *SecurityAssociationGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security association get params
func (o *SecurityAssociationGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security association get params
func (o *SecurityAssociationGetParams) WithHTTPClient(client *http.Client) *SecurityAssociationGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security association get params
func (o *SecurityAssociationGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the security association get params
func (o *SecurityAssociationGetParams) WithFields(fields []string) *SecurityAssociationGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security association get params
func (o *SecurityAssociationGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the security association get params
func (o *SecurityAssociationGetParams) WithUUID(uuid string) *SecurityAssociationGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the security association get params
func (o *SecurityAssociationGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityAssociationGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityAssociationGet binds the parameter fields
func (o *SecurityAssociationGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
