// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityAuditGetReader is a Reader for the SecurityAuditGet structure.
type SecurityAuditGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityAuditGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityAuditGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityAuditGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityAuditGetOK creates a SecurityAuditGetOK with default headers values
func NewSecurityAuditGetOK() *SecurityAuditGetOK {
	return &SecurityAuditGetOK{}
}

/*
SecurityAuditGetOK describes a response with status code 200, with default header values.

OK
*/
type SecurityAuditGetOK struct {
	Payload *models.SecurityAudit
}

// IsSuccess returns true when this security audit get o k response has a 2xx status code
func (o *SecurityAuditGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security audit get o k response has a 3xx status code
func (o *SecurityAuditGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security audit get o k response has a 4xx status code
func (o *SecurityAuditGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security audit get o k response has a 5xx status code
func (o *SecurityAuditGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security audit get o k response a status code equal to that given
func (o *SecurityAuditGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security audit get o k response
func (o *SecurityAuditGetOK) Code() int {
	return 200
}

func (o *SecurityAuditGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/audit][%d] securityAuditGetOK %s", 200, payload)
}

func (o *SecurityAuditGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/audit][%d] securityAuditGetOK %s", 200, payload)
}

func (o *SecurityAuditGetOK) GetPayload() *models.SecurityAudit {
	return o.Payload
}

func (o *SecurityAuditGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityAudit)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityAuditGetDefault creates a SecurityAuditGetDefault with default headers values
func NewSecurityAuditGetDefault(code int) *SecurityAuditGetDefault {
	return &SecurityAuditGetDefault{
		_statusCode: code,
	}
}

/*
SecurityAuditGetDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityAuditGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security audit get default response has a 2xx status code
func (o *SecurityAuditGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security audit get default response has a 3xx status code
func (o *SecurityAuditGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security audit get default response has a 4xx status code
func (o *SecurityAuditGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security audit get default response has a 5xx status code
func (o *SecurityAuditGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security audit get default response a status code equal to that given
func (o *SecurityAuditGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security audit get default response
func (o *SecurityAuditGetDefault) Code() int {
	return o._statusCode
}

func (o *SecurityAuditGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/audit][%d] security_audit_get default %s", o._statusCode, payload)
}

func (o *SecurityAuditGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/audit][%d] security_audit_get default %s", o._statusCode, payload)
}

func (o *SecurityAuditGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityAuditGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
