// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityAuditLogCollectionGetParams creates a new SecurityAuditLogCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityAuditLogCollectionGetParams() *SecurityAuditLogCollectionGetParams {
	return &SecurityAuditLogCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityAuditLogCollectionGetParamsWithTimeout creates a new SecurityAuditLogCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSecurityAuditLogCollectionGetParamsWithTimeout(timeout time.Duration) *SecurityAuditLogCollectionGetParams {
	return &SecurityAuditLogCollectionGetParams{
		timeout: timeout,
	}
}

// NewSecurityAuditLogCollectionGetParamsWithContext creates a new SecurityAuditLogCollectionGetParams object
// with the ability to set a context for a request.
func NewSecurityAuditLogCollectionGetParamsWithContext(ctx context.Context) *SecurityAuditLogCollectionGetParams {
	return &SecurityAuditLogCollectionGetParams{
		Context: ctx,
	}
}

// NewSecurityAuditLogCollectionGetParamsWithHTTPClient creates a new SecurityAuditLogCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityAuditLogCollectionGetParamsWithHTTPClient(client *http.Client) *SecurityAuditLogCollectionGetParams {
	return &SecurityAuditLogCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SecurityAuditLogCollectionGetParams contains all the parameters to send to the API endpoint

	for the security audit log collection get operation.

	Typically these are written to a http.Request.
*/
type SecurityAuditLogCollectionGetParams struct {

	/* Application.

	   Filter by application
	*/
	Application *string

	/* CommandID.

	   Filter by command_id
	*/
	CommandID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* Input.

	   Filter by input
	*/
	Input *string

	/* Location.

	   Filter by location
	*/
	Location *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Message.

	   Filter by message
	*/
	Message *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Role.

	   Filter by role
	*/
	Role *string

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SessionID.

	   Filter by session_id
	*/
	SessionID *string

	/* State.

	   Filter by state
	*/
	State *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	/* User.

	   Filter by user
	*/
	User *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security audit log collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityAuditLogCollectionGetParams) WithDefaults() *SecurityAuditLogCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security audit log collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityAuditLogCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SecurityAuditLogCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithTimeout(timeout time.Duration) *SecurityAuditLogCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithContext(ctx context.Context) *SecurityAuditLogCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithHTTPClient(client *http.Client) *SecurityAuditLogCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplication adds the application to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithApplication(application *string) *SecurityAuditLogCollectionGetParams {
	o.SetApplication(application)
	return o
}

// SetApplication adds the application to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetApplication(application *string) {
	o.Application = application
}

// WithCommandID adds the commandID to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithCommandID(commandID *string) *SecurityAuditLogCollectionGetParams {
	o.SetCommandID(commandID)
	return o
}

// SetCommandID adds the commandId to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetCommandID(commandID *string) {
	o.CommandID = commandID
}

// WithFields adds the fields to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithFields(fields []string) *SecurityAuditLogCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIndex adds the index to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithIndex(index *int64) *SecurityAuditLogCollectionGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetIndex(index *int64) {
	o.Index = index
}

// WithInput adds the input to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithInput(input *string) *SecurityAuditLogCollectionGetParams {
	o.SetInput(input)
	return o
}

// SetInput adds the input to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetInput(input *string) {
	o.Input = input
}

// WithLocation adds the location to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithLocation(location *string) *SecurityAuditLogCollectionGetParams {
	o.SetLocation(location)
	return o
}

// SetLocation adds the location to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetLocation(location *string) {
	o.Location = location
}

// WithMaxRecords adds the maxRecords to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithMaxRecords(maxRecords *int64) *SecurityAuditLogCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMessage adds the message to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithMessage(message *string) *SecurityAuditLogCollectionGetParams {
	o.SetMessage(message)
	return o
}

// SetMessage adds the message to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetMessage(message *string) {
	o.Message = message
}

// WithNodeName adds the nodeName to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithNodeName(nodeName *string) *SecurityAuditLogCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithNodeUUID(nodeUUID *string) *SecurityAuditLogCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithOrderBy(orderBy []string) *SecurityAuditLogCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithReturnRecords(returnRecords *bool) *SecurityAuditLogCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SecurityAuditLogCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRole adds the role to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithRole(role *string) *SecurityAuditLogCollectionGetParams {
	o.SetRole(role)
	return o
}

// SetRole adds the role to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetRole(role *string) {
	o.Role = role
}

// WithScope adds the scope to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithScope(scope *string) *SecurityAuditLogCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSessionID adds the sessionID to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithSessionID(sessionID *string) *SecurityAuditLogCollectionGetParams {
	o.SetSessionID(sessionID)
	return o
}

// SetSessionID adds the sessionId to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetSessionID(sessionID *string) {
	o.SessionID = sessionID
}

// WithState adds the state to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithState(state *string) *SecurityAuditLogCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithSvmName adds the svmName to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithSvmName(svmName *string) *SecurityAuditLogCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithTimestamp adds the timestamp to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithTimestamp(timestamp *string) *SecurityAuditLogCollectionGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WithUser adds the user to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) WithUser(user *string) *SecurityAuditLogCollectionGetParams {
	o.SetUser(user)
	return o
}

// SetUser adds the user to the security audit log collection get params
func (o *SecurityAuditLogCollectionGetParams) SetUser(user *string) {
	o.User = user
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityAuditLogCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Application != nil {

		// query param application
		var qrApplication string

		if o.Application != nil {
			qrApplication = *o.Application
		}
		qApplication := qrApplication
		if qApplication != "" {

			if err := r.SetQueryParam("application", qApplication); err != nil {
				return err
			}
		}
	}

	if o.CommandID != nil {

		// query param command_id
		var qrCommandID string

		if o.CommandID != nil {
			qrCommandID = *o.CommandID
		}
		qCommandID := qrCommandID
		if qCommandID != "" {

			if err := r.SetQueryParam("command_id", qCommandID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}

	if o.Input != nil {

		// query param input
		var qrInput string

		if o.Input != nil {
			qrInput = *o.Input
		}
		qInput := qrInput
		if qInput != "" {

			if err := r.SetQueryParam("input", qInput); err != nil {
				return err
			}
		}
	}

	if o.Location != nil {

		// query param location
		var qrLocation string

		if o.Location != nil {
			qrLocation = *o.Location
		}
		qLocation := qrLocation
		if qLocation != "" {

			if err := r.SetQueryParam("location", qLocation); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Message != nil {

		// query param message
		var qrMessage string

		if o.Message != nil {
			qrMessage = *o.Message
		}
		qMessage := qrMessage
		if qMessage != "" {

			if err := r.SetQueryParam("message", qMessage); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Role != nil {

		// query param role
		var qrRole string

		if o.Role != nil {
			qrRole = *o.Role
		}
		qRole := qrRole
		if qRole != "" {

			if err := r.SetQueryParam("role", qRole); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SessionID != nil {

		// query param session_id
		var qrSessionID string

		if o.SessionID != nil {
			qrSessionID = *o.SessionID
		}
		qSessionID := qrSessionID
		if qSessionID != "" {

			if err := r.SetQueryParam("session_id", qSessionID); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	if o.User != nil {

		// query param user
		var qrUser string

		if o.User != nil {
			qrUser = *o.User
		}
		qUser := qrUser
		if qUser != "" {

			if err := r.SetQueryParam("user", qUser); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityAuditLogCollectionGet binds the parameter fields
func (o *SecurityAuditLogCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSecurityAuditLogCollectionGet binds the parameter order_by
func (o *SecurityAuditLogCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
