// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityAuditModifyReader is a Reader for the SecurityAuditModify structure.
type SecurityAuditModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityAuditModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityAuditModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityAuditModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityAuditModifyOK creates a SecurityAuditModifyOK with default headers values
func NewSecurityAuditModifyOK() *SecurityAuditModifyOK {
	return &SecurityAuditModifyOK{}
}

/*
SecurityAuditModifyOK describes a response with status code 200, with default header values.

OK
*/
type SecurityAuditModifyOK struct {
	Payload *models.SecurityAudit
}

// IsSuccess returns true when this security audit modify o k response has a 2xx status code
func (o *SecurityAuditModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security audit modify o k response has a 3xx status code
func (o *SecurityAuditModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security audit modify o k response has a 4xx status code
func (o *SecurityAuditModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security audit modify o k response has a 5xx status code
func (o *SecurityAuditModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security audit modify o k response a status code equal to that given
func (o *SecurityAuditModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security audit modify o k response
func (o *SecurityAuditModifyOK) Code() int {
	return 200
}

func (o *SecurityAuditModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit][%d] securityAuditModifyOK %s", 200, payload)
}

func (o *SecurityAuditModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit][%d] securityAuditModifyOK %s", 200, payload)
}

func (o *SecurityAuditModifyOK) GetPayload() *models.SecurityAudit {
	return o.Payload
}

func (o *SecurityAuditModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityAudit)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityAuditModifyDefault creates a SecurityAuditModifyDefault with default headers values
func NewSecurityAuditModifyDefault(code int) *SecurityAuditModifyDefault {
	return &SecurityAuditModifyDefault{
		_statusCode: code,
	}
}

/*
SecurityAuditModifyDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityAuditModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security audit modify default response has a 2xx status code
func (o *SecurityAuditModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security audit modify default response has a 3xx status code
func (o *SecurityAuditModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security audit modify default response has a 4xx status code
func (o *SecurityAuditModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security audit modify default response has a 5xx status code
func (o *SecurityAuditModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security audit modify default response a status code equal to that given
func (o *SecurityAuditModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security audit modify default response
func (o *SecurityAuditModifyDefault) Code() int {
	return o._statusCode
}

func (o *SecurityAuditModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit][%d] security_audit_modify default %s", o._statusCode, payload)
}

func (o *SecurityAuditModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/audit][%d] security_audit_modify default %s", o._statusCode, payload)
}

func (o *SecurityAuditModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityAuditModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
