// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityCertificateCollectionGetReader is a Reader for the SecurityCertificateCollectionGet structure.
type SecurityCertificateCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityCertificateCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityCertificateCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityCertificateCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityCertificateCollectionGetOK creates a SecurityCertificateCollectionGetOK with default headers values
func NewSecurityCertificateCollectionGetOK() *SecurityCertificateCollectionGetOK {
	return &SecurityCertificateCollectionGetOK{}
}

/*
SecurityCertificateCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SecurityCertificateCollectionGetOK struct {
	Payload *models.SecurityCertificateResponse
}

// IsSuccess returns true when this security certificate collection get o k response has a 2xx status code
func (o *SecurityCertificateCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security certificate collection get o k response has a 3xx status code
func (o *SecurityCertificateCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security certificate collection get o k response has a 4xx status code
func (o *SecurityCertificateCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security certificate collection get o k response has a 5xx status code
func (o *SecurityCertificateCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security certificate collection get o k response a status code equal to that given
func (o *SecurityCertificateCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security certificate collection get o k response
func (o *SecurityCertificateCollectionGetOK) Code() int {
	return 200
}

func (o *SecurityCertificateCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/certificates][%d] securityCertificateCollectionGetOK %s", 200, payload)
}

func (o *SecurityCertificateCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/certificates][%d] securityCertificateCollectionGetOK %s", 200, payload)
}

func (o *SecurityCertificateCollectionGetOK) GetPayload() *models.SecurityCertificateResponse {
	return o.Payload
}

func (o *SecurityCertificateCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityCertificateResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityCertificateCollectionGetDefault creates a SecurityCertificateCollectionGetDefault with default headers values
func NewSecurityCertificateCollectionGetDefault(code int) *SecurityCertificateCollectionGetDefault {
	return &SecurityCertificateCollectionGetDefault{
		_statusCode: code,
	}
}

/*
SecurityCertificateCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityCertificateCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security certificate collection get default response has a 2xx status code
func (o *SecurityCertificateCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security certificate collection get default response has a 3xx status code
func (o *SecurityCertificateCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security certificate collection get default response has a 4xx status code
func (o *SecurityCertificateCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security certificate collection get default response has a 5xx status code
func (o *SecurityCertificateCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security certificate collection get default response a status code equal to that given
func (o *SecurityCertificateCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security certificate collection get default response
func (o *SecurityCertificateCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SecurityCertificateCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/certificates][%d] security_certificate_collection_get default %s", o._statusCode, payload)
}

func (o *SecurityCertificateCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/certificates][%d] security_certificate_collection_get default %s", o._statusCode, payload)
}

func (o *SecurityCertificateCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityCertificateCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
