// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSecurityCertificateCreateParams creates a new SecurityCertificateCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityCertificateCreateParams() *SecurityCertificateCreateParams {
	return &SecurityCertificateCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityCertificateCreateParamsWithTimeout creates a new SecurityCertificateCreateParams object
// with the ability to set a timeout on a request.
func NewSecurityCertificateCreateParamsWithTimeout(timeout time.Duration) *SecurityCertificateCreateParams {
	return &SecurityCertificateCreateParams{
		timeout: timeout,
	}
}

// NewSecurityCertificateCreateParamsWithContext creates a new SecurityCertificateCreateParams object
// with the ability to set a context for a request.
func NewSecurityCertificateCreateParamsWithContext(ctx context.Context) *SecurityCertificateCreateParams {
	return &SecurityCertificateCreateParams{
		Context: ctx,
	}
}

// NewSecurityCertificateCreateParamsWithHTTPClient creates a new SecurityCertificateCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityCertificateCreateParamsWithHTTPClient(client *http.Client) *SecurityCertificateCreateParams {
	return &SecurityCertificateCreateParams{
		HTTPClient: client,
	}
}

/*
SecurityCertificateCreateParams contains all the parameters to send to the API endpoint

	for the security certificate create operation.

	Typically these are written to a http.Request.
*/
type SecurityCertificateCreateParams struct {

	/* Info.

	   Information specification
	*/
	Info *models.SecurityCertificate

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security certificate create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityCertificateCreateParams) WithDefaults() *SecurityCertificateCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security certificate create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityCertificateCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := SecurityCertificateCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security certificate create params
func (o *SecurityCertificateCreateParams) WithTimeout(timeout time.Duration) *SecurityCertificateCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security certificate create params
func (o *SecurityCertificateCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security certificate create params
func (o *SecurityCertificateCreateParams) WithContext(ctx context.Context) *SecurityCertificateCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security certificate create params
func (o *SecurityCertificateCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security certificate create params
func (o *SecurityCertificateCreateParams) WithHTTPClient(client *http.Client) *SecurityCertificateCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security certificate create params
func (o *SecurityCertificateCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the security certificate create params
func (o *SecurityCertificateCreateParams) WithInfo(info *models.SecurityCertificate) *SecurityCertificateCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security certificate create params
func (o *SecurityCertificateCreateParams) SetInfo(info *models.SecurityCertificate) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the security certificate create params
func (o *SecurityCertificateCreateParams) WithReturnRecords(returnRecords *bool) *SecurityCertificateCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security certificate create params
func (o *SecurityCertificateCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityCertificateCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
