// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityCertificateDeleteReader is a Reader for the SecurityCertificateDelete structure.
type SecurityCertificateDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityCertificateDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityCertificateDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityCertificateDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityCertificateDeleteOK creates a SecurityCertificateDeleteOK with default headers values
func NewSecurityCertificateDeleteOK() *SecurityCertificateDeleteOK {
	return &SecurityCertificateDeleteOK{}
}

/*
SecurityCertificateDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SecurityCertificateDeleteOK struct {
}

// IsSuccess returns true when this security certificate delete o k response has a 2xx status code
func (o *SecurityCertificateDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security certificate delete o k response has a 3xx status code
func (o *SecurityCertificateDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security certificate delete o k response has a 4xx status code
func (o *SecurityCertificateDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security certificate delete o k response has a 5xx status code
func (o *SecurityCertificateDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security certificate delete o k response a status code equal to that given
func (o *SecurityCertificateDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security certificate delete o k response
func (o *SecurityCertificateDeleteOK) Code() int {
	return 200
}

func (o *SecurityCertificateDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /security/certificates/{uuid}][%d] securityCertificateDeleteOK", 200)
}

func (o *SecurityCertificateDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /security/certificates/{uuid}][%d] securityCertificateDeleteOK", 200)
}

func (o *SecurityCertificateDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityCertificateDeleteDefault creates a SecurityCertificateDeleteDefault with default headers values
func NewSecurityCertificateDeleteDefault(code int) *SecurityCertificateDeleteDefault {
	return &SecurityCertificateDeleteDefault{
		_statusCode: code,
	}
}

/*
	SecurityCertificateDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 3735644    | Cannot delete server-chain certificate. Reason: There is a corresponding server certificate for it. |
| 3735679    | Cannot delete pre-installed server_ca certificates through REST. Use CLI or ZAPI. |
| 3735650    | Deleting this client_ca certificate directly is not supported. Delete the corresponding root-ca certificate using type `root_ca` to delete the root, client, and server certificates. |
| 3735627    | Deleting this server_ca certificate directly is not supported. Delete the corresponding root-ca certificate using type `root_ca` to delete the root, client, and server certificates. |
| 3735589    | Cannot delete certificate. |
| 3735590    | Cannot delete certificate. Failed to remove SSL configuration for the certificate. |
| 3735683    | Cannot remove this certificate while external key manager is configured. |
| 3735681    | Cannot delete preinstalled `server-ca` certificates. Use the CLI to complete the operation. |
| 52560272   | The certificate could not be removed due to being in use by one or more subsystems. |
*/
type SecurityCertificateDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security certificate delete default response has a 2xx status code
func (o *SecurityCertificateDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security certificate delete default response has a 3xx status code
func (o *SecurityCertificateDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security certificate delete default response has a 4xx status code
func (o *SecurityCertificateDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security certificate delete default response has a 5xx status code
func (o *SecurityCertificateDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security certificate delete default response a status code equal to that given
func (o *SecurityCertificateDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security certificate delete default response
func (o *SecurityCertificateDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SecurityCertificateDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/certificates/{uuid}][%d] security_certificate_delete default %s", o._statusCode, payload)
}

func (o *SecurityCertificateDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/certificates/{uuid}][%d] security_certificate_delete default %s", o._statusCode, payload)
}

func (o *SecurityCertificateDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityCertificateDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
