// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityCertificateGetReader is a Reader for the SecurityCertificateGet structure.
type SecurityCertificateGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityCertificateGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityCertificateGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityCertificateGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityCertificateGetOK creates a SecurityCertificateGetOK with default headers values
func NewSecurityCertificateGetOK() *SecurityCertificateGetOK {
	return &SecurityCertificateGetOK{}
}

/*
SecurityCertificateGetOK describes a response with status code 200, with default header values.

OK
*/
type SecurityCertificateGetOK struct {
	Payload *models.SecurityCertificate
}

// IsSuccess returns true when this security certificate get o k response has a 2xx status code
func (o *SecurityCertificateGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security certificate get o k response has a 3xx status code
func (o *SecurityCertificateGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security certificate get o k response has a 4xx status code
func (o *SecurityCertificateGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security certificate get o k response has a 5xx status code
func (o *SecurityCertificateGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security certificate get o k response a status code equal to that given
func (o *SecurityCertificateGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security certificate get o k response
func (o *SecurityCertificateGetOK) Code() int {
	return 200
}

func (o *SecurityCertificateGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/certificates/{uuid}][%d] securityCertificateGetOK %s", 200, payload)
}

func (o *SecurityCertificateGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/certificates/{uuid}][%d] securityCertificateGetOK %s", 200, payload)
}

func (o *SecurityCertificateGetOK) GetPayload() *models.SecurityCertificate {
	return o.Payload
}

func (o *SecurityCertificateGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityCertificate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityCertificateGetDefault creates a SecurityCertificateGetDefault with default headers values
func NewSecurityCertificateGetDefault(code int) *SecurityCertificateGetDefault {
	return &SecurityCertificateGetDefault{
		_statusCode: code,
	}
}

/*
SecurityCertificateGetDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityCertificateGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security certificate get default response has a 2xx status code
func (o *SecurityCertificateGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security certificate get default response has a 3xx status code
func (o *SecurityCertificateGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security certificate get default response has a 4xx status code
func (o *SecurityCertificateGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security certificate get default response has a 5xx status code
func (o *SecurityCertificateGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security certificate get default response a status code equal to that given
func (o *SecurityCertificateGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security certificate get default response
func (o *SecurityCertificateGetDefault) Code() int {
	return o._statusCode
}

func (o *SecurityCertificateGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/certificates/{uuid}][%d] security_certificate_get default %s", o._statusCode, payload)
}

func (o *SecurityCertificateGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/certificates/{uuid}][%d] security_certificate_get default %s", o._statusCode, payload)
}

func (o *SecurityCertificateGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityCertificateGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
