// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new security API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for security API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AccountCollectionGet(params *AccountCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountCollectionGetOK, error)

	AccountCreate(params *AccountCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountCreateCreated, error)

	AccountDelete(params *AccountDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDeleteOK, error)

	AccountDeleteCollection(params *AccountDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDeleteCollectionOK, error)

	AccountDuoDelete(params *AccountDuoDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDuoDeleteOK, error)

	AccountDuoDeleteCollection(params *AccountDuoDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDuoDeleteCollectionOK, error)

	AccountDuogroupDelete(params *AccountDuogroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDuogroupDeleteOK, error)

	AccountDuogroupDeleteCollection(params *AccountDuogroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDuogroupDeleteCollectionOK, error)

	AccountGet(params *AccountGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountGetOK, error)

	AccountModify(params *AccountModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountModifyOK, error)

	AccountModifyCollection(params *AccountModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountModifyCollectionOK, error)

	AccountPasswordCreate(params *AccountPasswordCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountPasswordCreateCreated, error)

	AccountPublickeyDelete(params *AccountPublickeyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountPublickeyDeleteOK, error)

	AccountPublickeyDeleteCollection(params *AccountPublickeyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountPublickeyDeleteCollectionOK, error)

	AccountTotpDelete(params *AccountTotpDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountTotpDeleteOK, error)

	AccountTotpDeleteCollection(params *AccountTotpDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountTotpDeleteCollectionOK, error)

	AntiRansomwareAutoEnableGet(params *AntiRansomwareAutoEnableGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareAutoEnableGetOK, error)

	AntiRansomwareAutoEnableModify(params *AntiRansomwareAutoEnableModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareAutoEnableModifyOK, error)

	AntiRansomwareGet(params *AntiRansomwareGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareGetOK, error)

	AntiRansomwareModify(params *AntiRansomwareModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareModifyOK, *AntiRansomwareModifyAccepted, error)

	AntiRansomwareSuspectCollectionGet(params *AntiRansomwareSuspectCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareSuspectCollectionGetOK, error)

	AntiRansomwareSuspectDelete(params *AntiRansomwareSuspectDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareSuspectDeleteOK, *AntiRansomwareSuspectDeleteAccepted, error)

	AntiRansomwareSuspectDeleteCollection(params *AntiRansomwareSuspectDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareSuspectDeleteCollectionOK, *AntiRansomwareSuspectDeleteCollectionAccepted, error)

	AntiRansomwareVolumeEntropyStatsCollectionGet(params *AntiRansomwareVolumeEntropyStatsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareVolumeEntropyStatsCollectionGetOK, error)

	AntiRansomwareVolumeEntropyStatsGet(params *AntiRansomwareVolumeEntropyStatsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareVolumeEntropyStatsGetOK, error)

	AuditLogForwardingGet(params *AuditLogForwardingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditLogForwardingGetOK, error)

	AwsKmsCollectionGet(params *AwsKmsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsCollectionGetOK, error)

	AwsKmsCreate(params *AwsKmsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsCreateCreated, *AwsKmsCreateAccepted, error)

	AwsKmsDelete(params *AwsKmsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsDeleteOK, *AwsKmsDeleteAccepted, error)

	AwsKmsDeleteCollection(params *AwsKmsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsDeleteCollectionOK, *AwsKmsDeleteCollectionAccepted, error)

	AwsKmsGet(params *AwsKmsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsGetOK, error)

	AwsKmsModify(params *AwsKmsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsModifyOK, *AwsKmsModifyAccepted, error)

	AwsKmsModifyCollection(params *AwsKmsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsModifyCollectionOK, *AwsKmsModifyCollectionAccepted, error)

	AwsKmsRekeyExternal(params *AwsKmsRekeyExternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsRekeyExternalCreated, *AwsKmsRekeyExternalAccepted, error)

	AwsKmsRekeyInternal(params *AwsKmsRekeyInternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsRekeyInternalCreated, *AwsKmsRekeyInternalAccepted, error)

	AwsKmsRestore(params *AwsKmsRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsRestoreCreated, *AwsKmsRestoreAccepted, error)

	AzureKeyVaultCollectionGet(params *AzureKeyVaultCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultCollectionGetOK, error)

	AzureKeyVaultCreate(params *AzureKeyVaultCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultCreateCreated, *AzureKeyVaultCreateAccepted, error)

	AzureKeyVaultDelete(params *AzureKeyVaultDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultDeleteOK, *AzureKeyVaultDeleteAccepted, error)

	AzureKeyVaultDeleteCollection(params *AzureKeyVaultDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultDeleteCollectionOK, *AzureKeyVaultDeleteCollectionAccepted, error)

	AzureKeyVaultGet(params *AzureKeyVaultGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultGetOK, error)

	AzureKeyVaultModify(params *AzureKeyVaultModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultModifyOK, *AzureKeyVaultModifyAccepted, error)

	AzureKeyVaultModifyCollection(params *AzureKeyVaultModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultModifyCollectionOK, *AzureKeyVaultModifyCollectionAccepted, error)

	AzureKeyVaultRekeyExternal(params *AzureKeyVaultRekeyExternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultRekeyExternalCreated, *AzureKeyVaultRekeyExternalAccepted, error)

	AzureKeyVaultRekeyInternal(params *AzureKeyVaultRekeyInternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultRekeyInternalCreated, *AzureKeyVaultRekeyInternalAccepted, error)

	AzureKeyVaultRestore(params *AzureKeyVaultRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultRestoreCreated, *AzureKeyVaultRestoreAccepted, error)

	BarbicanCollectionGet(params *BarbicanCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanCollectionGetOK, error)

	BarbicanCreate(params *BarbicanCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanCreateCreated, *BarbicanCreateAccepted, error)

	BarbicanGet(params *BarbicanGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanGetOK, error)

	BarbicanModify(params *BarbicanModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanModifyOK, *BarbicanModifyAccepted, error)

	BarbicanModifyCollection(params *BarbicanModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanModifyCollectionOK, *BarbicanModifyCollectionAccepted, error)

	BarbicanRekeyInternal(params *BarbicanRekeyInternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanRekeyInternalCreated, *BarbicanRekeyInternalAccepted, error)

	BarbicanRestore(params *BarbicanRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanRestoreCreated, *BarbicanRestoreAccepted, error)

	ClusterAccountAdProxyCreate(params *ClusterAccountAdProxyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterAccountAdProxyCreateCreated, error)

	ClusterAccountAdProxyDelete(params *ClusterAccountAdProxyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterAccountAdProxyDeleteOK, error)

	ClusterAccountAdProxyGet(params *ClusterAccountAdProxyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterAccountAdProxyGetOK, error)

	ClusterAccountAdProxyModify(params *ClusterAccountAdProxyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterAccountAdProxyModifyOK, error)

	ClusterLdapCreate(params *ClusterLdapCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterLdapCreateCreated, error)

	ClusterLdapDelete(params *ClusterLdapDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterLdapDeleteOK, error)

	ClusterLdapGet(params *ClusterLdapGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterLdapGetOK, error)

	ClusterLdapModify(params *ClusterLdapModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterLdapModifyOK, error)

	ClusterNisCreate(params *ClusterNisCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNisCreateCreated, error)

	ClusterNisDelete(params *ClusterNisDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNisDeleteOK, error)

	ClusterNisGet(params *ClusterNisGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNisGetOK, error)

	ClusterNisModify(params *ClusterNisModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNisModifyOK, error)

	CreateCertificateSigningRequest(params *CreateCertificateSigningRequestParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateCertificateSigningRequestOK, error)

	DcnCertificateGet(params *DcnCertificateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnCertificateGetOK, error)

	DcnCertificateModify(params *DcnCertificateModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnCertificateModifyOK, error)

	DcnClusterCertificateGet(params *DcnClusterCertificateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterCertificateGetOK, error)

	DcnClusterCertificateModify(params *DcnClusterCertificateModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterCertificateModifyOK, error)

	DcnNodeCertificateCollectionGet(params *DcnNodeCertificateCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCertificateCollectionGetOK, error)

	DcnNodeCertificateGet(params *DcnNodeCertificateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCertificateGetOK, error)

	DcnNodeCertificateModify(params *DcnNodeCertificateModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCertificateModifyOK, error)

	DcnNodeCertificateModifyCollection(params *DcnNodeCertificateModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCertificateModifyCollectionOK, error)

	DuoCollectionGet(params *DuoCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuoCollectionGetOK, error)

	DuoCreate(params *DuoCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuoCreateCreated, error)

	DuoGet(params *DuoGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuoGetOK, error)

	DuoModify(params *DuoModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuoModifyOK, error)

	DuoModifyCollection(params *DuoModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuoModifyCollectionOK, error)

	DuogroupCollectionGet(params *DuogroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuogroupCollectionGetOK, error)

	DuogroupCreate(params *DuogroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuogroupCreateCreated, error)

	DuogroupGet(params *DuogroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuogroupGetOK, error)

	DuogroupModify(params *DuogroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuogroupModifyOK, error)

	DuogroupModifyCollection(params *DuogroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuogroupModifyCollectionOK, error)

	GcpKmsCollectionGet(params *GcpKmsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsCollectionGetOK, error)

	GcpKmsCreate(params *GcpKmsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsCreateCreated, *GcpKmsCreateAccepted, error)

	GcpKmsDelete(params *GcpKmsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsDeleteOK, *GcpKmsDeleteAccepted, error)

	GcpKmsDeleteCollection(params *GcpKmsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsDeleteCollectionOK, *GcpKmsDeleteCollectionAccepted, error)

	GcpKmsGet(params *GcpKmsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsGetOK, error)

	GcpKmsModify(params *GcpKmsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsModifyOK, *GcpKmsModifyAccepted, error)

	GcpKmsModifyCollection(params *GcpKmsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsModifyCollectionOK, *GcpKmsModifyCollectionAccepted, error)

	GcpKmsRekeyExternal(params *GcpKmsRekeyExternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsRekeyExternalCreated, *GcpKmsRekeyExternalAccepted, error)

	GcpKmsRekeyInternal(params *GcpKmsRekeyInternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsRekeyInternalCreated, *GcpKmsRekeyInternalAccepted, error)

	GcpKmsRestore(params *GcpKmsRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsRestoreCreated, *GcpKmsRestoreAccepted, error)

	GroupRoleMappingsCollectionGet(params *GroupRoleMappingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsCollectionGetOK, error)

	GroupRoleMappingsCreate(params *GroupRoleMappingsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsCreateCreated, error)

	GroupRoleMappingsDelete(params *GroupRoleMappingsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsDeleteOK, error)

	GroupRoleMappingsDeleteCollection(params *GroupRoleMappingsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsDeleteCollectionOK, error)

	GroupRoleMappingsGet(params *GroupRoleMappingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsGetOK, error)

	GroupRoleMappingsModify(params *GroupRoleMappingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsModifyOK, error)

	GroupRoleMappingsModifyCollection(params *GroupRoleMappingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsModifyCollectionOK, error)

	IpsecCaCertificateCollectionGet(params *IpsecCaCertificateCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecCaCertificateCollectionGetOK, error)

	IpsecCaCertificateCreate(params *IpsecCaCertificateCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecCaCertificateCreateCreated, error)

	IpsecCaCertificateDelete(params *IpsecCaCertificateDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecCaCertificateDeleteOK, error)

	IpsecCaCertificateDeleteCollection(params *IpsecCaCertificateDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecCaCertificateDeleteCollectionOK, error)

	IpsecCaCertificateGet(params *IpsecCaCertificateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecCaCertificateGetOK, error)

	IpsecGet(params *IpsecGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecGetOK, error)

	IpsecModify(params *IpsecModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecModifyOK, error)

	IpsecPolicyCollectionGet(params *IpsecPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyCollectionGetOK, error)

	IpsecPolicyCreate(params *IpsecPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyCreateCreated, error)

	IpsecPolicyDelete(params *IpsecPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyDeleteOK, error)

	IpsecPolicyDeleteCollection(params *IpsecPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyDeleteCollectionOK, error)

	IpsecPolicyGet(params *IpsecPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyGetOK, error)

	IpsecPolicyModify(params *IpsecPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyModifyOK, error)

	IpsecPolicyModifyCollection(params *IpsecPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyModifyCollectionOK, error)

	KeyManagerAuthKeyCollectionGet(params *KeyManagerAuthKeyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerAuthKeyCollectionGetOK, error)

	KeyManagerAuthKeyCreate(params *KeyManagerAuthKeyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerAuthKeyCreateCreated, error)

	KeyManagerAuthKeyDelete(params *KeyManagerAuthKeyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerAuthKeyDeleteOK, error)

	KeyManagerAuthKeyDeleteCollection(params *KeyManagerAuthKeyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerAuthKeyDeleteCollectionOK, error)

	KeyManagerAuthKeyGet(params *KeyManagerAuthKeyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerAuthKeyGetOK, error)

	KeyManagerConfigGet(params *KeyManagerConfigGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerConfigGetOK, error)

	KeyManagerConfigModify(params *KeyManagerConfigModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerConfigModifyOK, error)

	KeyManagerKeysCollectionGet(params *KeyManagerKeysCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerKeysCollectionGetOK, error)

	KeyManagerKeysGet(params *KeyManagerKeysGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerKeysGetOK, error)

	LoginMessagesCollectionGet(params *LoginMessagesCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LoginMessagesCollectionGetOK, error)

	LoginMessagesGet(params *LoginMessagesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LoginMessagesGetOK, error)

	LoginMessagesModify(params *LoginMessagesModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LoginMessagesModifyOK, error)

	LoginMessagesModifyCollection(params *LoginMessagesModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LoginMessagesModifyCollectionOK, error)

	MultiAdminVerifyApprovalGroupCollectionGet(params *MultiAdminVerifyApprovalGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupCollectionGetOK, error)

	MultiAdminVerifyApprovalGroupCreate(params *MultiAdminVerifyApprovalGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupCreateCreated, error)

	MultiAdminVerifyApprovalGroupDelete(params *MultiAdminVerifyApprovalGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupDeleteOK, error)

	MultiAdminVerifyApprovalGroupDeleteCollection(params *MultiAdminVerifyApprovalGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupDeleteCollectionOK, error)

	MultiAdminVerifyApprovalGroupGet(params *MultiAdminVerifyApprovalGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupGetOK, error)

	MultiAdminVerifyApprovalGroupModify(params *MultiAdminVerifyApprovalGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupModifyOK, error)

	MultiAdminVerifyApprovalGroupModifyCollection(params *MultiAdminVerifyApprovalGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupModifyCollectionOK, error)

	MultiAdminVerifyConfigGet(params *MultiAdminVerifyConfigGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyConfigGetOK, error)

	MultiAdminVerifyConfigModify(params *MultiAdminVerifyConfigModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyConfigModifyOK, error)

	MultiAdminVerifyRequestCollectionGet(params *MultiAdminVerifyRequestCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestCollectionGetOK, error)

	MultiAdminVerifyRequestCreate(params *MultiAdminVerifyRequestCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestCreateCreated, error)

	MultiAdminVerifyRequestDelete(params *MultiAdminVerifyRequestDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestDeleteOK, error)

	MultiAdminVerifyRequestDeleteCollection(params *MultiAdminVerifyRequestDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestDeleteCollectionOK, error)

	MultiAdminVerifyRequestGet(params *MultiAdminVerifyRequestGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestGetOK, error)

	MultiAdminVerifyRequestModify(params *MultiAdminVerifyRequestModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestModifyOK, error)

	MultiAdminVerifyRequestModifyCollection(params *MultiAdminVerifyRequestModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestModifyCollectionOK, error)

	MultiAdminVerifyRuleCollectionGet(params *MultiAdminVerifyRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleCollectionGetOK, error)

	MultiAdminVerifyRuleCreate(params *MultiAdminVerifyRuleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleCreateCreated, error)

	MultiAdminVerifyRuleDelete(params *MultiAdminVerifyRuleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleDeleteOK, error)

	MultiAdminVerifyRuleDeleteCollection(params *MultiAdminVerifyRuleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleDeleteCollectionOK, error)

	MultiAdminVerifyRuleGet(params *MultiAdminVerifyRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleGetOK, error)

	MultiAdminVerifyRuleModify(params *MultiAdminVerifyRuleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleModifyOK, error)

	MultiAdminVerifyRuleModifyCollection(params *MultiAdminVerifyRuleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleModifyCollectionOK, error)

	PublickeyCollectionGet(params *PublickeyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PublickeyCollectionGetOK, error)

	PublickeyCreate(params *PublickeyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PublickeyCreateCreated, error)

	PublickeyGet(params *PublickeyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PublickeyGetOK, error)

	PublickeyModify(params *PublickeyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PublickeyModifyOK, error)

	PublickeyModifyCollection(params *PublickeyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PublickeyModifyCollectionOK, error)

	RoleCollectionGet(params *RoleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RoleCollectionGetOK, error)

	RoleCreate(params *RoleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RoleCreateCreated, error)

	RoleDelete(params *RoleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RoleDeleteOK, error)

	RoleDeleteCollection(params *RoleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RoleDeleteCollectionOK, error)

	RoleGet(params *RoleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RoleGetOK, error)

	RolePrivilegeCollectionGet(params *RolePrivilegeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeCollectionGetOK, error)

	RolePrivilegeCreate(params *RolePrivilegeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeCreateCreated, error)

	RolePrivilegeDelete(params *RolePrivilegeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeDeleteOK, error)

	RolePrivilegeDeleteCollection(params *RolePrivilegeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeDeleteCollectionOK, error)

	RolePrivilegeGet(params *RolePrivilegeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeGetOK, error)

	RolePrivilegeModify(params *RolePrivilegeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeModifyOK, error)

	RolePrivilegeModifyCollection(params *RolePrivilegeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeModifyCollectionOK, error)

	SecurityAssociationCollectionGet(params *SecurityAssociationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityAssociationCollectionGetOK, error)

	SecurityAssociationGet(params *SecurityAssociationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityAssociationGetOK, error)

	SecurityAuditGet(params *SecurityAuditGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityAuditGetOK, error)

	SecurityAuditLogCollectionGet(params *SecurityAuditLogCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityAuditLogCollectionGetOK, error)

	SecurityAuditModify(params *SecurityAuditModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityAuditModifyOK, error)

	SecurityCertificateCollectionGet(params *SecurityCertificateCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateCollectionGetOK, error)

	SecurityCertificateCreate(params *SecurityCertificateCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateCreateCreated, error)

	SecurityCertificateDelete(params *SecurityCertificateDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateDeleteOK, error)

	SecurityCertificateDeleteCollection(params *SecurityCertificateDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateDeleteCollectionOK, error)

	SecurityCertificateGet(params *SecurityCertificateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateGetOK, error)

	SecurityCertificateSign(params *SecurityCertificateSignParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateSignOK, error)

	SecurityClusterNetworkCertificatesCollectionGet(params *SecurityClusterNetworkCertificatesCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesCollectionGetOK, error)

	SecurityClusterNetworkCertificatesCreate(params *SecurityClusterNetworkCertificatesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesCreateCreated, error)

	SecurityClusterNetworkCertificatesDelete(params *SecurityClusterNetworkCertificatesDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesDeleteOK, error)

	SecurityClusterNetworkCertificatesDeleteCollection(params *SecurityClusterNetworkCertificatesDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesDeleteCollectionOK, error)

	SecurityClusterNetworkCertificatesGet(params *SecurityClusterNetworkCertificatesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesGetOK, error)

	SecurityClusterNetworkCertificatesModify(params *SecurityClusterNetworkCertificatesModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesModifyOK, error)

	SecurityClusterNetworkCertificatesModifyCollection(params *SecurityClusterNetworkCertificatesModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesModifyCollectionOK, error)

	SecurityClusterNetworkGet(params *SecurityClusterNetworkGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkGetOK, error)

	SecurityClusterNetworkModify(params *SecurityClusterNetworkModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkModifyOK, error)

	SecurityConfigGet(params *SecurityConfigGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityConfigGetOK, error)

	SecurityConfigModify(params *SecurityConfigModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityConfigModifyOK, *SecurityConfigModifyAccepted, error)

	SecurityExternalRoleMappingCollectionGet(params *SecurityExternalRoleMappingCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingCollectionGetOK, error)

	SecurityExternalRoleMappingCreate(params *SecurityExternalRoleMappingCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingCreateCreated, error)

	SecurityExternalRoleMappingDelete(params *SecurityExternalRoleMappingDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingDeleteOK, error)

	SecurityExternalRoleMappingDeleteCollection(params *SecurityExternalRoleMappingDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingDeleteCollectionOK, error)

	SecurityExternalRoleMappingGet(params *SecurityExternalRoleMappingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingGetOK, error)

	SecurityExternalRoleMappingModify(params *SecurityExternalRoleMappingModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingModifyOK, error)

	SecurityExternalRoleMappingModifyCollection(params *SecurityExternalRoleMappingModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingModifyCollectionOK, error)

	SecurityGroupCollectionGet(params *SecurityGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupCollectionGetOK, error)

	SecurityGroupCreate(params *SecurityGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupCreateCreated, error)

	SecurityGroupDelete(params *SecurityGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupDeleteOK, error)

	SecurityGroupDeleteCollection(params *SecurityGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupDeleteCollectionOK, error)

	SecurityGroupGet(params *SecurityGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupGetOK, error)

	SecurityGroupModify(params *SecurityGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupModifyOK, error)

	SecurityGroupModifyCollection(params *SecurityGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupModifyCollectionOK, error)

	SecurityHaNetworkGet(params *SecurityHaNetworkGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityHaNetworkGetOK, error)

	SecurityHaNetworkModify(params *SecurityHaNetworkModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityHaNetworkModifyOK, error)

	SecurityJitPrivilegeCollectionGet(params *SecurityJitPrivilegeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeCollectionGetOK, error)

	SecurityJitPrivilegeGet(params *SecurityJitPrivilegeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeGetOK, error)

	SecurityJitPrivilegeModify(params *SecurityJitPrivilegeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeModifyOK, error)

	SecurityJitPrivilegeModifyCollection(params *SecurityJitPrivilegeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeModifyCollectionOK, error)

	SecurityJitPrivilegeUserCollectionGet(params *SecurityJitPrivilegeUserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeUserCollectionGetOK, error)

	SecurityJitPrivilegeUserCreate(params *SecurityJitPrivilegeUserCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeUserCreateCreated, error)

	SecurityJitPrivilegeUserDelete(params *SecurityJitPrivilegeUserDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeUserDeleteOK, error)

	SecurityJitPrivilegeUserDeleteCollection(params *SecurityJitPrivilegeUserDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeUserDeleteCollectionOK, error)

	SecurityJitPrivilegeUserGet(params *SecurityJitPrivilegeUserGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeUserGetOK, error)

	SecurityKeyManagerCollectionGet(params *SecurityKeyManagerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerCollectionGetOK, error)

	SecurityKeyManagerCreate(params *SecurityKeyManagerCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerCreateCreated, *SecurityKeyManagerCreateAccepted, error)

	SecurityKeyManagerDelete(params *SecurityKeyManagerDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerDeleteOK, error)

	SecurityKeyManagerDeleteCollection(params *SecurityKeyManagerDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerDeleteCollectionOK, error)

	SecurityKeyManagerGet(params *SecurityKeyManagerGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerGetOK, error)

	SecurityKeyManagerKeyServersCollectionGet(params *SecurityKeyManagerKeyServersCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersCollectionGetOK, error)

	SecurityKeyManagerKeyServersCreate(params *SecurityKeyManagerKeyServersCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersCreateCreated, error)

	SecurityKeyManagerKeyServersDelete(params *SecurityKeyManagerKeyServersDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersDeleteOK, error)

	SecurityKeyManagerKeyServersDeleteCollection(params *SecurityKeyManagerKeyServersDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersDeleteCollectionOK, error)

	SecurityKeyManagerKeyServersGet(params *SecurityKeyManagerKeyServersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersGetOK, error)

	SecurityKeyManagerKeyServersModify(params *SecurityKeyManagerKeyServersModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersModifyOK, error)

	SecurityKeyManagerKeyServersModifyCollection(params *SecurityKeyManagerKeyServersModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersModifyCollectionOK, error)

	SecurityKeyManagerMigrate(params *SecurityKeyManagerMigrateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerMigrateCreated, *SecurityKeyManagerMigrateAccepted, error)

	SecurityKeyManagerModify(params *SecurityKeyManagerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerModifyOK, *SecurityKeyManagerModifyAccepted, error)

	SecurityKeyManagerModifyCollection(params *SecurityKeyManagerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerModifyCollectionOK, *SecurityKeyManagerModifyCollectionAccepted, error)

	SecurityKeyManagerRestore(params *SecurityKeyManagerRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerRestoreCreated, *SecurityKeyManagerRestoreAccepted, error)

	SecurityKeystoreCollectionGet(params *SecurityKeystoreCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreCollectionGetOK, error)

	SecurityKeystoreDelete(params *SecurityKeystoreDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreDeleteOK, error)

	SecurityKeystoreDeleteCollection(params *SecurityKeystoreDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreDeleteCollectionOK, error)

	SecurityKeystoreGet(params *SecurityKeystoreGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreGetOK, error)

	SecurityKeystoreModify(params *SecurityKeystoreModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreModifyOK, *SecurityKeystoreModifyAccepted, error)

	SecurityKeystoreModifyCollection(params *SecurityKeystoreModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreModifyCollectionOK, *SecurityKeystoreModifyCollectionAccepted, error)

	SecurityLogForwardingCreate(params *SecurityLogForwardingCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingCreateCreated, *SecurityLogForwardingCreateAccepted, error)

	SecurityLogForwardingDelete(params *SecurityLogForwardingDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingDeleteOK, error)

	SecurityLogForwardingDeleteCollection(params *SecurityLogForwardingDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingDeleteCollectionOK, error)

	SecurityLogForwardingGet(params *SecurityLogForwardingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingGetOK, error)

	SecurityLogForwardingModify(params *SecurityLogForwardingModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingModifyOK, error)

	SecurityLogForwardingModifyCollection(params *SecurityLogForwardingModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingModifyCollectionOK, error)

	SecurityOauth2CollectionGet(params *SecurityOauth2CollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2CollectionGetOK, error)

	SecurityOauth2Create(params *SecurityOauth2CreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2CreateCreated, *SecurityOauth2CreateAccepted, error)

	SecurityOauth2Delete(params *SecurityOauth2DeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2DeleteOK, error)

	SecurityOauth2DeleteCollection(params *SecurityOauth2DeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2DeleteCollectionOK, error)

	SecurityOauth2Get(params *SecurityOauth2GetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2GetOK, error)

	SecurityOauth2GlobalGet(params *SecurityOauth2GlobalGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2GlobalGetOK, error)

	SecurityOauth2GlobalModify(params *SecurityOauth2GlobalModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2GlobalModifyOK, error)

	SecurityOidcCreate(params *SecurityOidcCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOidcCreateCreated, *SecurityOidcCreateAccepted, error)

	SecurityOidcDelete(params *SecurityOidcDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOidcDeleteOK, error)

	SecurityOidcGet(params *SecurityOidcGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOidcGetOK, error)

	SecurityOidcModify(params *SecurityOidcModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOidcModifyOK, error)

	SecuritySamlDefMetadataCreate(params *SecuritySamlDefMetadataCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlDefMetadataCreateCreated, *SecuritySamlDefMetadataCreateAccepted, error)

	SecuritySamlDefMetadataDelete(params *SecuritySamlDefMetadataDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlDefMetadataDeleteOK, error)

	SecuritySamlDefMetadataGet(params *SecuritySamlDefMetadataGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlDefMetadataGetOK, error)

	SecuritySamlSpCreate(params *SecuritySamlSpCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlSpCreateCreated, *SecuritySamlSpCreateAccepted, error)

	SecuritySamlSpDelete(params *SecuritySamlSpDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlSpDeleteOK, error)

	SecuritySamlSpGet(params *SecuritySamlSpGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlSpGetOK, error)

	SecuritySamlSpModify(params *SecuritySamlSpModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlSpModifyOK, error)

	SSHGet(params *SSHGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSHGetOK, error)

	SSHModify(params *SSHModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSHModifyOK, error)

	StorageUnitAntiRansomwareEntropyStatsCollectionGet(params *StorageUnitAntiRansomwareEntropyStatsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareEntropyStatsCollectionGetOK, error)

	StorageUnitAntiRansomwareEntropyStatsGet(params *StorageUnitAntiRansomwareEntropyStatsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareEntropyStatsGetOK, error)

	StorageUnitAntiRansomwareSuspectCollectionGet(params *StorageUnitAntiRansomwareSuspectCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareSuspectCollectionGetOK, error)

	StorageUnitAntiRansomwareSuspectDelete(params *StorageUnitAntiRansomwareSuspectDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareSuspectDeleteOK, *StorageUnitAntiRansomwareSuspectDeleteAccepted, error)

	StorageUnitAntiRansomwareSuspectDeleteCollection(params *StorageUnitAntiRansomwareSuspectDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareSuspectDeleteCollectionOK, *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted, error)

	StorageUnitAntiRansomwareSuspectGet(params *StorageUnitAntiRansomwareSuspectGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareSuspectGetOK, error)

	SupportedAlgorithmsCollectionGet(params *SupportedAlgorithmsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SupportedAlgorithmsCollectionGetOK, error)

	SupportedAlgorithmsGet(params *SupportedAlgorithmsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SupportedAlgorithmsGetOK, error)

	SvmSSHServerCollectionGet(params *SvmSSHServerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmSSHServerCollectionGetOK, error)

	SvmSSHServerGet(params *SvmSSHServerGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmSSHServerGetOK, error)

	SvmSSHServerModify(params *SvmSSHServerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmSSHServerModifyOK, error)

	SvmSSHServerModifyCollection(params *SvmSSHServerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmSSHServerModifyCollectionOK, error)

	TotpCollectionGet(params *TotpCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TotpCollectionGetOK, error)

	TotpCreate(params *TotpCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TotpCreateCreated, error)

	TotpGet(params *TotpGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TotpGetOK, error)

	TotpModify(params *TotpModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TotpModifyOK, error)

	TotpModifyCollection(params *TotpModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TotpModifyCollectionOK, error)

	WebauthnCredentialsCollectionGet(params *WebauthnCredentialsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnCredentialsCollectionGetOK, error)

	WebauthnCredentialsDelete(params *WebauthnCredentialsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnCredentialsDeleteOK, error)

	WebauthnCredentialsDeleteCollection(params *WebauthnCredentialsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnCredentialsDeleteCollectionOK, error)

	WebauthnCredentialsGet(params *WebauthnCredentialsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnCredentialsGetOK, error)

	WebauthnGlobalCollectionGet(params *WebauthnGlobalCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnGlobalCollectionGetOK, error)

	WebauthnGlobalGet(params *WebauthnGlobalGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnGlobalGetOK, error)

	WhoamiGet(params *WhoamiGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WhoamiGetOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	AccountCollectionGet Retrieves a list of user accounts in the cluster.

### Related ONTAP commands
* `security login show`
### Learn more
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) AccountCollectionGet(params *AccountCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_collection_get",
		Method:             "GET",
		PathPattern:        "/security/accounts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AccountCreate Creates a new user account.

### Required parameters
* `name` - Account name to be created.
* `applications` - Array of one or more application tuples (of application and authentication methods).
### Optional parameters
* `owner.name` or `owner.uuid`  - Name or UUID of the SVM for an SVM-scoped user account. If not supplied, a cluster-scoped user account is created.
* `role` - RBAC role for the user account. Defaulted to `admin` for cluster user account and to `vsadmin` for SVM-scoped account.
* `password` - Password for the user account (if the authentication method is opted as password for one or more of applications).
* `second_authentication_method` - Needed for MFA and only supported for _ssh_ and _service_processor_ applications. Defaults to _none_ if not supplied.
* `comment` - Comment for the user account (e.g purpose of this account).
* `locked` - Locks the account after creation. Defaults to `false` if not supplied.
* `is_ldap_fastbind` - Needed for LDAP Fastbind Authentication and only supported for applications SSH, ONTAPI, and HTTP with authentication method "nsswitch" only. Defaults to false if not supplied.
* `is_ns_switch_group` - Specifies whether the user is an LDAP or NIS group and is only supported for SSH, ONTAPI, and HTTP applications with the authentication method "nsswitch". Defaults to false if not supplied.
### Related ONTAP commands
* `security login create`
### Learn more
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) AccountCreate(params *AccountCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_create",
		Method:             "POST",
		PathPattern:        "/security/accounts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AccountDelete Deletes a user account.

### Required parameters
* `name` - Account name to be deleted.
* `owner.uuid`  - UUID of the SVM housing the user account to be deleted.
### Related ONTAP commands
* `security login delete`
### Learn more
* [`DOC /security/accounts/{owner.uuid}/{name}`](#docs-security-security_accounts_{owner.uuid}_{name})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) AccountDelete(params *AccountDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_delete",
		Method:             "DELETE",
		PathPattern:        "/security/accounts/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AccountDeleteCollection account delete collection API
*/
func (a *Client) AccountDeleteCollection(params *AccountDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/accounts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AccountDuoDelete Deletes the Duo profile of the SVM or cluster.

### Related ONTAP commands
* `security login duo delete`
### Learn more
* [`DOC /security/authentication/duo/profiles/{owner.uuid}`](#docs-security-security_authentication_duo_profiles_{owner.uuid})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) AccountDuoDelete(params *AccountDuoDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDuoDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountDuoDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_duo_delete",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/duo/profiles/{owner.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountDuoDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountDuoDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountDuoDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AccountDuoDeleteCollection account duo delete collection API
*/
func (a *Client) AccountDuoDeleteCollection(params *AccountDuoDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDuoDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountDuoDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_duo_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/duo/profiles",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountDuoDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountDuoDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountDuoDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AccountDuogroupDelete Deletes a Duo group of the SVM or cluster.

### Related ONTAP commands
* `security login duo group delete`
### Learn more
* [`DOC /security/authentication/duo/groups/{owner.uuid}/{name}`](#docs-security-security_authentication_duo_groups_{owner.uuid}_{name})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) AccountDuogroupDelete(params *AccountDuogroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDuogroupDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountDuogroupDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_duogroup_delete",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/duo/groups/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountDuogroupDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountDuogroupDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountDuogroupDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AccountDuogroupDeleteCollection account duogroup delete collection API
*/
func (a *Client) AccountDuogroupDeleteCollection(params *AccountDuogroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountDuogroupDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountDuogroupDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_duogroup_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/duo/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountDuogroupDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountDuogroupDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountDuogroupDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AccountGet Retrieves a specific user account.

### Related ONTAP commands
* `security login show`
### Learn more
* [`DOC /security/accounts/{owner.uuid}/{name}`](#docs-security-security_accounts_{owner.uuid}_{name})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) AccountGet(params *AccountGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_get",
		Method:             "GET",
		PathPattern:        "/security/accounts/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AccountModify Updates a user account. Locks or unlocks a user account and/or updates the role, applications, and/or password for the user account.

### Required parameters
* `name` - Account name to be updated.
* `owner.uuid`  - UUID of the SVM housing the user account to be updated.
### Optional parameters
* `applications` - Array of one or more tuples (of application and authentication methods).
* `role` - RBAC role for the user account.
* `password` - Password for the user account (if the authentication method is opted as password for one or more of applications).
* `second_authentication_method` - Needed for MFA and only supported for _ssh_ and _service_processor_ applications. Defaults to _none_ if not supplied.
* `comment` - Comment for the user account (e.g purpose of this account).
* `locked` - Set to true/false to lock/unlock the account.
* `is_ldap_fastbind` - Set to true/false to enable LDAP Fastbind Authentication.
* `is_ns_switch_group` - Set to true/false to specify whether the user is an LDAP or NIS group.
### Related ONTAP commands
* `security login create`
* `security login modify`
* `security login password`
* `security login lock`
* `security login unlock`
### Learn more
* [`DOC /security/accounts/{owner.uuid}/{name}`](#docs-security-security_accounts_{owner.uuid}_{name})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) AccountModify(params *AccountModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_modify",
		Method:             "PATCH",
		PathPattern:        "/security/accounts/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AccountModifyCollection account modify collection API
*/
func (a *Client) AccountModifyCollection(params *AccountModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/accounts",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AccountPasswordCreate Updates the password for a user account.

### Required parameters
* `name` - User account name.
* `password` - New password for the user account.
### Optional parameters
* `owner.name` or `owner.uuid` - Name or UUID of the SVM for an SVM-scoped user account.
* `password_hash_algorithm` - Optional property that specifies the password hash algorithm used to generate a hash of the user's password for password matching. Default value is "sha512".
### Related ONTAP commands
* `security login password`
### Learn more
* [`DOC /security/authentication/password`](#docs-security-security_authentication_password)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) AccountPasswordCreate(params *AccountPasswordCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountPasswordCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountPasswordCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_password_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/password",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountPasswordCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountPasswordCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountPasswordCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AccountPublickeyDelete Deletes the public key for a user account.

### Related ONTAP commands
* `security login publickey delete`
### Learn more
* [`DOC /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}`](#docs-security-security_authentication_publickeys_{owner.uuid}_{account.name}_{index})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) AccountPublickeyDelete(params *AccountPublickeyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountPublickeyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountPublickeyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_publickey_delete",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/publickeys/{owner.uuid}/{account.name}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountPublickeyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountPublickeyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountPublickeyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AccountPublickeyDeleteCollection account publickey delete collection API
*/
func (a *Client) AccountPublickeyDeleteCollection(params *AccountPublickeyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountPublickeyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountPublickeyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_publickey_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/publickeys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountPublickeyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountPublickeyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountPublickeyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AccountTotpDelete Deletes the TOTP profile for a user account.

### Related ONTAP commands
* `security login totp delete`
### Learn more
* [`DOC /security/login/totps/{owner.uuid}/{account.name}`](#docs-security-security_login_totps_{owner.uuid}_{account.name})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) AccountTotpDelete(params *AccountTotpDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountTotpDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountTotpDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_totp_delete",
		Method:             "DELETE",
		PathPattern:        "/security/login/totps/{owner.uuid}/{account.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountTotpDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountTotpDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountTotpDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AccountTotpDeleteCollection account totp delete collection API
*/
func (a *Client) AccountTotpDeleteCollection(params *AccountTotpDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AccountTotpDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAccountTotpDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "account_totp_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/login/totps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AccountTotpDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AccountTotpDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AccountTotpDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AntiRansomwareAutoEnableGet Retrieves the current anti-ransomware auto enablement values, including details about warm-up period and auto enablement setting for new and existing volumes.
*/
func (a *Client) AntiRansomwareAutoEnableGet(params *AntiRansomwareAutoEnableGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareAutoEnableGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAntiRansomwareAutoEnableGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "anti_ransomware_auto_enable_get",
		Method:             "GET",
		PathPattern:        "/security/anti-ransomware/auto-enable",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AntiRansomwareAutoEnableGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AntiRansomwareAutoEnableGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AntiRansomwareAutoEnableGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AntiRansomwareAutoEnableModify API to modify the anti-ransomware auto enablement setting.
*/
func (a *Client) AntiRansomwareAutoEnableModify(params *AntiRansomwareAutoEnableModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareAutoEnableModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAntiRansomwareAutoEnableModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "anti_ransomware_auto_enable_modify",
		Method:             "PATCH",
		PathPattern:        "/security/anti-ransomware/auto-enable",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AntiRansomwareAutoEnableModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AntiRansomwareAutoEnableModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AntiRansomwareAutoEnableModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AntiRansomwareGet Retrieves the anti-ransomware package version of the nodes in the cluster.

### Related ONTAP commands
* `security anti-ransomware show`
*/
func (a *Client) AntiRansomwareGet(params *AntiRansomwareGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAntiRansomwareGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "anti_ransomware_get",
		Method:             "GET",
		PathPattern:        "/security/anti-ransomware",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AntiRansomwareGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AntiRansomwareGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AntiRansomwareGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AntiRansomwareModify Updates the anti-ransomware package on the cluster.

### Required properties
* `uri` - URI of the anti-ransomware package
### Related ONTAP commands
* `security anti-ransomware update-package-from-uri`
*/
func (a *Client) AntiRansomwareModify(params *AntiRansomwareModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareModifyOK, *AntiRansomwareModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAntiRansomwareModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "anti_ransomware_modify",
		Method:             "PATCH",
		PathPattern:        "/security/anti-ransomware",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AntiRansomwareModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AntiRansomwareModifyOK:
		return value, nil, nil
	case *AntiRansomwareModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AntiRansomwareModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AntiRansomwareSuspectCollectionGet Retrieves information on the suspects generated by the anti-ransomware analytics.

### Related ONTAP commands
* `security anti-ransomware volume attack generate-report`
*/
func (a *Client) AntiRansomwareSuspectCollectionGet(params *AntiRansomwareSuspectCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareSuspectCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAntiRansomwareSuspectCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "anti_ransomware_suspect_collection_get",
		Method:             "GET",
		PathPattern:        "/security/anti-ransomware/suspects",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AntiRansomwareSuspectCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AntiRansomwareSuspectCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AntiRansomwareSuspectCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AntiRansomwareSuspectDelete Clears either all the suspect files of a volume or suspect files of a volume based on file format or suspect time provided.

### Related ONTAP commands
* `security anti-ransomware volume attack clear-suspect`
*/
func (a *Client) AntiRansomwareSuspectDelete(params *AntiRansomwareSuspectDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareSuspectDeleteOK, *AntiRansomwareSuspectDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAntiRansomwareSuspectDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "anti_ransomware_suspect_delete",
		Method:             "DELETE",
		PathPattern:        "/security/anti-ransomware/suspects/{volume.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AntiRansomwareSuspectDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AntiRansomwareSuspectDeleteOK:
		return value, nil, nil
	case *AntiRansomwareSuspectDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AntiRansomwareSuspectDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AntiRansomwareSuspectDeleteCollection anti ransomware suspect delete collection API
*/
func (a *Client) AntiRansomwareSuspectDeleteCollection(params *AntiRansomwareSuspectDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareSuspectDeleteCollectionOK, *AntiRansomwareSuspectDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAntiRansomwareSuspectDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "anti_ransomware_suspect_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/anti-ransomware/suspects",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AntiRansomwareSuspectDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AntiRansomwareSuspectDeleteCollectionOK:
		return value, nil, nil
	case *AntiRansomwareSuspectDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AntiRansomwareSuspectDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AntiRansomwareVolumeEntropyStatsCollectionGet Retrieves the data-entropy statistics for the volumes.
*/
func (a *Client) AntiRansomwareVolumeEntropyStatsCollectionGet(params *AntiRansomwareVolumeEntropyStatsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareVolumeEntropyStatsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAntiRansomwareVolumeEntropyStatsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "anti_ransomware_volume_entropy_stats_collection_get",
		Method:             "GET",
		PathPattern:        "/security/anti-ransomware/volume/entropy-stats",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AntiRansomwareVolumeEntropyStatsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AntiRansomwareVolumeEntropyStatsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AntiRansomwareVolumeEntropyStatsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AntiRansomwareVolumeEntropyStatsGet Retrieves a data-entropy statistic for the volumes.
*/
func (a *Client) AntiRansomwareVolumeEntropyStatsGet(params *AntiRansomwareVolumeEntropyStatsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AntiRansomwareVolumeEntropyStatsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAntiRansomwareVolumeEntropyStatsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "anti_ransomware_volume_entropy_stats_get",
		Method:             "GET",
		PathPattern:        "/security/anti-ransomware/volume/entropy-stats/{volume.uuid}/{entropy_stats_type}/{timestamp}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AntiRansomwareVolumeEntropyStatsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AntiRansomwareVolumeEntropyStatsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AntiRansomwareVolumeEntropyStatsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AuditLogForwardingGet Defines a remote syslog/splunk server for sending audit information to.
*/
func (a *Client) AuditLogForwardingGet(params *AuditLogForwardingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuditLogForwardingGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuditLogForwardingGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "audit_log_forwarding_get",
		Method:             "GET",
		PathPattern:        "/security/audit/destinations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AuditLogForwardingGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuditLogForwardingGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuditLogForwardingGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AwsKmsCollectionGet Retrieves all AWS KMS instances configured for all clusters and SVMs.

### Related ONTAP commands
* `security key-manager external aws show`
* `security key-manager external aws check`
*/
func (a *Client) AwsKmsCollectionGet(params *AwsKmsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAwsKmsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aws_kms_collection_get",
		Method:             "GET",
		PathPattern:        "/security/aws-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AwsKmsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AwsKmsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AwsKmsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AwsKmsCreate Configures the AWS KMS configuration for the specified SVM.

### Required properties
* `access_key_id` - AWS access key ID of the user who has the appropriate access to AWS KMS.
* `secret_access_key` - AWS secret access key for the access key ID provided.
* `svm.uuid` or `svm.name` - Existing SVM in which to create an AWS KMS.
* `region` - AWS region of the AWS KMS.
* `key_id` - AWS Key ID
### Optional properties
* `service` - AWS service type.
* `default_domain` - AWS KMS default domain.
* `host` - AWS KMS host's hostname.
* `port` - AWS KMS port.
* `proxy_type` - Type of proxy (http, https, etc.), if proxy configuration is used.
* `proxy_host` - Proxy hostname if proxy configuration is used.
* `proxy_port` - Proxy port number if proxy configuration is used.
* `proxy_username` - Proxy username if proxy configuration is used.
* `proxy_password` - Proxy password if proxy configuration is used.
* `polling_period` - Polling period in minutes.
* `encryption_context` - Additional layer of authentication and logging.
### Related ONTAP commands
* `security key-manager external aws enable`
*/
func (a *Client) AwsKmsCreate(params *AwsKmsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsCreateCreated, *AwsKmsCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAwsKmsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aws_kms_create",
		Method:             "POST",
		PathPattern:        "/security/aws-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AwsKmsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AwsKmsCreateCreated:
		return value, nil, nil
	case *AwsKmsCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AwsKmsCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AwsKmsDelete Deletes an AWS KMS configuration.

### Related ONTAP commands
* `security key-manager external aws disable`
*/
func (a *Client) AwsKmsDelete(params *AwsKmsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsDeleteOK, *AwsKmsDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAwsKmsDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aws_kms_delete",
		Method:             "DELETE",
		PathPattern:        "/security/aws-kms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AwsKmsDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AwsKmsDeleteOK:
		return value, nil, nil
	case *AwsKmsDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AwsKmsDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AwsKmsDeleteCollection aws kms delete collection API
*/
func (a *Client) AwsKmsDeleteCollection(params *AwsKmsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsDeleteCollectionOK, *AwsKmsDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAwsKmsDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aws_kms_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/aws-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AwsKmsDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AwsKmsDeleteCollectionOK:
		return value, nil, nil
	case *AwsKmsDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AwsKmsDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AwsKmsGet Retrieves the AWS KMS configuration for the SVM specified by the UUID.

### Related ONTAP commands
* `security key-manager external aws show`
* `security key-manager external aws check`
*/
func (a *Client) AwsKmsGet(params *AwsKmsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAwsKmsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aws_kms_get",
		Method:             "GET",
		PathPattern:        "/security/aws-kms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AwsKmsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AwsKmsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AwsKmsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AwsKmsModify Updates the AWS KMS configuration.

### Optional properties
* `region` - AWS region of the AWS KMS.
* `service` - AWS service type.
* `default_domain` - AWS KMS default domain.
* `port` - AWS KMS port.
* `proxy_type` - Type of proxy (http, https, etc.), if proxy configuration is used.
* `proxy_host` - Proxy hostname if proxy configuration is used.
* `proxy_port` - Proxy port number if proxy configuration is used.
* `proxy_username` - Proxy username if proxy configuration is used.
* `proxy_password` - Proxy password if proxy configuration is used.
* `polling_period` - Polling period in minutes.
* `timeout` - AWS Connection timeout, in seconds.
* `verify` - Set to true to verify the AWS KMS host.
* `verify_host` - Set to true to verify the AWS KMS host's hostname.
* `verify_ip` - Set to true to verify the AWS KMS host's IP address.
* `host` - AWS KMS host's hostname.
* `secret_access_key` - AWS secret access key for the access key ID provided.
* `access_key_id` - AWS access key ID of the user with the appropriate access to AWS KMS.
* `skip_verify` - Set to true to bypass verification of the user provided access_key_id and secret_access_key.
* `encryption_context` - Additional layer of authentication and logging.
### Related ONTAP commands
* `security key-manager external aws update-config`
* `security key-manager external aws update-credentials`
*/
func (a *Client) AwsKmsModify(params *AwsKmsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsModifyOK, *AwsKmsModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAwsKmsModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aws_kms_modify",
		Method:             "PATCH",
		PathPattern:        "/security/aws-kms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AwsKmsModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AwsKmsModifyOK:
		return value, nil, nil
	case *AwsKmsModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AwsKmsModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AwsKmsModifyCollection aws kms modify collection API
*/
func (a *Client) AwsKmsModifyCollection(params *AwsKmsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsModifyCollectionOK, *AwsKmsModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAwsKmsModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aws_kms_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/aws-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AwsKmsModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AwsKmsModifyCollectionOK:
		return value, nil, nil
	case *AwsKmsModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AwsKmsModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AwsKmsRekeyExternal Rekeys or re-versions the AWS KMS Key Encryption Key (KEK) for the given AWS KMS.

### Related ONTAP commands
* `security key-manager external aws rekey-external`
*/
func (a *Client) AwsKmsRekeyExternal(params *AwsKmsRekeyExternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsRekeyExternalCreated, *AwsKmsRekeyExternalAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAwsKmsRekeyExternalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aws_kms_rekey_external",
		Method:             "POST",
		PathPattern:        "/security/aws-kms/{aws_kms.uuid}/rekey-external",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AwsKmsRekeyExternalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AwsKmsRekeyExternalCreated:
		return value, nil, nil
	case *AwsKmsRekeyExternalAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AwsKmsRekeyExternalDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AwsKmsRekeyInternal Rekeys SVM KEK for the given AWS KMS.

### Related ONTAP commands
* `security key-manager external aws rekey-internal`
*/
func (a *Client) AwsKmsRekeyInternal(params *AwsKmsRekeyInternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsRekeyInternalCreated, *AwsKmsRekeyInternalAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAwsKmsRekeyInternalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aws_kms_rekey_internal",
		Method:             "POST",
		PathPattern:        "/security/aws-kms/{aws_kms.uuid}/rekey-internal",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AwsKmsRekeyInternalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AwsKmsRekeyInternalCreated:
		return value, nil, nil
	case *AwsKmsRekeyInternalAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AwsKmsRekeyInternalDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AwsKmsRestore Restores the keys for an SVM from a configured AWS KMS.

### Related ONTAP commands
* `security key-manager external AWS restore`
*/
func (a *Client) AwsKmsRestore(params *AwsKmsRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AwsKmsRestoreCreated, *AwsKmsRestoreAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAwsKmsRestoreParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "aws_kms_restore",
		Method:             "POST",
		PathPattern:        "/security/aws-kms/{aws_kms.uuid}/restore",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AwsKmsRestoreReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AwsKmsRestoreCreated:
		return value, nil, nil
	case *AwsKmsRestoreAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AwsKmsRestoreDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AzureKeyVaultCollectionGet Retrieves AKVs configured for all clusters and SVMs.

### Related ONTAP commands
* `security key-manager external azure show`
* `security key-manager external azure check`
*/
func (a *Client) AzureKeyVaultCollectionGet(params *AzureKeyVaultCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAzureKeyVaultCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "azure_key_vault_collection_get",
		Method:             "GET",
		PathPattern:        "/security/azure-key-vaults",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AzureKeyVaultCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AzureKeyVaultCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AzureKeyVaultCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AzureKeyVaultCreate Configures the AKV configuration for all clusters and SVMs.

### Required properties:
* `svm.uuid` or `svm.name` - Existing SVM in which to create a AKV.
* `client_id` - Application (client) ID of the deployed Azure application with appropriate access to an AKV.
* `tenant_id` - Directory (tenant) ID of the deployed Azure application with appropriate access to an AKV.
* `client_secret` or `client_certificate` - Secret or PKCS12 Certificate used by the application to prove its identity to AKV.
* `key_id`- Key Identifier of AKV encryption key.
* `name` - Name of the deployed AKV used by ONTAP for storing keys.
### Optional properties:
* `port` - Authorization server and vault port number.
* `oauth_host` - Open authorization server host name.
* `vault_host` - AKV host subdomain.
* `proxy_type` - Type of proxy (http, https etc.) if proxy configuration is used.
* `proxy_host` - Proxy hostname if proxy configuration is used.
* `proxy_port` - Proxy port number if proxy configuration is used.
* `proxy_username` - Proxy username if proxy configuration is used.
* `proxy_password` - Proxy password if proxy configuration is used.
* `configuration.name` - The configuration name to use when also setting the `create_inactive` flag.
### Optional parameters:
* `create_inactive` - Create an AKV configuration without enabling it. This flag is set to "false" by default.
### Related ONTAP commands
* `security key-manager external azure enable`
* `security key-manager external azure create-config`
* `security key-manager external azure update-config`
*/
func (a *Client) AzureKeyVaultCreate(params *AzureKeyVaultCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultCreateCreated, *AzureKeyVaultCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAzureKeyVaultCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "azure_key_vault_create",
		Method:             "POST",
		PathPattern:        "/security/azure-key-vaults",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AzureKeyVaultCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AzureKeyVaultCreateCreated:
		return value, nil, nil
	case *AzureKeyVaultCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AzureKeyVaultCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AzureKeyVaultDelete Deletes an AKV configuration.

### Related ONTAP commands
* `security key-manager external azure disable`
*/
func (a *Client) AzureKeyVaultDelete(params *AzureKeyVaultDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultDeleteOK, *AzureKeyVaultDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAzureKeyVaultDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "azure_key_vault_delete",
		Method:             "DELETE",
		PathPattern:        "/security/azure-key-vaults/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AzureKeyVaultDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AzureKeyVaultDeleteOK:
		return value, nil, nil
	case *AzureKeyVaultDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AzureKeyVaultDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AzureKeyVaultDeleteCollection azure key vault delete collection API
*/
func (a *Client) AzureKeyVaultDeleteCollection(params *AzureKeyVaultDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultDeleteCollectionOK, *AzureKeyVaultDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAzureKeyVaultDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "azure_key_vault_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/azure-key-vaults",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AzureKeyVaultDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AzureKeyVaultDeleteCollectionOK:
		return value, nil, nil
	case *AzureKeyVaultDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AzureKeyVaultDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AzureKeyVaultGet Retrieves the AKV configuration for the SVM specified by the UUID.

### Related ONTAP commands
* `security key-manager external azure show`
* `security key-manager external azure check`
*/
func (a *Client) AzureKeyVaultGet(params *AzureKeyVaultGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAzureKeyVaultGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "azure_key_vault_get",
		Method:             "GET",
		PathPattern:        "/security/azure-key-vaults/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AzureKeyVaultGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AzureKeyVaultGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AzureKeyVaultGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AzureKeyVaultModify Updates the AKV configuration.

### Optional properties
* `client_secret` or `client_certificate` - New secret or new PKCS12 certificate used to prove the application's identity to the AKV.
* `proxy_type` - Type of proxy (http, https etc.) if proxy configuration is used.
* `proxy_host` - Proxy hostname if proxy configuration is used.
* `proxy_port` - Proxy port number if proxy configuration is used.
* `port` - Authorization server and vault port number.
* `oauth_host` - Open authorization server host name.
* `vault_host` - AKV host subdomain.
* `verify_host` - Verify the identity of the AKV host name.
* `verify_ip ` - Verify the identity of the AKV IP address.
* `proxy_username` - Proxy username if proxy configuration is used.
* `proxy_password` - Proxy password if proxy configuration is used.
* `client_id` - Application (client) ID of the deployed Azure application with appropriate access to an AKV.
* `tenant_id` - Directory (tenant) ID of the deployed Azure application with appropriate access to an AKV.
* `skip_verification` - Skip the verification of the updated credentials, set to true to bypass the verification. The default value is false.
### Related ONTAP commands
* `security key-manager external azure update-client-secret`
* `security key-manager external azure update-credentials`
* `security key-manager external azure update-config`
*/
func (a *Client) AzureKeyVaultModify(params *AzureKeyVaultModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultModifyOK, *AzureKeyVaultModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAzureKeyVaultModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "azure_key_vault_modify",
		Method:             "PATCH",
		PathPattern:        "/security/azure-key-vaults/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AzureKeyVaultModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AzureKeyVaultModifyOK:
		return value, nil, nil
	case *AzureKeyVaultModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AzureKeyVaultModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AzureKeyVaultModifyCollection azure key vault modify collection API
*/
func (a *Client) AzureKeyVaultModifyCollection(params *AzureKeyVaultModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultModifyCollectionOK, *AzureKeyVaultModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAzureKeyVaultModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "azure_key_vault_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/azure-key-vaults",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AzureKeyVaultModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AzureKeyVaultModifyCollectionOK:
		return value, nil, nil
	case *AzureKeyVaultModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AzureKeyVaultModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AzureKeyVaultRekeyExternal Rekeys the external key in the key hierarchy for an SVM with an AKV configuration.

### Required properties
* `key_id` - Key identifier of the new AKV key encryption key.
### Related ONTAP commands
* `security key-manager external azure rekey-external`
*/
func (a *Client) AzureKeyVaultRekeyExternal(params *AzureKeyVaultRekeyExternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultRekeyExternalCreated, *AzureKeyVaultRekeyExternalAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAzureKeyVaultRekeyExternalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "azure_key_vault_rekey_external",
		Method:             "POST",
		PathPattern:        "/security/azure-key-vaults/{azure_key_vault.uuid}/rekey-external",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AzureKeyVaultRekeyExternalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AzureKeyVaultRekeyExternalCreated:
		return value, nil, nil
	case *AzureKeyVaultRekeyExternalAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AzureKeyVaultRekeyExternalDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AzureKeyVaultRekeyInternal Rekeys the internal key in the key hierarchy for an SVM with an AKV configuration.

### Related ONTAP commands
* `security key-manager external azure rekey-internal`
*/
func (a *Client) AzureKeyVaultRekeyInternal(params *AzureKeyVaultRekeyInternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultRekeyInternalCreated, *AzureKeyVaultRekeyInternalAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAzureKeyVaultRekeyInternalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "azure_key_vault_rekey_internal",
		Method:             "POST",
		PathPattern:        "/security/azure-key-vaults/{uuid}/rekey-internal",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AzureKeyVaultRekeyInternalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AzureKeyVaultRekeyInternalCreated:
		return value, nil, nil
	case *AzureKeyVaultRekeyInternalAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AzureKeyVaultRekeyInternalDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	AzureKeyVaultRestore Restore the keys for an SVM from a configured AKV.

### Related ONTAP commands
* `security key-manager external azure restore`
*/
func (a *Client) AzureKeyVaultRestore(params *AzureKeyVaultRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AzureKeyVaultRestoreCreated, *AzureKeyVaultRestoreAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAzureKeyVaultRestoreParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "azure_key_vault_restore",
		Method:             "POST",
		PathPattern:        "/security/azure-key-vaults/{uuid}/restore",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AzureKeyVaultRestoreReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *AzureKeyVaultRestoreCreated:
		return value, nil, nil
	case *AzureKeyVaultRestoreAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AzureKeyVaultRestoreDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	BarbicanCollectionGet Retrieves Barbican KMS configurations for all SVMs.

### Related ONTAP commands
* `security key-manager external barbican show`
* `security key-manager external barbican check`
*/
func (a *Client) BarbicanCollectionGet(params *BarbicanCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewBarbicanCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "barbican_collection_get",
		Method:             "GET",
		PathPattern:        "/security/barbican-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &BarbicanCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*BarbicanCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*BarbicanCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	BarbicanCreate Creates a Barbican KMS configuration for the specified SVM.

### Required properties
* `configuration.name` - Name for the new Barbican configuration.
* `svm.uuid` or `svm.name` - Existing SVM in which to create a Barbican KMS.
* `key_id` - Barbican key URL.
* `keystone_url` - Keystone authentication URL.
* `application_cred_id` - Keystone authentication application ID with access to the Barbican KMS.
* `application_cred_secret`- Application credentials secret to authenticate the application credentials ID with Keystone.
### Optional properties
* `proxy_type` - Type of proxy (http/https) if proxy configuration is used.
* `proxy_host` - Proxy hostname if proxy configuration is used.
* `proxy_port` - Proxy port number if proxy configuration is used.
* `proxy_username` - Proxy username if proxy configuration is used.
* `proxy_password` - Proxy password if proxy configuration is used.
* `verify` - Verify the identity of the Barbican KMS?
* `verify_host` - Verify the identity of the Barbican KMS host name?
* `timeout` - Connection timeout in seconds.
### Related ONTAP commands
* `security key-manager external barbican create-config`
*/
func (a *Client) BarbicanCreate(params *BarbicanCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanCreateCreated, *BarbicanCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewBarbicanCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "barbican_create",
		Method:             "POST",
		PathPattern:        "/security/barbican-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &BarbicanCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *BarbicanCreateCreated:
		return value, nil, nil
	case *BarbicanCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*BarbicanCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	BarbicanGet Retrieves the Barbican KMS configuration for the SVM specified by the UUID.

### Related ONTAP commands
* `security key-manager external barbican show`
* `security key-manager external barbican check`
*/
func (a *Client) BarbicanGet(params *BarbicanGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewBarbicanGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "barbican_get",
		Method:             "GET",
		PathPattern:        "/security/barbican-kms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &BarbicanGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*BarbicanGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*BarbicanGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	BarbicanModify Updates the Barbican KMS configuration.

### Optional properties
* `application_cred_id` - New credentials used to verify the application's identity to the Barbican KMS. You must provide both `application_cred_id` and `application_cred_secret` to update the credentials.
* `application_cred_secret` - New credentials secret used to verify the application's identity to the Barbican KMS. You must provide both `application_cred_id` and `application_cred_secret` to update the credentials.
* `proxy_type` - Type of proxy (http/https) if proxy configuration is used.
* `proxy_host` - Proxy hostname if proxy configuration is used.
* `proxy_port` - Proxy port number if proxy configuration is used.
* `proxy_username` - Proxy username if proxy configuration is used.
* `proxy_password` - Proxy password if proxy configuration is used.
* `verify` - Verify the identity of the Barbican KMS?
* `verify_host` - Verify the identity of the Barbican KMS host name?
* `timeout` - Connection timeout in seconds.
### Related ONTAP commands
* `security key-manager external barbican update-credentials`
* `security key-manager external barbican update-config`
*/
func (a *Client) BarbicanModify(params *BarbicanModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanModifyOK, *BarbicanModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewBarbicanModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "barbican_modify",
		Method:             "PATCH",
		PathPattern:        "/security/barbican-kms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &BarbicanModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *BarbicanModifyOK:
		return value, nil, nil
	case *BarbicanModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*BarbicanModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
BarbicanModifyCollection barbican modify collection API
*/
func (a *Client) BarbicanModifyCollection(params *BarbicanModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanModifyCollectionOK, *BarbicanModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewBarbicanModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "barbican_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/barbican-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &BarbicanModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *BarbicanModifyCollectionOK:
		return value, nil, nil
	case *BarbicanModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*BarbicanModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	BarbicanRekeyInternal Rekeys the internal key in the key hierarchy for an SVM with a Barbican KMS configuration.

### Related ONTAP commands
* `security key-manager external barbican rekey-internal`
*/
func (a *Client) BarbicanRekeyInternal(params *BarbicanRekeyInternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanRekeyInternalCreated, *BarbicanRekeyInternalAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewBarbicanRekeyInternalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "barbican_rekey_internal",
		Method:             "POST",
		PathPattern:        "/security/barbican-kms/{uuid}/rekey-internal",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &BarbicanRekeyInternalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *BarbicanRekeyInternalCreated:
		return value, nil, nil
	case *BarbicanRekeyInternalAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*BarbicanRekeyInternalDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	BarbicanRestore Restores the keys for an SVM from a configured Barbican KMS.

### Related ONTAP commands
* `security key-manager external barbican restore`
*/
func (a *Client) BarbicanRestore(params *BarbicanRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BarbicanRestoreCreated, *BarbicanRestoreAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewBarbicanRestoreParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "barbican_restore",
		Method:             "POST",
		PathPattern:        "/security/barbican-kms/{uuid}/restore",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &BarbicanRestoreReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *BarbicanRestoreCreated:
		return value, nil, nil
	case *BarbicanRestoreAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*BarbicanRestoreDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterAccountAdProxyCreate Configures a data SVM as a proxy for Active Directory based authentication for cluster user accounts.

### Required properties
* `svm.name` or `svm.uuid` - Name and UUID of the SVM for a cluster user account.
### Related ONTAP commands
* `security login domain-tunnel create`
### Learn more
* [`DOC /security/authentication/cluster/ad-proxy`](#docs-security-security_authentication_cluster_ad-proxy)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) ClusterAccountAdProxyCreate(params *ClusterAccountAdProxyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterAccountAdProxyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterAccountAdProxyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_account_ad_proxy_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/cluster/ad-proxy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterAccountAdProxyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterAccountAdProxyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterAccountAdProxyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterAccountAdProxyDelete Deletes the data SVM configured as a tunnel for Active Directory based authentication for cluster user accounts.

### Related ONTAP commands
* `security login domain-tunnel delete`
### Learn more
* [`DOC /security/authentication/cluster/ad-proxy`](#docs-security-security_authentication_cluster_ad-proxy)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) ClusterAccountAdProxyDelete(params *ClusterAccountAdProxyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterAccountAdProxyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterAccountAdProxyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_account_ad_proxy_delete",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/cluster/ad-proxy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterAccountAdProxyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterAccountAdProxyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterAccountAdProxyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterAccountAdProxyGet Retrieves SVM information configured as an Active Directory domain-tunnel.

### Related ONTAP commands
* `security login domain-tunnel show`
### Learn more
* [`DOC /security/authentication/cluster/ad-proxy`](#docs-security-security_authentication_cluster_ad-proxy)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) ClusterAccountAdProxyGet(params *ClusterAccountAdProxyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterAccountAdProxyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterAccountAdProxyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_account_ad_proxy_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/cluster/ad-proxy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterAccountAdProxyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterAccountAdProxyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterAccountAdProxyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterAccountAdProxyModify Updates the data SVM configured as a tunnel for Active Directory based authentication for cluster user accounts.

### Related ONTAP commands
* `security login domain-tunnel modify`
### Learn more
* [`DOC /security/authentication/cluster/ad-proxy`](#docs-security-security_authentication_cluster_ad-proxy)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) ClusterAccountAdProxyModify(params *ClusterAccountAdProxyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterAccountAdProxyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterAccountAdProxyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_account_ad_proxy_modify",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/cluster/ad-proxy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterAccountAdProxyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterAccountAdProxyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterAccountAdProxyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterLdapCreate A cluster can have only one LDAP configuration. IPv6 must be enabled if IPv6 family addresses are specified.

### Required properties
* `servers` - List of LDAP servers used for this client configuration.
### Recommended optional properties
* `schema` - Schema template name.
* `port` - Port used to connect to the LDAP Servers.
* `ldaps_enabled` - Specifies whether or not LDAPS is enabled.
* `min_bind_level` - Minimum bind authentication level.
* `bind_dn` - Specifies the user that binds to the LDAP servers.
* `base_dn` - Specifies the default base DN for all searches.
* `bind_password` - Specifies the bind password for the LDAP servers.
* `base_scope` - Specifies the default search scope for LDAP queries.
* `use_start_tls` - Specifies whether or not to use Start TLS over LDAP connections.
* `session_security` - Specifies the level of security to be used for LDAP communications.
* `bind_as_cifs_server` - Indicates if CIFS server's credentials are used to bind to the LDAP server.
* `query_timeout` - Maximum time to wait for a query response from the LDAP server, in seconds.
* `user_dn` - User Distinguished Name (DN) used as the starting point in the LDAP directory tree for user lookups.
* `user_scope` - Default search scope for LDAP for user lookups.
* `group_dn` - Group Distinguished Name (DN) used as the starting point in the LDAP directory tree for group lookups.
* `group_scope` - Default search scope for LDAP for group lookups.
* `netgroup_dn` - Netgroup Distinguished Name (DN) used as the starting point in the LDAP directory tree for netgroup lookups.
* `netgroup_scope` - Default search scope for LDAP for netgroup lookups.
* `netgroup_byhost_dn` - Netgroup Distinguished Name (DN) used as the starting point in the LDAP directory tree for netgroup by host lookups.
* `netgroup_byhost_scope` - Default search scope for LDAP for netgroup by host lookups.
* `is_netgroup_byhost_enabled` - Specifies whether netgroup by host querying is enabled.
* `group_membership_filter` - Custom filter used for group membership lookup from an LDAP server.
* `skip_config_validation` - Indicates whether or not the validation for the specified LDAP configuration is disabled.
### Default property values
* `schema` - _RFC-2307_
* `port` - _389_
* `ldaps_enabled` - _false_
* `min_bind_level` - _simple_
* `base_scope` - _subtree_
* `use_start_tls` - _false_
* `session_security` - _none_
* `query_timeout` - _3_
* `user_scope` - _subtree_
* `group_scope` - _subtree_
* `netgroup_scope` - _subtree_
* `netgroup_byhost_scope` - _subtree_
* `is_netgroup_byhost_enabled` - _false_
* `skip_config_validation` - _false_
* `try_channel_binding` - _true_
<br/>
Configuring more than one LDAP server is recommended to avoid a single point of failure. Both FQDNs and IP addresses are supported for the `servers` property.
The LDAP servers are validated as part of this operation. LDAP validation fails in the following scenarios:<br/>
1. The server does not have LDAP installed.
2. The server is invalid.
3. The server is unreachable.<br/>
*/
func (a *Client) ClusterLdapCreate(params *ClusterLdapCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterLdapCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterLdapCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ldap_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/cluster/ldap",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterLdapCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterLdapCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterLdapCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterLdapDelete Deletes the LDAP configuration of the cluster.
*/
func (a *Client) ClusterLdapDelete(params *ClusterLdapDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterLdapDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterLdapDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ldap_delete",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/cluster/ldap",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterLdapDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterLdapDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterLdapDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterLdapGet Retrieves the cluster LDAP configuration.

### Related ONTAP commands
  - `ldap show`
  - `ldap check -vserver vs0`
  - `ldap check-ipv6 -vserver vs0`

### Important notes
  - The status.code, status.dn_message, status.message, and status.state fields have the same status fields that are returned using the "ldap check" CLI command.
  - Refer to the ipv4 or ipv6 objects available in the status field to get specific information about the code, dn_messages, or message and state information for ipv4 or ipv6.
*/
func (a *Client) ClusterLdapGet(params *ClusterLdapGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterLdapGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterLdapGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ldap_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/cluster/ldap",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterLdapGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterLdapGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterLdapGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterLdapModify Both mandatory and optional parameters of the LDAP configuration can be updated.

IPv6 must be enabled if IPv6 family addresses are specified. Configuring more than one LDAP server is recommended to avoid a single point of failure. Both FQDNs and IP addresses are supported for the `servers` property.
The LDAP servers are validated as part of this operation. LDAP validation fails in the following scenarios:<br/>
1. The server does not have LDAP installed.
2. The server is invalid.
3. The server is unreachable. <br/>
*/
func (a *Client) ClusterLdapModify(params *ClusterLdapModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterLdapModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterLdapModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_ldap_modify",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/cluster/ldap",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterLdapModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterLdapModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterLdapModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNisCreate The cluster can have one NIS server configuration. Specify the NIS domain and NIS servers as input. The servers field cannot be empty.

Both FQDNs and IP addresses are supported for the `server` property. IPv6 must be enabled if IPv6 family addresses are specified in the `server` property. A maximum of ten NIS servers are supported.
### Required properties
* `domain` - NIS domain to which this configuration belongs.
* `servers` - List of hostnames or IP addresses of NIS servers used by the NIS domain configuration.
*/
func (a *Client) ClusterNisCreate(params *ClusterNisCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNisCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNisCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_nis_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/cluster/nis",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNisCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNisCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNisCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterNisDelete Deletes the NIS configuration of the cluster. NIS can be removed as a source from ns-switch if NIS is not used for lookups.
*/
func (a *Client) ClusterNisDelete(params *ClusterNisDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNisDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNisDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_nis_delete",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/cluster/nis",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNisDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNisDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNisDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ClusterNisGet Retrieves the NIS configuration of the cluster. Both NIS domain and servers are displayed by default.

The `bound_servers` property indicates the successfully bound NIS servers.
*/
func (a *Client) ClusterNisGet(params *ClusterNisGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNisGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNisGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_nis_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/cluster/nis",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNisGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNisGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNisGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ClusterNisModify Both NIS domain and servers can be updated. Domains and servers cannot be empty. Both FQDNs and IP addresses are supported for the 'servers' field. If the domain is updated, NIS servers must also be specified. IPv6 must be enabled if IPv6 family addresses are specified for the `servers` property.<br/>
*/
func (a *Client) ClusterNisModify(params *ClusterNisModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ClusterNisModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewClusterNisModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "cluster_nis_modify",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/cluster/nis",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ClusterNisModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ClusterNisModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ClusterNisModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	CreateCertificateSigningRequest This API generates a Certificate Signing Request(CSR) and a private key pair. A CSR is a message sent securely to a certificate authority (CA) via any electronic media to apply for a digital identity certificate. This is a general utility API for users to generate a CSR.

### Required properties
* `subject_name` - Subject details of the certificate, including but not limited to the common name. Can be omitted if subject_alternatives is specified.
* `subject_alternatives` - Subject Alternate Name (SAN) extensions. Only required if a common name is not specified using subject_name.
### Recommended optional properties
* `security_strength` - Key size of the certificate, in bits. Specifying a stronger security strength in bits is recommended when creating a certificate. A value of at least 128 is necessary when using EC algorithm if the certificate is to be used in the context of TLSv1.3.
* `hash_function` -  Hashing function.
* `algorithm` - Asymmetric algorithm. Algorithm used to generate a public/private key pair when creating a certificate.
### Default property values
If not specified in POST, the following default property values are assigned:
* `security_strength` - _112_
* `hash_function` - _sha256_
* `algorithm` - _rsa_
### Related ONTAP commands
* `security certificate generate-csr`
*/
func (a *Client) CreateCertificateSigningRequest(params *CreateCertificateSigningRequestParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateCertificateSigningRequestOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateCertificateSigningRequestParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "create_certificate_signing_request",
		Method:             "POST",
		PathPattern:        "/security/certificate-signing-request",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &CreateCertificateSigningRequestReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateCertificateSigningRequestOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateCertificateSigningRequestDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DcnCertificateGet Retrieves the client certificate that ONTAP uses for communication with DCN nodes.

### Related ONTAP commands
* `dcn security client show`
*/
func (a *Client) DcnCertificateGet(params *DcnCertificateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnCertificateGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnCertificateGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_certificate_get",
		Method:             "GET",
		PathPattern:        "/dcn/security/client",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnCertificateGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnCertificateGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnCertificateGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DcnCertificateModify Updates the client certificate that ONTAP uses for communication with DCN nodes.

### Required properties
* `ontap-cert-name` - Name of the client certificate used by ONTAP.
### Related ONTAP commands
* `dcn security client modify`
*/
func (a *Client) DcnCertificateModify(params *DcnCertificateModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnCertificateModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnCertificateModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_certificate_modify",
		Method:             "PATCH",
		PathPattern:        "/dcn/security/client",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnCertificateModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnCertificateModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for dcn_certificate_modify: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	DcnClusterCertificateGet Retrieves the certificate that is used by the Kubernetes cluster.

### Related ONTAP commands
* `dcn security certificate k8s show`
*/
func (a *Client) DcnClusterCertificateGet(params *DcnClusterCertificateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterCertificateGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterCertificateGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_certificate_get",
		Method:             "GET",
		PathPattern:        "/dcn/security/cluster/certificate",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterCertificateGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnClusterCertificateGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnClusterCertificateGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DcnClusterCertificateModify Updates the certificate that is used by the Kubernetes cluster.

### Required properties
* `dcn-k8s-cert-name` - Name of the DCN Kubernetes cluster certificate.
### Related ONTAP commands
* `dcn security certificate k8s modify`
*/
func (a *Client) DcnClusterCertificateModify(params *DcnClusterCertificateModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnClusterCertificateModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnClusterCertificateModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_cluster_certificate_modify",
		Method:             "PATCH",
		PathPattern:        "/dcn/security/cluster/certificate",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnClusterCertificateModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnClusterCertificateModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for dcn_cluster_certificate_modify: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	DcnNodeCertificateCollectionGet Retrieves the certificate that is used by DCN nodes.

### Related ONTAP commands
* `dcn security certificate show`
*/
func (a *Client) DcnNodeCertificateCollectionGet(params *DcnNodeCertificateCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCertificateCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeCertificateCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_certificate_collection_get",
		Method:             "GET",
		PathPattern:        "/dcn/security/node/certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeCertificateCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnNodeCertificateCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnNodeCertificateCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DcnNodeCertificateGet Retrieves a certificate for a given DCN.

### Related ONTAP commands
* `dcn security certificate show`
*/
func (a *Client) DcnNodeCertificateGet(params *DcnNodeCertificateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCertificateGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeCertificateGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_certificate_get",
		Method:             "GET",
		PathPattern:        "/dcn/security/node/certificates/{dcn-node-name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeCertificateGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnNodeCertificateGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DcnNodeCertificateGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DcnNodeCertificateModify Updates the certificate that is used by a specific DCN node.

### Required properties
* `dcn-node-name` - Name of the DCN node.
* `dcn-cert-name` - Certificate name used by the DCN node.
### Related ONTAP commands
* `dcn security certificate modify`
*/
func (a *Client) DcnNodeCertificateModify(params *DcnNodeCertificateModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCertificateModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeCertificateModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_certificate_modify",
		Method:             "PATCH",
		PathPattern:        "/dcn/security/node/certificates/{dcn-node-name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeCertificateModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnNodeCertificateModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for dcn_node_certificate_modify: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DcnNodeCertificateModifyCollection dcn node certificate modify collection API
*/
func (a *Client) DcnNodeCertificateModifyCollection(params *DcnNodeCertificateModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DcnNodeCertificateModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDcnNodeCertificateModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "dcn_node_certificate_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/dcn/security/node/certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DcnNodeCertificateModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DcnNodeCertificateModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for dcn_node_certificate_modify_collection: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
	DuoCollectionGet Retrieves the configured Duo profiles.

### Related ONTAP commands
* `security login duo show`
### Learn more
* [`DOC /security/authentication/duo/profiles`](#docs-security-security_authentication_duo_profiles)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) DuoCollectionGet(params *DuoCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuoCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDuoCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "duo_collection_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/duo/profiles",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DuoCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DuoCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DuoCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DuoCreate Creates a Duo profile.

### Required properties
* `api_host` - Duo API host
* `integration_key` - Integration key
* `secret_key` - Secret key
### Related ONTAP commands
* `security login duo create`
### Learn more
* [`DOC /security/authentication/duo/profiles`](#docs-security-security_authentication_duo_profiles)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) DuoCreate(params *DuoCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuoCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDuoCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "duo_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/duo/profiles",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DuoCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DuoCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DuoCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DuoGet Retrieves the Duo profile configured for the cluster or an SVM.

### Related ONTAP commands
* `security login duo show`
### Learn more
* [`DOC /security/authentication/duo/profiles/{owner.uuid}`](#docs-security-security_authentication_duo_profiles_{owner.uuid})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) DuoGet(params *DuoGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuoGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDuoGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "duo_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/duo/profiles/{owner.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DuoGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DuoGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DuoGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DuoModify Updates a configured Duo profile for a cluster or an SVM.

### Related ONTAP commands
* `security login duo modify`
### Learn more
* [`DOC /security/authentication/duo/profiles/{owner.uuid}`](#docs-security-security_authentication_duo_profiles_{owner.uuid})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) DuoModify(params *DuoModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuoModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDuoModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "duo_modify",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/duo/profiles/{owner.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DuoModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DuoModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DuoModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DuoModifyCollection duo modify collection API
*/
func (a *Client) DuoModifyCollection(params *DuoModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuoModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDuoModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "duo_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/duo/profiles",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DuoModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DuoModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DuoModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DuogroupCollectionGet Retrieves the configured groups.

### Related ONTAP commands
* `security login duo group show`
### Learn more
* [`DOC /security/authentication/duo/groups`](#docs-security-security_authentication_duo_groups)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) DuogroupCollectionGet(params *DuogroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuogroupCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDuogroupCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "duogroup_collection_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/duo/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DuogroupCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DuogroupCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DuogroupCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DuogroupCreate Creates a Duo group.

### Required properties
* `name` - Group name
### Related ONTAP commands
* `security login duo group create`
### Learn more
* [`DOC /security/authentication/duo/groups`](#docs-security-security_authentication_duo_groups)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) DuogroupCreate(params *DuogroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuogroupCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDuogroupCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "duogroup_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/duo/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DuogroupCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DuogroupCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DuogroupCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DuogroupGet Retrieves the Duo group configured for an SVM or cluster.

### Related ONTAP commands
* `security login duo group show`
### Learn more
* [`DOC /security/authentication/duo/groups/{owner.uuid}/{name}`](#docs-security-security_authentication_duo_groups_{owner.uuid}_{name})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) DuogroupGet(params *DuogroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuogroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDuogroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "duogroup_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/duo/groups/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DuogroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DuogroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DuogroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	DuogroupModify Updates a configured Duo group for a cluster or SVM.

### Related ONTAP commands
* `security login duo group modify`
### Learn more
* [`DOC /security/authentication/duo/groups/{owner.uuid}/{name}`](#docs-security-security_authentication_duo_groups_{owner.uuid}_{name})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) DuogroupModify(params *DuogroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuogroupModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDuogroupModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "duogroup_modify",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/duo/groups/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DuogroupModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DuogroupModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DuogroupModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DuogroupModifyCollection duogroup modify collection API
*/
func (a *Client) DuogroupModifyCollection(params *DuogroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DuogroupModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDuogroupModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "duogroup_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/duo/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &DuogroupModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DuogroupModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DuogroupModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GcpKmsCollectionGet Retrieves Google Cloud KMS configurations for all clusters and SVMs.

### Related ONTAP commands
* `security key-manager external gcp show`
* `security key-manager external gcp check`
*/
func (a *Client) GcpKmsCollectionGet(params *GcpKmsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGcpKmsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "gcp_kms_collection_get",
		Method:             "GET",
		PathPattern:        "/security/gcp-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GcpKmsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GcpKmsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GcpKmsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GcpKmsCreate Configures the Google Cloud KMS configuration for the specified SVM.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create a Google Cloud KMS.
* `project_id` - Google Cloud project (application) ID of the deployed Google Cloud application with appropriate access to the Google Cloud KMS.
* `key_ring_name` - Google Cloud KMS key ring name of the deployed Google Cloud application with appropriate access to the specified Google Cloud KMS.
* `key_ring_location` - Google Cloud KMS key ring location.
* `key_name`- Key Identifier of the Google Cloud KMS key encryption key.
* `application_credentials` - The Google Cloud application's service account credentials required to access the specified KMS. This is a JSON file containing an email address and the private key of the service account holder. The field is required if the `authentication_method` is set to `application_credentials_key`.
### Optional properties
* `proxy_type` - Type of proxy (http/https) if proxy configuration is used.
* `proxy_host` - Proxy hostname if proxy configuration is used.
* `proxy_port` - Proxy port number if proxy configuration is used.
* `proxy_username` - Proxy username if proxy configuration is used.
* `proxy_password` - Proxy password if proxy configuration is used.
* `port` - Authorization server and Google Cloud KMS port number.
* `cloudkms_host` - Google Cloud KMS host subdomain.
* `oauth_host` - Open authorization server host name.
* `oauth_url` - Open authorization URL for the access token.
* `privileged_account` - Account used to impersonate Google Cloud KMS requests.
* `verify_ip` - Verify identity of Google Cloud KMS IP address.
* `verify_host` - Verify the identity of the Google Cloud KMS host name.
* `authentication_method` - The authentication method to use for retrieving short lived authentication tokens.
* `gce_metadata_server` - A custom metadata server URL used for retrieving short lived authentication tokens if the default service account is not used. This is only applicable when the `authentication_method` is set to `sa_credentials_attachment`.
### Related ONTAP commands
* `security key-manager external gcp enable`
*/
func (a *Client) GcpKmsCreate(params *GcpKmsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsCreateCreated, *GcpKmsCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGcpKmsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "gcp_kms_create",
		Method:             "POST",
		PathPattern:        "/security/gcp-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GcpKmsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GcpKmsCreateCreated:
		return value, nil, nil
	case *GcpKmsCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GcpKmsCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GcpKmsDelete Deletes a Google Cloud KMS configuration.

### Related ONTAP commands
* `security key-manager external gcp disable`
*/
func (a *Client) GcpKmsDelete(params *GcpKmsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsDeleteOK, *GcpKmsDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGcpKmsDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "gcp_kms_delete",
		Method:             "DELETE",
		PathPattern:        "/security/gcp-kms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GcpKmsDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GcpKmsDeleteOK:
		return value, nil, nil
	case *GcpKmsDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GcpKmsDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GcpKmsDeleteCollection gcp kms delete collection API
*/
func (a *Client) GcpKmsDeleteCollection(params *GcpKmsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsDeleteCollectionOK, *GcpKmsDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGcpKmsDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "gcp_kms_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/gcp-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GcpKmsDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GcpKmsDeleteCollectionOK:
		return value, nil, nil
	case *GcpKmsDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GcpKmsDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GcpKmsGet Retrieves the Google Cloud KMS configuration for the SVM specified by the UUID.

### Related ONTAP commands
* `security key-manager external gcp show`
* `security key-manager external gcp check`
*/
func (a *Client) GcpKmsGet(params *GcpKmsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGcpKmsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "gcp_kms_get",
		Method:             "GET",
		PathPattern:        "/security/gcp-kms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GcpKmsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GcpKmsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GcpKmsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GcpKmsModify Updates the Google Cloud KMS configuration.

### Optional properties
* `application_credentials` - New credentials used to verify the application's identity to the Google Cloud KMS.
* `proxy_type` - Type of proxy (http/https) if proxy configuration is used.
* `proxy_host` - Proxy hostname if proxy configuration is used.
* `proxy_port` - Proxy port number if proxy configuration is used.
* `port` - Authorization server and Google Cloud KMS port number.
* `proxy_username` - Proxy username if proxy configuration is used.
* `proxy_password` - Proxy password if proxy configuration is used.
* `project_id` - Google Cloud project (application) ID of the deployed Google Cloud application with appropriate access to the Google Cloud KMS.
* `key_ring_name` - Google Cloud KMS key ring name of the deployed Google Cloud application with appropriate access to the specified Google Cloud KMS.
* `key_ring_location` - Google Cloud KMS key ring location.
* `cloudkms_host` - Google Cloud KMS host subdomain.
* `oauth_host` - Open authorization server host name.
* `oauth_url` - Open authorization URL for the access token.
* `verify_host` - Verify the identity of the Google Cloud KMS host name.
* `verify_ip ` - Verify identity of Google Cloud KMS IP address.
* `privileged_account` - Account used to impersonate Google Cloud KMS requests.
* `authentication_method` - The authentication method to use for retrieving short lived authentication tokens.
* `gce_metadata_server` - A custom metadata server URL used for retrieving short lived authentication tokens if the default service account is not used. This is only applicable when the `authentication_method` is set to `sa_credentials_attachment`.
### Related ONTAP commands
* `security key-manager external gcp update-credentials`
* `security key-manager external gcp update-config`
*/
func (a *Client) GcpKmsModify(params *GcpKmsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsModifyOK, *GcpKmsModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGcpKmsModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "gcp_kms_modify",
		Method:             "PATCH",
		PathPattern:        "/security/gcp-kms/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GcpKmsModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GcpKmsModifyOK:
		return value, nil, nil
	case *GcpKmsModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GcpKmsModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GcpKmsModifyCollection gcp kms modify collection API
*/
func (a *Client) GcpKmsModifyCollection(params *GcpKmsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsModifyCollectionOK, *GcpKmsModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGcpKmsModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "gcp_kms_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/gcp-kms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GcpKmsModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GcpKmsModifyCollectionOK:
		return value, nil, nil
	case *GcpKmsModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GcpKmsModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GcpKmsRekeyExternal Rekeys the external key in the key hierarchy for an SVM with a Google Cloud KMS configuration.

### Required properties
* `key_name` - Google Cloud KMS key name.
### Optional properties
* `project_id` - Google Cloud KMS project ID.
* `key_ring_location` - Google Cloud KMS key ring location.
* `key_ring_name` - Google Cloud KMS key ring name.
### Related ONTAP commands
* `security key-manager external gcp rekey-external`
*/
func (a *Client) GcpKmsRekeyExternal(params *GcpKmsRekeyExternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsRekeyExternalCreated, *GcpKmsRekeyExternalAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGcpKmsRekeyExternalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "gcp_kms_rekey_external",
		Method:             "POST",
		PathPattern:        "/security/gcp-kms/{gcp_kms.uuid}/rekey-external",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GcpKmsRekeyExternalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GcpKmsRekeyExternalCreated:
		return value, nil, nil
	case *GcpKmsRekeyExternalAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GcpKmsRekeyExternalDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GcpKmsRekeyInternal Rekeys the internal key in the key hierarchy for an SVM with a Google Cloud KMS configuration.

### Related ONTAP commands
* `security key-manager external gcp rekey-internal`
*/
func (a *Client) GcpKmsRekeyInternal(params *GcpKmsRekeyInternalParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsRekeyInternalCreated, *GcpKmsRekeyInternalAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGcpKmsRekeyInternalParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "gcp_kms_rekey_internal",
		Method:             "POST",
		PathPattern:        "/security/gcp-kms/{uuid}/rekey-internal",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GcpKmsRekeyInternalReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GcpKmsRekeyInternalCreated:
		return value, nil, nil
	case *GcpKmsRekeyInternalAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GcpKmsRekeyInternalDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GcpKmsRestore Restores the keys for an SVM from a configured Google Cloud KMS.

### Related ONTAP commands
* `security key-manager external gcp restore`
*/
func (a *Client) GcpKmsRestore(params *GcpKmsRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GcpKmsRestoreCreated, *GcpKmsRestoreAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGcpKmsRestoreParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "gcp_kms_restore",
		Method:             "POST",
		PathPattern:        "/security/gcp-kms/{uuid}/restore",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GcpKmsRestoreReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *GcpKmsRestoreCreated:
		return value, nil, nil
	case *GcpKmsRestoreAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GcpKmsRestoreDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupRoleMappingsCollectionGet Retrieves all the group to role mapping entries.

### Related ONTAP commands
* `security login group role-mapping show`
*/
func (a *Client) GroupRoleMappingsCollectionGet(params *GroupRoleMappingsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupRoleMappingsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_role_mappings_collection_get",
		Method:             "GET",
		PathPattern:        "/security/group/role-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupRoleMappingsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupRoleMappingsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupRoleMappingsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupRoleMappingsCreate Creates a group to role mapping entry.

### Required properties
* `group_id`
* `ontap_role`
### Optional properties
* `comment`
### Related ONTAP commands
* `security login group role-mapping create`
*/
func (a *Client) GroupRoleMappingsCreate(params *GroupRoleMappingsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupRoleMappingsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_role_mappings_create",
		Method:             "POST",
		PathPattern:        "/security/group/role-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupRoleMappingsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupRoleMappingsCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupRoleMappingsCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupRoleMappingsDelete Deletes a group to role mapping entry.

### Related ONTAP commands
* `security login group role-mapping delete`
*/
func (a *Client) GroupRoleMappingsDelete(params *GroupRoleMappingsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupRoleMappingsDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_role_mappings_delete",
		Method:             "DELETE",
		PathPattern:        "/security/group/role-mappings/{group_id}/{ontap_role.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupRoleMappingsDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupRoleMappingsDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupRoleMappingsDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupRoleMappingsDeleteCollection group role mappings delete collection API
*/
func (a *Client) GroupRoleMappingsDeleteCollection(params *GroupRoleMappingsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupRoleMappingsDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_role_mappings_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/group/role-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupRoleMappingsDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupRoleMappingsDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupRoleMappingsDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupRoleMappingsGet Retrieves a group to role mapping entry.

### Related ONTAP commands
* `security login group role-mapping show`
*/
func (a *Client) GroupRoleMappingsGet(params *GroupRoleMappingsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupRoleMappingsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_role_mappings_get",
		Method:             "GET",
		PathPattern:        "/security/group/role-mappings/{group_id}/{ontap_role.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupRoleMappingsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupRoleMappingsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupRoleMappingsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	GroupRoleMappingsModify Updates a configured group role-mapping.

### Related ONTAP commands
* `security login group role-mapping modify`
*/
func (a *Client) GroupRoleMappingsModify(params *GroupRoleMappingsModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupRoleMappingsModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_role_mappings_modify",
		Method:             "PATCH",
		PathPattern:        "/security/group/role-mappings/{group_id}/{ontap_role.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupRoleMappingsModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupRoleMappingsModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupRoleMappingsModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GroupRoleMappingsModifyCollection group role mappings modify collection API
*/
func (a *Client) GroupRoleMappingsModifyCollection(params *GroupRoleMappingsModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GroupRoleMappingsModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGroupRoleMappingsModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "group_role_mappings_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/group/role-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &GroupRoleMappingsModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GroupRoleMappingsModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GroupRoleMappingsModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecCaCertificateCollectionGet Retrieves the collection of IPsec CA certificates configured for cluster and all SVMs.

### Related ONTAP commands
* `security ipsec ca-certificate show`
*/
func (a *Client) IpsecCaCertificateCollectionGet(params *IpsecCaCertificateCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecCaCertificateCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecCaCertificateCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_ca_certificate_collection_get",
		Method:             "GET",
		PathPattern:        "/security/ipsec/ca-certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecCaCertificateCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecCaCertificateCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecCaCertificateCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecCaCertificateCreate Add CA certificate to IPsec. The CA certificate should already be installed on the cluster prior to adding them to IPsec.

The CA certificate can be installed on the cluster using the /security/certificates endpoint.
The svm.uuid or svm.name should not be supplied for certificates that have a scope of cluster.
### Related ONTAP commands
* `security ipsec ca-certificate add`
*/
func (a *Client) IpsecCaCertificateCreate(params *IpsecCaCertificateCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecCaCertificateCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecCaCertificateCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_ca_certificate_create",
		Method:             "POST",
		PathPattern:        "/security/ipsec/ca-certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecCaCertificateCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecCaCertificateCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecCaCertificateCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecCaCertificateDelete Deletes the IPsec CA certificate with the specified UUID from IPsec.

### Related ONTAP commands
* `security ipsec ca-certificate remove`
*/
func (a *Client) IpsecCaCertificateDelete(params *IpsecCaCertificateDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecCaCertificateDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecCaCertificateDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_ca_certificate_delete",
		Method:             "DELETE",
		PathPattern:        "/security/ipsec/ca-certificates/{certificate.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecCaCertificateDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecCaCertificateDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecCaCertificateDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IpsecCaCertificateDeleteCollection ipsec ca certificate delete collection API
*/
func (a *Client) IpsecCaCertificateDeleteCollection(params *IpsecCaCertificateDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecCaCertificateDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecCaCertificateDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_ca_certificate_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/ipsec/ca-certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecCaCertificateDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecCaCertificateDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecCaCertificateDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecCaCertificateGet Retrieves a specific CA certificate configured for IPsec.

### Related ONTAP commands
* `security ipsec ca-certificate show`
*/
func (a *Client) IpsecCaCertificateGet(params *IpsecCaCertificateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecCaCertificateGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecCaCertificateGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_ca_certificate_get",
		Method:             "GET",
		PathPattern:        "/security/ipsec/ca-certificates/{certificate.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecCaCertificateGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecCaCertificateGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecCaCertificateGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecGet Retrieves IPsec configuration via REST APIs.

### Related ONTAP commands
* 'security ipsec config show'
*/
func (a *Client) IpsecGet(params *IpsecGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_get",
		Method:             "GET",
		PathPattern:        "/security/ipsec",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecModify Updates IPsec configuration via REST APIs.

### Optional properties
* 'enabled' - Enable IPsec.
* 'replay_window' - Replay window size in packets.
* 'offload_enabled' - Enable IPsec hardware offload.
### Related ONTAP commands
* 'security ipsec config modify'
*/
func (a *Client) IpsecModify(params *IpsecModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_modify",
		Method:             "PATCH",
		PathPattern:        "/security/ipsec",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecPolicyCollectionGet Retrieves the collection of IPsec policies.

### Related ONTAP commands
* `security ipsec policy show`
*/
func (a *Client) IpsecPolicyCollectionGet(params *IpsecPolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecPolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/security/ipsec/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecPolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecPolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecPolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecPolicyCreate Creates an IPsec policy.

### Related ONTAP commands
* `security ipsec policy create`
*/
func (a *Client) IpsecPolicyCreate(params *IpsecPolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecPolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_policy_create",
		Method:             "POST",
		PathPattern:        "/security/ipsec/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecPolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecPolicyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecPolicyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecPolicyDelete Deletes a specific IPsec policy.

### Related ONTAP commands
* `security ipsec policy delete`
*/
func (a *Client) IpsecPolicyDelete(params *IpsecPolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecPolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_policy_delete",
		Method:             "DELETE",
		PathPattern:        "/security/ipsec/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecPolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecPolicyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecPolicyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IpsecPolicyDeleteCollection ipsec policy delete collection API
*/
func (a *Client) IpsecPolicyDeleteCollection(params *IpsecPolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecPolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_policy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/ipsec/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecPolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecPolicyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecPolicyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecPolicyGet Retrieves a specific IPsec policy.

### Related ONTAP commands
* `security ipsec policy show`
*/
func (a *Client) IpsecPolicyGet(params *IpsecPolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecPolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_policy_get",
		Method:             "GET",
		PathPattern:        "/security/ipsec/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecPolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecPolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecPolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpsecPolicyModify Updates a specific IPsec policy.

### Related ONTAP commands
* `security ipsec policy modify`
*/
func (a *Client) IpsecPolicyModify(params *IpsecPolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecPolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/security/ipsec/policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecPolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecPolicyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecPolicyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IpsecPolicyModifyCollection ipsec policy modify collection API
*/
func (a *Client) IpsecPolicyModifyCollection(params *IpsecPolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpsecPolicyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpsecPolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipsec_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/ipsec/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpsecPolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpsecPolicyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpsecPolicyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KeyManagerAuthKeyCollectionGet Retrieves a list of all authentication keys associated with the admin SVM.

### Related ONTAP commands
* `security key-manager key query`
### Required properties
* `security_key_manager.uuid` - UUID of the external key manager.
*/
func (a *Client) KeyManagerAuthKeyCollectionGet(params *KeyManagerAuthKeyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerAuthKeyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKeyManagerAuthKeyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "key_manager_auth_key_collection_get",
		Method:             "GET",
		PathPattern:        "/security/key-managers/{security_key_manager.uuid}/auth-keys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KeyManagerAuthKeyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KeyManagerAuthKeyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KeyManagerAuthKeyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KeyManagerAuthKeyCreate Creates an authentication key.

### Related ONTAP commands
* `security key-manager key create`
### Required properties
* `security_key_manager.uuid` - UUID of the external key manager.
*/
func (a *Client) KeyManagerAuthKeyCreate(params *KeyManagerAuthKeyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerAuthKeyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKeyManagerAuthKeyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "key_manager_auth_key_create",
		Method:             "POST",
		PathPattern:        "/security/key-managers/{security_key_manager.uuid}/auth-keys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KeyManagerAuthKeyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KeyManagerAuthKeyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KeyManagerAuthKeyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KeyManagerAuthKeyDelete Deletes an authentication key.

### Related ONTAP commands
* `security key-manager key delete`
### Required properties
* `security_key_manager.uuid` - UUID of the external key manager.
* `key_id` - Key ID of the authentication key to be deleted.
*/
func (a *Client) KeyManagerAuthKeyDelete(params *KeyManagerAuthKeyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerAuthKeyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKeyManagerAuthKeyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "key_manager_auth_key_delete",
		Method:             "DELETE",
		PathPattern:        "/security/key-managers/{security_key_manager.uuid}/auth-keys/{key_id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KeyManagerAuthKeyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KeyManagerAuthKeyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KeyManagerAuthKeyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
KeyManagerAuthKeyDeleteCollection key manager auth key delete collection API
*/
func (a *Client) KeyManagerAuthKeyDeleteCollection(params *KeyManagerAuthKeyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerAuthKeyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKeyManagerAuthKeyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "key_manager_auth_key_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/key-managers/{security_key_manager.uuid}/auth-keys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KeyManagerAuthKeyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KeyManagerAuthKeyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KeyManagerAuthKeyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KeyManagerAuthKeyGet Retrieves the authentication key identified by the 'key_id' and associated with the admin SVM.

### Related ONTAP commands
* `security key-manager key query`
### Required properties
* `security_key_manager.uuid` - UUID of the external key manager.
* `key_id` - Key ID of the authentication key to be retrieved.
*/
func (a *Client) KeyManagerAuthKeyGet(params *KeyManagerAuthKeyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerAuthKeyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKeyManagerAuthKeyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "key_manager_auth_key_get",
		Method:             "GET",
		PathPattern:        "/security/key-managers/{security_key_manager.uuid}/auth-keys/{key_id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KeyManagerAuthKeyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KeyManagerAuthKeyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KeyManagerAuthKeyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KeyManagerConfigGet Retrieves key manager configurations.

Retrieves the key manager health monitor policy (fields=health_monitor_policy).
### Related ONTAP commands
* `security key-manager config show`
* `security key-manager health policy show`
*/
func (a *Client) KeyManagerConfigGet(params *KeyManagerConfigGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerConfigGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKeyManagerConfigGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "key_manager_config_get",
		Method:             "GET",
		PathPattern:        "/security/key-manager-configs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KeyManagerConfigGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KeyManagerConfigGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KeyManagerConfigGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KeyManagerConfigModify Updates key manager configurations.

Updates the key manager health monitor policy.
### Related ONTAP commands
* `security key-manager config modify`
* `security key-manager health policy modify`
*/
func (a *Client) KeyManagerConfigModify(params *KeyManagerConfigModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerConfigModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKeyManagerConfigModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "key_manager_config_modify",
		Method:             "PATCH",
		PathPattern:        "/security/key-manager-configs",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KeyManagerConfigModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KeyManagerConfigModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KeyManagerConfigModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KeyManagerKeysCollectionGet Retrieves key manager configurations.

### Required properties
* `security_key_manager.uuid` - Key manager UUID.
* `node.uuid` - Node UUID.
### Related ONTAP commands
* `security key-manager key query`
* `security key-manager key query -node <node>`
* `security key-manager key query -node <node> -key-manager <key_manager>`
*/
func (a *Client) KeyManagerKeysCollectionGet(params *KeyManagerKeysCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerKeysCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKeyManagerKeysCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "key_manager_keys_collection_get",
		Method:             "GET",
		PathPattern:        "/security/key-managers/{security_key_manager.uuid}/keys/{node.uuid}/key-ids",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KeyManagerKeysCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KeyManagerKeysCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KeyManagerKeysCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	KeyManagerKeysGet Retrieves the key management keys information for the specified key_id.

### Related ONTAP commands
* `security key-manager key query -key-id <key_id>`
* `security key-manager key query -key-id <key_id> -node <node>`
* `security key-manager key query -key-id <key_id> -node <node> -key-manager <key_manager>`
*/
func (a *Client) KeyManagerKeysGet(params *KeyManagerKeysGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*KeyManagerKeysGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewKeyManagerKeysGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "key_manager_keys_get",
		Method:             "GET",
		PathPattern:        "/security/key-managers/{security_key_manager.uuid}/keys/{node.uuid}/key-ids/{key_id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &KeyManagerKeysGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*KeyManagerKeysGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*KeyManagerKeysGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LoginMessagesCollectionGet Retrieves the login banner and messages of the day (MOTD) configured in the cluster

and in specific SVMs.
*/
func (a *Client) LoginMessagesCollectionGet(params *LoginMessagesCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LoginMessagesCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLoginMessagesCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "login_messages_collection_get",
		Method:             "GET",
		PathPattern:        "/security/login/messages",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LoginMessagesCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LoginMessagesCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LoginMessagesCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LoginMessagesGet Retrieves the login messages configuration by UUID.
*/
func (a *Client) LoginMessagesGet(params *LoginMessagesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LoginMessagesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLoginMessagesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "login_messages_get",
		Method:             "GET",
		PathPattern:        "/security/login/messages/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LoginMessagesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LoginMessagesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LoginMessagesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	LoginMessagesModify Updates the login messages configuration.

There are no required fields. An empty body makes no modifications.
*/
func (a *Client) LoginMessagesModify(params *LoginMessagesModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LoginMessagesModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLoginMessagesModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "login_messages_modify",
		Method:             "PATCH",
		PathPattern:        "/security/login/messages/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LoginMessagesModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LoginMessagesModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LoginMessagesModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LoginMessagesModifyCollection login messages modify collection API
*/
func (a *Client) LoginMessagesModifyCollection(params *LoginMessagesModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LoginMessagesModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLoginMessagesModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "login_messages_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/login/messages",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &LoginMessagesModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LoginMessagesModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LoginMessagesModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyApprovalGroupCollectionGet Retrieves multi-admin-verify approval groups.
*/
func (a *Client) MultiAdminVerifyApprovalGroupCollectionGet(params *MultiAdminVerifyApprovalGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyApprovalGroupCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_approval_group_collection_get",
		Method:             "GET",
		PathPattern:        "/security/multi-admin-verify/approval-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyApprovalGroupCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyApprovalGroupCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyApprovalGroupCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyApprovalGroupCreate Creates a multi-admin-verify approval group.
*/
func (a *Client) MultiAdminVerifyApprovalGroupCreate(params *MultiAdminVerifyApprovalGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyApprovalGroupCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_approval_group_create",
		Method:             "POST",
		PathPattern:        "/security/multi-admin-verify/approval-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyApprovalGroupCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyApprovalGroupCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyApprovalGroupCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyApprovalGroupDelete Deletes a multi-admin-verify approval group.
*/
func (a *Client) MultiAdminVerifyApprovalGroupDelete(params *MultiAdminVerifyApprovalGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyApprovalGroupDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_approval_group_delete",
		Method:             "DELETE",
		PathPattern:        "/security/multi-admin-verify/approval-groups/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyApprovalGroupDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyApprovalGroupDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyApprovalGroupDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyApprovalGroupDeleteCollection multi admin verify approval group delete collection API
*/
func (a *Client) MultiAdminVerifyApprovalGroupDeleteCollection(params *MultiAdminVerifyApprovalGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyApprovalGroupDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_approval_group_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/multi-admin-verify/approval-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyApprovalGroupDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyApprovalGroupDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyApprovalGroupDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyApprovalGroupGet Retrieves a multi-admin-verify approval group.
*/
func (a *Client) MultiAdminVerifyApprovalGroupGet(params *MultiAdminVerifyApprovalGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyApprovalGroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_approval_group_get",
		Method:             "GET",
		PathPattern:        "/security/multi-admin-verify/approval-groups/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyApprovalGroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyApprovalGroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyApprovalGroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyApprovalGroupModify Updates a multi-admin-verify approval group.
*/
func (a *Client) MultiAdminVerifyApprovalGroupModify(params *MultiAdminVerifyApprovalGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyApprovalGroupModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_approval_group_modify",
		Method:             "PATCH",
		PathPattern:        "/security/multi-admin-verify/approval-groups/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyApprovalGroupModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyApprovalGroupModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyApprovalGroupModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyApprovalGroupModifyCollection multi admin verify approval group modify collection API
*/
func (a *Client) MultiAdminVerifyApprovalGroupModifyCollection(params *MultiAdminVerifyApprovalGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyApprovalGroupModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyApprovalGroupModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_approval_group_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/multi-admin-verify/approval-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyApprovalGroupModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyApprovalGroupModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyApprovalGroupModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyConfigGet Retrieves the multi-admin-verify configuration.
*/
func (a *Client) MultiAdminVerifyConfigGet(params *MultiAdminVerifyConfigGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyConfigGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyConfigGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_config_get",
		Method:             "GET",
		PathPattern:        "/security/multi-admin-verify",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyConfigGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyConfigGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyConfigGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyConfigModify Modifies the multi-admin-verify configuration.
*/
func (a *Client) MultiAdminVerifyConfigModify(params *MultiAdminVerifyConfigModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyConfigModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyConfigModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_config_modify",
		Method:             "PATCH",
		PathPattern:        "/security/multi-admin-verify",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyConfigModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyConfigModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyConfigModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRequestCollectionGet Retrieves multi-admin-verify requests.
*/
func (a *Client) MultiAdminVerifyRequestCollectionGet(params *MultiAdminVerifyRequestCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRequestCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_request_collection_get",
		Method:             "GET",
		PathPattern:        "/security/multi-admin-verify/requests",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRequestCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRequestCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRequestCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRequestCreate Creates a multi-admin-verify request.
*/
func (a *Client) MultiAdminVerifyRequestCreate(params *MultiAdminVerifyRequestCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRequestCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_request_create",
		Method:             "POST",
		PathPattern:        "/security/multi-admin-verify/requests",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRequestCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRequestCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRequestCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRequestDelete Deletes a multi-admin-verify request.
*/
func (a *Client) MultiAdminVerifyRequestDelete(params *MultiAdminVerifyRequestDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRequestDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_request_delete",
		Method:             "DELETE",
		PathPattern:        "/security/multi-admin-verify/requests/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRequestDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRequestDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRequestDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRequestDeleteCollection multi admin verify request delete collection API
*/
func (a *Client) MultiAdminVerifyRequestDeleteCollection(params *MultiAdminVerifyRequestDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRequestDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_request_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/multi-admin-verify/requests",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRequestDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRequestDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRequestDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRequestGet Retrieves a multi-admin-verify request.
*/
func (a *Client) MultiAdminVerifyRequestGet(params *MultiAdminVerifyRequestGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRequestGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_request_get",
		Method:             "GET",
		PathPattern:        "/security/multi-admin-verify/requests/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRequestGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRequestGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRequestGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRequestModify Updates a multi-admin-verify request.
*/
func (a *Client) MultiAdminVerifyRequestModify(params *MultiAdminVerifyRequestModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRequestModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_request_modify",
		Method:             "PATCH",
		PathPattern:        "/security/multi-admin-verify/requests/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRequestModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRequestModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRequestModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRequestModifyCollection multi admin verify request modify collection API
*/
func (a *Client) MultiAdminVerifyRequestModifyCollection(params *MultiAdminVerifyRequestModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRequestModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRequestModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_request_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/multi-admin-verify/requests",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRequestModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRequestModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRequestModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRuleCollectionGet Retrieves multi-admin-verify rules.
*/
func (a *Client) MultiAdminVerifyRuleCollectionGet(params *MultiAdminVerifyRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRuleCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_rule_collection_get",
		Method:             "GET",
		PathPattern:        "/security/multi-admin-verify/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRuleCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRuleCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRuleCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRuleCreate Creates a multi-admin-verify rule.
*/
func (a *Client) MultiAdminVerifyRuleCreate(params *MultiAdminVerifyRuleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRuleCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_rule_create",
		Method:             "POST",
		PathPattern:        "/security/multi-admin-verify/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRuleCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRuleCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRuleCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRuleDelete Deletes a multi-admin-verify rule.
*/
func (a *Client) MultiAdminVerifyRuleDelete(params *MultiAdminVerifyRuleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRuleDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_rule_delete",
		Method:             "DELETE",
		PathPattern:        "/security/multi-admin-verify/rules/{owner.uuid}/{operation}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRuleDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRuleDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRuleDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRuleDeleteCollection multi admin verify rule delete collection API
*/
func (a *Client) MultiAdminVerifyRuleDeleteCollection(params *MultiAdminVerifyRuleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRuleDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_rule_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/multi-admin-verify/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRuleDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRuleDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRuleDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRuleGet Retrieves a multi-admin-verify rule.
*/
func (a *Client) MultiAdminVerifyRuleGet(params *MultiAdminVerifyRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRuleGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_rule_get",
		Method:             "GET",
		PathPattern:        "/security/multi-admin-verify/rules/{owner.uuid}/{operation}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRuleGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRuleGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRuleGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRuleModify Updates a multi-admin-verify rule.
*/
func (a *Client) MultiAdminVerifyRuleModify(params *MultiAdminVerifyRuleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRuleModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_rule_modify",
		Method:             "PATCH",
		PathPattern:        "/security/multi-admin-verify/rules/{owner.uuid}/{operation}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRuleModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRuleModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRuleModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
MultiAdminVerifyRuleModifyCollection multi admin verify rule modify collection API
*/
func (a *Client) MultiAdminVerifyRuleModifyCollection(params *MultiAdminVerifyRuleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*MultiAdminVerifyRuleModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewMultiAdminVerifyRuleModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "multi_admin_verify_rule_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/multi-admin-verify/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &MultiAdminVerifyRuleModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MultiAdminVerifyRuleModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*MultiAdminVerifyRuleModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PublickeyCollectionGet Retrieves the public keys configured for user accounts.

### Related ONTAP commands
* `security login publickey show`
### Learn more
* [`DOC /security/authentication/publickeys`](#docs-security-security_authentication_publickeys)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) PublickeyCollectionGet(params *PublickeyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PublickeyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPublickeyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "publickey_collection_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/publickeys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PublickeyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PublickeyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PublickeyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PublickeyCreate Creates a public key along with an optional certificate for a user account.

### Required properties
* `owner.uuid` - UUID of the account owner.
* `name` - User account name.
* `index` - Index number for the public key (where there are multiple keys for the same account).
* `public_key` - The publickey details for the creation of the user account.
### Optional properties
* `comment` - Comment text for the public key.
* `certificate` - The certificate in PEM format.
### Related ONTAP commands
* `security login publickey create`
### Learn more
* [`DOC /security/authentication/publickeys`](#docs-security-security_authentication_publickeys)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) PublickeyCreate(params *PublickeyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PublickeyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPublickeyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "publickey_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/publickeys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PublickeyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PublickeyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PublickeyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PublickeyGet Retrieves the public keys configured for a user account.

### Related ONTAP commands
* `security login publickey show`
### Learn more
* [`DOC /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}`](#docs-security-security_authentication_publickeys_{owner.uuid}_{account.name}_{index})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) PublickeyGet(params *PublickeyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PublickeyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPublickeyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "publickey_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/publickeys/{owner.uuid}/{account.name}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PublickeyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PublickeyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PublickeyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	PublickeyModify Updates the public key and/or certificate for a user account.

### Related ONTAP commands
* `security login publickey modify`
### Learn more
* [`DOC /security/authentication/publickeys/{owner.uuid}/{account.name}/{index}`](#docs-security-security_authentication_publickeys_{owner.uuid}_{account.name}_{index})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) PublickeyModify(params *PublickeyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PublickeyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPublickeyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "publickey_modify",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/publickeys/{owner.uuid}/{account.name}/{index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PublickeyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PublickeyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PublickeyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PublickeyModifyCollection publickey modify collection API
*/
func (a *Client) PublickeyModifyCollection(params *PublickeyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PublickeyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPublickeyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "publickey_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/publickeys",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PublickeyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PublickeyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PublickeyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	RoleCollectionGet Retrieves a list of roles configured in the cluster.

### Related ONTAP commands
* `security login rest-role show`
* `security login role show`
### Learn more
* [`DOC /security/roles`](#docs-security-security_roles)
*/
func (a *Client) RoleCollectionGet(params *RoleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RoleCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRoleCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_collection_get",
		Method:             "GET",
		PathPattern:        "/security/roles",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RoleCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RoleCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RoleCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	RoleCreate Creates a new cluster-scoped role or an SVM-scoped role. For an SVM-scoped role, specify either the SVM name as the owner.name or SVM UUID as the owner.uuid in the request body along with other parameters for the role. The owner.uuid or owner.name are not required to be specified for a cluster-scoped role.

### Required parameters
* `name` - Name of the role to be created.
* `privileges` - Array of privilege tuples. Each tuple consists of a REST API or command/command directory path and its desired access level. If the tuple refers to a command/command directory path, it could optionally contain a query.
### Optional parameters
* `owner.name` or `owner.uuid`  - Name or UUID of the SVM for an SVM-scoped role.
### Related ONTAP commands
* `security login rest-role create`
* `security login role create`
### Learn more
* [`DOC /security/roles`](#docs-security-security_roles)
*/
func (a *Client) RoleCreate(params *RoleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RoleCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRoleCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_create",
		Method:             "POST",
		PathPattern:        "/security/roles",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RoleCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RoleCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RoleCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	RoleDelete Deletes the specified role.

### Required parameters
* `name` - Name of the role to be deleted.
* `owner.uuid` - UUID of the SVM housing the role.
### Related ONTAP commands
* `security login rest-role delete`
* `security login role delete`
### Learn more
* [`DOC /security/roles/{owner.uuid}/{name}`](#docs-security-security_roles_{owner.uuid}_{name})
* [`DOC /security/roles`](#docs-security-security_roles)
*/
func (a *Client) RoleDelete(params *RoleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RoleDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRoleDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_delete",
		Method:             "DELETE",
		PathPattern:        "/security/roles/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RoleDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RoleDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RoleDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
RoleDeleteCollection role delete collection API
*/
func (a *Client) RoleDeleteCollection(params *RoleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RoleDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRoleDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/roles",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RoleDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RoleDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RoleDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	RoleGet Retrieves the details of the specified role.

### Related ONTAP commands
* `security login rest-role show`
* `security login role show`
### Learn more
* [`DOC /security/roles/{owner.uuid}/{name}`](#docs-security-security_roles_{owner.uuid}_{name})
* [`DOC /security/roles`](#docs-security-security_roles)
*/
func (a *Client) RoleGet(params *RoleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RoleGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRoleGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_get",
		Method:             "GET",
		PathPattern:        "/security/roles/{owner.uuid}/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RoleGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RoleGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RoleGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	RolePrivilegeCollectionGet Retrieves privilege details of the specified role.

### Related ONTAP commands
* `security login rest-role show`
* `security login role show`
### Learn more
* [`DOC /security/roles/{owner.uuid}/{name}/privileges`](#docs-security-security_roles_{owner.uuid}_{name}_privileges)
* [`DOC /security/roles`](#docs-security-security_roles)
*/
func (a *Client) RolePrivilegeCollectionGet(params *RolePrivilegeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRolePrivilegeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_privilege_collection_get",
		Method:             "GET",
		PathPattern:        "/security/roles/{owner.uuid}/{name}/privileges",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RolePrivilegeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RolePrivilegeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RolePrivilegeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	RolePrivilegeCreate Adds a privilege tuple (of REST URI or command/command directory path, its access level and an optional query, if the "path" refers to a command/command directory path) to an existing role or creates a new role with the provided tuple.

### Required parameters
* `owner.uuid` - UUID of the SVM that houses this role.
* `name` - Name of the role to be updated.
* `path` - REST URI path (example: <i>/api/storage/volumes</i>) or command/command directory path (example: <i>snaplock compliance-clock</i>). Can be a resource-qualified endpoint (example: <i>/api/storage/volumes/43256a71-be02-474d-a2a9-9642e12a6a2c/snapshots</i>). Currently, resource-qualified endpoints are limited to the following&#58;
#### Snapshots APIs
&ndash; <i>/api/storage/volumes/{volume.uuid}/snapshots</i><br/>
#### File System Analytics APIs
&ndash; <i>/api/storage/volumes/{volume.uuid}/files</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/clients</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/directories</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/files</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/users</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/clients</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/directories</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/files</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/users</i><br/>
<personalities supports=aiml>
#### Artificial Intelligence Data Engine (AIDE) APIs
##### Data Compute Node (DCN) APIs
&ndash; <i>/api/dcn/cluster/nodes/{node.uuid}/metrics</i>
&ndash; <i>/api/dcn/network/ports/{port.uuid}/metrics</i><br/>
##### Data-Engine APIs
&ndash; <i>/api/data-engine/policies/{policy.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/acls</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{entity.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/search</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{version.uuid}/diffs</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-sources</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/entities/{entity.uuid}/custom-attributes</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/queries</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/queries/{query.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/versions/{version.uuid}/diffs</i><br/>
When used in the context of data collection APIs, <i>{version.uuid}</i> refers to a data collection version. In the context of workspace APIs, it refers to a workspace version.<br/>
</personalities>
In the APIs above, and in the context of REST roles, the wildcard character &#42; can be used in place of <i>{volume.uuid}</i> or <i>{svm.uuid}</i> to represent <i>all</i> volumes or <i>all</i> SVMs, depending on whether the REST endpoint references volumes or SVMs. The <i>{volume.uuid}</i> corresponds to the <i>-instance-uuid</i> field in the output of the \"volume show\" command at the diagnostic privilege level. It can also be retrieved through the REST endpoint <i>/api/storage/volumes</i>.<br/>
<personalities supports=aiml>
In the AIDE APIs described above, and in the context of REST roles, the wildcard character &#42; can be used in place of variable components in the Uniform Resource Identifier (URI) path, such as <i>{node.uuid}</i>, <i>{port.uuid}</i>, <i>{policy.uuid}</i>, <i>{workspace.uuid}</i>, <i>{datacollection.uuid}</i>, <i>{entity.uuid}</i>, <i>{version.uuid}</i>, or <i>{query.uuid}</i>. The specific variable to be replaced depends on whether the REST endpoint references nodes, ports, policies, workspaces, data collections, entities, versions, or queries.<br/>
However, when using the wildcard character &#42; in place of a variable component in a URI path, it must replace <b>all</b> variable components in that path. Mixing wildcards and specific values for different variable components within the same URI path is not supported in REST roles. For example, a URI path such as <i>/api/data-engine/workspaces/c6e1b325-4125-11f0-abb5-bc2411f6fd43/data-collections/[*]/search</i> is not supported.<br/>
In summary, only the following two types of resource-qualified endpoints are supported in a REST role:
<ul>

	<li>All variable components in the URI path are specific values. Example: <i>/api/data-engine/workspaces/c6e1b325-4125-11f0-abb5-bc2411f6fd43/data-collections/b09b6d25-4126-11f0-abb5-bc2411f6fd43/search</i></li>
	<li>All variable components in the URI path are wildcards. Example: <i>/api/data-engine/workspaces/[*]/data-collections/[*]/search</i></li>

</ul><br/>
AIDE APIs are supported only in cluster-scoped REST roles, not in SVM-scoped REST roles.<br/>
</personalities>
* `access` - Desired access level for the REST URI path or command/command directory.
### Related ONTAP commands
* `security login rest-role create`
* `security login role create`
### Learn more
* [`DOC /security/roles/{owner.uuid}/{name}/privileges`](#docs-security-security_roles_{owner.uuid}_{name}_privileges)
* [`DOC /security/roles`](#docs-security-security_roles)
*/
func (a *Client) RolePrivilegeCreate(params *RolePrivilegeCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRolePrivilegeCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_privilege_create",
		Method:             "POST",
		PathPattern:        "/security/roles/{owner.uuid}/{name}/privileges",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RolePrivilegeCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RolePrivilegeCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RolePrivilegeCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	RolePrivilegeDelete Deletes a privilege tuple (of REST URI or command/command directory path, its access level and an optional query) from the role. The REST URI can be a resource-qualified endpoint. Currently, the only supported resource-qualified endpoints are the following&#58;<p/>

### Snapshots APIs
&ndash; <i>/api/storage/volumes/{volume.uuid}/snapshots</i><br/>
### File System Analytics APIs
&ndash; <i>/api/storage/volumes/{volume.uuid}/files</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/clients</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/directories</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/files</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/users</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/clients</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/directories</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/files</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/users</i><br/>
#### ONTAP S3 APIs
&ndash; <i>/api/protocols/s3/services/{svm.uuid}/users</i><br/>
<personalities supports=aiml>
#### Artificial Intelligence Data Engine (AIDE) APIs
##### Data Compute Node (DCN) APIs
&ndash; <i>/api/dcn/cluster/nodes/{node.uuid}/metrics</i>
&ndash; <i>/api/dcn/network/ports/{port.uuid}/metrics</i><br/>
##### Data-Engine APIs
&ndash; <i>/api/data-engine/policies/{policy.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/acls</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{entity.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/search</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{version.uuid}/diffs</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-sources</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/entities/{entity.uuid}/custom-attributes</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/queries</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/queries/{query.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/versions/{version.uuid}/diffs</i><br/>
When used in the context of data collection APIs, <i>{version.uuid}</i> refers to a data collection version. In the context of workspace APIs, it refers to a workspace version.<br/>
</personalities>
In the APIs above, and in the context of REST roles, the wildcard character &#42; can be used in place of <i>{volume.uuid}</i> or <i>{svm.uuid}</i> to represent <i>all</i> volumes or <i>all</i> SVMs, depending on whether the REST endpoint references volumes or SVMs. The <i>{volume.uuid}</i> corresponds to the <i>-instance-uuid</i> field in the output of the \"volume show\" command at the diagnostic privilege level. It can also be retrieved through the REST endpoint <i>/api/storage/volumes</i>.<br/>
<personalities supports=aiml>
In the AIDE APIs described above, and in the context of REST roles, the wildcard character &#42; can be used in place of variable components in the Uniform Resource Identifier (URI) path, such as <i>{node.uuid}</i>, <i>{port.uuid}</i>, <i>{policy.uuid}</i>, <i>{workspace.uuid}</i>, <i>{datacollection.uuid}</i>, <i>{entity.uuid}</i>, <i>{version.uuid}</i>, or <i>{query.uuid}</i>. The specific variable to be replaced depends on whether the REST endpoint references nodes, ports, policies, workspaces, data collections, entities, versions, or queries.<br/>
However, when using the wildcard character &#42; in place of a variable component in a URI path, it must replace <b>all</b> variable components in that path. Mixing wildcards and specific values for different variable components within the same URI path is not supported in REST roles. For example, a URI path such as <i>/api/data-engine/workspaces/c6e1b325-4125-11f0-abb5-bc2411f6fd43/data-collections/[*]/search</i> is not supported.<br/>
In summary, only the following two types of resource-qualified endpoints are supported in a REST role:
<ul>

	<li>All variable components in the URI path are specific values. Example: <i>/api/data-engine/workspaces/c6e1b325-4125-11f0-abb5-bc2411f6fd43/data-collections/b09b6d25-4126-11f0-abb5-bc2411f6fd43/search</i></li>
	<li>All variable components in the URI path are wildcards. Example: <i>/api/data-engine/workspaces/[*]/data-collections/[*]/search</i></li>

</ul><br/>
AIDE APIs are supported only in cluster-scoped REST roles, not in SVM-scoped REST roles.<br/>
</personalities>
### Required parameters
* `owner.uuid` - UUID of the SVM which houses this role.
* `name` - Name of the role to be updated.
* `path` - Constituent REST API path or command/command directory path to be deleted from this role. Can be a resource-qualified endpoint (example: <i>/api/svm/svms/43256a71-be02-474d-a2a9-9642e12a6a2c/top-metrics/users</i>). Currently, resource-qualified endpoints are limited to the <i>Snapshots</i>, <i>File System Analytics</i><personalities supports=aiml><i>, Artificial Intelligence Data Engine (AIDE)</i></personalities> and <i>ONTAP S3</i> endpoints listed above in the description.
### Related ONTAP commands
* `security login rest-role delete`
* `security login role delete`
### Learn more
* [`DOC /security/roles/{owner.uuid}/{name}/privileges/{path}`](#docs-security-security_roles_{owner.uuid}_{name}_privileges_{path})
* [`DOC /security/roles`](#docs-security-security_roles)
*/
func (a *Client) RolePrivilegeDelete(params *RolePrivilegeDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRolePrivilegeDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_privilege_delete",
		Method:             "DELETE",
		PathPattern:        "/security/roles/{owner.uuid}/{name}/privileges/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RolePrivilegeDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RolePrivilegeDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RolePrivilegeDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
RolePrivilegeDeleteCollection role privilege delete collection API
*/
func (a *Client) RolePrivilegeDeleteCollection(params *RolePrivilegeDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRolePrivilegeDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_privilege_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/roles/{owner.uuid}/{name}/privileges",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RolePrivilegeDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RolePrivilegeDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RolePrivilegeDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	RolePrivilegeGet Retrieves the access level for a REST API path or command/command directory path for the specified role. Optionally retrieves the query, if 'path' refers to a command/command directory path. The REST API path can be a resource-qualified endpoint. Currently, the only supported resource-qualified endpoints are the following&#58;<p/>

### Snapshots APIs
&ndash; <i>/api/storage/volumes/{volume.uuid}/snapshots</i><br/>
### File System Analytics APIs
&ndash; <i>/api/storage/volumes/{volume.uuid}/files</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/clients</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/directories</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/files</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/users</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/clients</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/directories</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/files</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/users</i><br/>
#### ONTAP S3 APIs
&ndash; <i>/api/protocols/s3/services/{svm.uuid}/users</i><br/>
<personalities supports=aiml>
#### Artificial Intelligence Data Engine (AIDE) APIs
##### Data Compute Node (DCN) APIs
&ndash; <i>/api/dcn/cluster/nodes/{node.uuid}/metrics</i>
&ndash; <i>/api/dcn/network/ports/{port.uuid}/metrics</i><br/>
##### Data-Engine APIs
&ndash; <i>/api/data-engine/policies/{policy.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/acls</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{entity.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/search</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{version.uuid}/diffs</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-sources</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/entities/{entity.uuid}/custom-attributes</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/queries</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/queries/{query.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/versions/{version.uuid}/diffs</i><br/>
When used in the context of data collection APIs, <i>{version.uuid}</i> refers to a data collection version. In the context of workspace APIs, it refers to a workspace version.<br/>
</personalities>
In the APIs above, and in the context of REST roles, the wildcard character &#42; can be used in place of <i>{volume.uuid}</i> or <i>{svm.uuid}</i> to represent <i>all</i> volumes or <i>all</i> SVMs, depending on whether the REST endpoint references volumes or SVMs. The <i>{volume.uuid}</i> corresponds to the <i>-instance-uuid</i> field in the output of the \"volume show\" command at the diagnostic privilege level. It can also be retrieved through the REST endpoint <i>/api/storage/volumes</i>.<br/>
<personalities supports=aiml>
In the AIDE APIs described above, and in the context of REST roles, the wildcard character &#42; can be used in place of variable components in the Uniform Resource Identifier (URI) path, such as <i>{node.uuid}</i>, <i>{port.uuid}</i>, <i>{policy.uuid}</i>, <i>{workspace.uuid}</i>, <i>{datacollection.uuid}</i>, <i>{entity.uuid}</i>, <i>{version.uuid}</i>, or <i>{query.uuid}</i>. The specific variable to be replaced depends on whether the REST endpoint references nodes, ports, policies, workspaces, data collections, entities, versions, or queries.<br/>
However, when using the wildcard character &#42; in place of a variable component in a URI path, it must replace <b>all</b> variable components in that path. Mixing wildcards and specific values for different variable components within the same URI path is not supported in REST roles. For example, a URI path such as <i>/api/data-engine/workspaces/c6e1b325-4125-11f0-abb5-bc2411f6fd43/data-collections/[*]/search</i> is not supported.<br/>
In summary, only the following two types of resource-qualified endpoints are supported in a REST role:
<ul>

	<li>All variable components in the URI path are specific values. Example: <i>/api/data-engine/workspaces/c6e1b325-4125-11f0-abb5-bc2411f6fd43/data-collections/b09b6d25-4126-11f0-abb5-bc2411f6fd43/search</i></li>
	<li>All variable components in the URI path are wildcards. Example: <i>/api/data-engine/workspaces/[*]/data-collections/[*]/search</i></li>

</ul><br/>
AIDE APIs are supported only in cluster-scoped REST roles, not in SVM-scoped REST roles.<br/>
</personalities>
### Related ONTAP commands
* `security login rest-role show`
* `security login role show`
### Learn more
* [`DOC /security/roles/{owner.uuid}/{name}/privileges/{path}`](#docs-security-security_roles_{owner.uuid}_{name}_privileges_{path})
* [`DOC /security/roles`](#docs-security-security_roles)
*/
func (a *Client) RolePrivilegeGet(params *RolePrivilegeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRolePrivilegeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_privilege_get",
		Method:             "GET",
		PathPattern:        "/security/roles/{owner.uuid}/{name}/privileges/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RolePrivilegeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RolePrivilegeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RolePrivilegeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	RolePrivilegeModify Updates the access level for a REST API path or command/command directory path. Optionally updates the query, if 'path' refers to a command/command directory path. The REST API path can be a resource-qualified endpoint. Currently, the only supported resource-qualified endpoints are the following&#58;<p/>

### Snapshots APIs
&ndash; <i>/api/storage/volumes/{volume.uuid}/snapshots</i><br/>
### File System Analytics APIs
&ndash; <i>/api/storage/volumes/{volume.uuid}/files</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/clients</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/directories</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/files</i>
&ndash; <i>/api/storage/volumes/{volume.uuid}/top-metrics/users</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/clients</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/directories</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/files</i>
&ndash; <i>/api/svm/svms/{svm.uuid}/top-metrics/users</i><br/>
#### ONTAP S3 APIs
&ndash; <i>/api/protocols/s3/services/{svm.uuid}/users</i><br/>
<personalities supports=aiml>
#### Artificial Intelligence Data Engine (AIDE) APIs
##### Data Compute Node (DCN) APIs
&ndash; <i>/api/dcn/cluster/nodes/{node.uuid}/metrics</i>
&ndash; <i>/api/dcn/network/ports/{port.uuid}/metrics</i><br/>
##### Data-Engine APIs
&ndash; <i>/api/data-engine/policies/{policy.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/acls</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/acls</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{entity.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/search</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-collections/{datacollection.uuid}/versions/{version.uuid}/diffs</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/data-sources</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/entities/{entity.uuid}/custom-attributes</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/queries</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/queries/{query.uuid}/entities</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/versions</i>
&ndash; <i>/api/data-engine/workspaces/{workspace.uuid}/versions/{version.uuid}/diffs</i><br/>
When used in the context of data collection APIs, <i>{version.uuid}</i> refers to a data collection version. In the context of workspace APIs, it refers to a workspace version.<br/>
</personalities>
In the APIs above, and in the context of REST roles, the wildcard character &#42; can be used in place of <i>{volume.uuid}</i> or <i>{svm.uuid}</i> to represent <i>all</i> volumes or <i>all</i> SVMs, depending on whether the REST endpoint references volumes or SVMs. The <i>{volume.uuid}</i> corresponds to the <i>-instance-uuid</i> field in the output of the \"volume show\" command at the diagnostic privilege level. It can also be retrieved through the REST endpoint <i>/api/storage/volumes</i>.<br/>
<personalities supports=aiml>
In the AIDE APIs described above, and in the context of REST roles, the wildcard character &#42; can be used in place of variable components in the Uniform Resource Identifier (URI) path, such as <i>{node.uuid}</i>, <i>{port.uuid}</i>, <i>{policy.uuid}</i>, <i>{workspace.uuid}</i>, <i>{datacollection.uuid}</i>, <i>{entity.uuid}</i>, <i>{version.uuid}</i>, or <i>{query.uuid}</i>. The specific variable to be replaced depends on whether the REST endpoint references nodes, ports, policies, workspaces, data collections, entities, versions, or queries.<br/>
However, when using the wildcard character &#42; in place of a variable component in a URI path, it must replace <b>all</b> variable components in that path. Mixing wildcards and specific values for different variable components within the same URI path is not supported in REST roles. For example, a URI path such as <i>/api/data-engine/workspaces/c6e1b325-4125-11f0-abb5-bc2411f6fd43/data-collections/[*]/search</i> is not supported.<br/>
In summary, only the following two types of resource-qualified endpoints are supported in a REST role:
<ul>

	<li>All variable components in the URI path are specific values. Example: <i>/api/data-engine/workspaces/c6e1b325-4125-11f0-abb5-bc2411f6fd43/data-collections/b09b6d25-4126-11f0-abb5-bc2411f6fd43/search</i></li>
	<li>All variable components in the URI path are wildcards. Example: <i>/api/data-engine/workspaces/[*]/data-collections/[*]/search</i></li>

</ul><br/>
AIDE APIs are supported only in cluster-scoped REST roles, not in SVM-scoped REST roles.<br/>
</personalities>
### Required parameters
* `owner.uuid` - UUID of the SVM that houses this role.
* `name` - Name of the role to be updated.
* `path` - Constituent REST API path or command/command directory path, whose access level and/or query are/is to be updated. Can be a resource-qualified endpoint (example: <i>/api/storage/volumes/43256a71-be02-474d-a2a9-9642e12a6a2c/snapshots</i>). Currently, resource-qualified endpoints are limited to the <i>Snapshots</i>, <i>File System Analytics</i><personalities supports=aiml><i>, Artificial Intelligence Data Engine (AIDE)</i></personalities> and <i>ONTAP S3</i> endpoints listed above in the description.
### Optional parameters
* `access` - Access level for the path.
* `query` - Optional query, if the path refers to a command/command directory path.
### Related ONTAP commands
* `security login rest-role modify`
* `security login role modify`
### Learn more
* [`DOC /security/roles/{owner.uuid}/{name}/privileges/{path}`](#docs-security-security_roles_{owner.uuid}_{name}_privileges_{path})
* [`DOC /security/roles`](#docs-security-security_roles)
*/
func (a *Client) RolePrivilegeModify(params *RolePrivilegeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRolePrivilegeModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_privilege_modify",
		Method:             "PATCH",
		PathPattern:        "/security/roles/{owner.uuid}/{name}/privileges/{path}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RolePrivilegeModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RolePrivilegeModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RolePrivilegeModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
RolePrivilegeModifyCollection role privilege modify collection API
*/
func (a *Client) RolePrivilegeModifyCollection(params *RolePrivilegeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RolePrivilegeModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRolePrivilegeModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "role_privilege_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/roles/{owner.uuid}/{name}/privileges",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &RolePrivilegeModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RolePrivilegeModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RolePrivilegeModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityAssociationCollectionGet Retrieves the IPsec and IKE (Internet Key Exchange) security associations.

### Related ONTAP commands
* `security ipsec show-ipsecsa`
* `security ipsec show-ikesa`
*/
func (a *Client) SecurityAssociationCollectionGet(params *SecurityAssociationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityAssociationCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityAssociationCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_association_collection_get",
		Method:             "GET",
		PathPattern:        "/security/ipsec/security-associations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityAssociationCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityAssociationCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityAssociationCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityAssociationGet Retrieves a specific IPsec or IKE (Internet Key Exchange) security association.

### Related ONTAP commands
* `security ipsec show-ipsecsa`
* `security ipsec show-ikesa`
*/
func (a *Client) SecurityAssociationGet(params *SecurityAssociationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityAssociationGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityAssociationGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_association_get",
		Method:             "GET",
		PathPattern:        "/security/ipsec/security-associations/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityAssociationGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityAssociationGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityAssociationGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityAuditGet Retrieves administrative audit settings for GET requests.
*/
func (a *Client) SecurityAuditGet(params *SecurityAuditGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityAuditGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityAuditGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_audit_get",
		Method:             "GET",
		PathPattern:        "/security/audit",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityAuditGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityAuditGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityAuditGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityAuditLogCollectionGet Retrieves the administrative audit log viewer.
*/
func (a *Client) SecurityAuditLogCollectionGet(params *SecurityAuditLogCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityAuditLogCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityAuditLogCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_audit_log_collection_get",
		Method:             "GET",
		PathPattern:        "/security/audit/messages",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityAuditLogCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityAuditLogCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityAuditLogCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityAuditModify Updates administrative audit settings for GET requests.

All of the fields are optional. An empty body will make no changes.
*/
func (a *Client) SecurityAuditModify(params *SecurityAuditModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityAuditModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityAuditModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_audit_modify",
		Method:             "PATCH",
		PathPattern:        "/security/audit",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityAuditModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityAuditModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityAuditModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityCertificateCollectionGet Retrieves security certificates.

### Related ONTAP commands
* `security certificate show`
*/
func (a *Client) SecurityCertificateCollectionGet(params *SecurityCertificateCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityCertificateCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_certificate_collection_get",
		Method:             "GET",
		PathPattern:        "/security/certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityCertificateCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityCertificateCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityCertificateCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityCertificateCreate Creates or installs a certificate or downloads a certificate from Azure Key Vault (AKV) and installs it on the ONTAP cluster.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create or install the certificate.
* `common_name` - Common name of the certificate. Required when creating a certificate.
* `type` - Type of certificate.
* `public_certificate` - Public key certificate in PEM format. Required when installing a certificate.
* `private_key` - Private key certificate in PEM format. Required when installing a CA-signed certificate.
### Recommended optional properties
* `expiry_time` - Certificate expiration time. Specifying an expiration time is recommended when creating a certificate.
* `key_size` - Key size of the certificate in bits. Specifying a strong key size is recommended when creating a certificate.
* `name` - Unique certificate name per SVM or the name of the certificate in AKV, required for downloading AKV certificates. If one is not provided, it is automatically generated.
### AKV required properties for downloading a certificate
* `azure.key_vault` - URI of the Azure Key Vault.
* `azure.client_id` - Application (client) ID of the deployed Azure application with appropriate access to an AKV.
* `azure.tenant_id` - Directory (tenant) ID of the deployed Azure application with appropriate access to an AKV.
* `azure.client_secret` - Secret used by the application to prove its identity to AKV.
* `azure.client_certificate` - PKCS12 certificate used by the application to prove its identity to AKV.
### AKV optional properties for downloading a certificate
* `azure.oauth_host` - Open authorization server host name.
* `azure.proxy.type` - Type of proxy (http, https etc.) if proxy configuration is used.
* `azure.proxy.host` - Proxy hostname if proxy configuration is used.
* `azure.proxy.port` - Proxy port number if proxy configuration is used.
* `azure.proxy.username` - Proxy username if proxy configuration is used.
* `azure.proxy.password` - Proxy password if proxy configuration is used.
* `azure.timeout` - AKV connection timeout in seconds.
* `azure.verify_host` - Verify the identity of the AKV host name.
### Default property values
If not specified in POST, the following default property values are assigned:
* `key_size` - _2048_
* `expiry_time` - _P365DT_
* `hash_function` - _sha256_
### Related ONTAP commands
* `security certificate create`
* `security certificate install`
* `security certificate azure-install`
*/
func (a *Client) SecurityCertificateCreate(params *SecurityCertificateCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityCertificateCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_certificate_create",
		Method:             "POST",
		PathPattern:        "/security/certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityCertificateCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityCertificateCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityCertificateCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityCertificateDelete Deletes a security certificate.

### Related ONTAP commands
* `security certificate delete`
*/
func (a *Client) SecurityCertificateDelete(params *SecurityCertificateDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityCertificateDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_certificate_delete",
		Method:             "DELETE",
		PathPattern:        "/security/certificates/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityCertificateDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityCertificateDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityCertificateDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityCertificateDeleteCollection security certificate delete collection API
*/
func (a *Client) SecurityCertificateDeleteCollection(params *SecurityCertificateDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityCertificateDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_certificate_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityCertificateDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityCertificateDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityCertificateDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityCertificateGet Retrieves security certificates.

### Related ONTAP commands
* `security certificate show`
*/
func (a *Client) SecurityCertificateGet(params *SecurityCertificateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityCertificateGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_certificate_get",
		Method:             "GET",
		PathPattern:        "/security/certificates/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityCertificateGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityCertificateGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityCertificateGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityCertificateSign Signs a certificate.

### Required properties
* `signing_request` - Certificate signing request to be signed by the given certificate authority.
### Recommended optional properties
* `expiry_time` - Certificate expiration time. Specifying an expiration time for a signed certificate is recommended.
* `hash_function` - Hashing function. Specifying a strong hashing function is recommended when signing a certificate.
### Default property values
If not specified in POST, the following default property values are assigned:
* `expiry_time` - _P365DT_
* `hash_function` - _sha256_
### Related ONTAP commands
* `security certificate sign`
This API is used to sign a certificate request using a pre-existing self-signed root certificate. The self-signed root certificate acts as a certificate authority within its scope and maintains the records of its signed certificates. <br/>
The root certificate can be created for a given SVM or for the cluster using [`POST security/certificates`].<br/>
*/
func (a *Client) SecurityCertificateSign(params *SecurityCertificateSignParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityCertificateSignOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityCertificateSignParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_certificate_sign",
		Method:             "POST",
		PathPattern:        "/security/certificates/{ca.uuid}/sign",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityCertificateSignReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityCertificateSignOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityCertificateSignDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityClusterNetworkCertificatesCollectionGet Retrieves the certificate configuration used for cluster network security.

### Related ONTAP commands
* 'security cluster-network certificate show'
*/
func (a *Client) SecurityClusterNetworkCertificatesCollectionGet(params *SecurityClusterNetworkCertificatesCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityClusterNetworkCertificatesCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_cluster_network_certificates_collection_get",
		Method:             "GET",
		PathPattern:        "/security/cluster-network/certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityClusterNetworkCertificatesCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityClusterNetworkCertificatesCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityClusterNetworkCertificatesCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityClusterNetworkCertificatesCreate Specifies the certificate configuration for cluster network security for a given node.

### Required properties
* 'node' - The node to which the certificate will be assigned.
* 'name' - The certificate name.
### Related ONTAP commands
* 'security cluster-network certificate create'
*/
func (a *Client) SecurityClusterNetworkCertificatesCreate(params *SecurityClusterNetworkCertificatesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityClusterNetworkCertificatesCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_cluster_network_certificates_create",
		Method:             "POST",
		PathPattern:        "/security/cluster-network/certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityClusterNetworkCertificatesCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityClusterNetworkCertificatesCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityClusterNetworkCertificatesCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityClusterNetworkCertificatesDelete Deletes the certificate configuration for cluster network security for a given node.

### Required properties
* `node: The name of the node`
### Related ONTAP commands
* 'security cluster-network certificate delete'
*/
func (a *Client) SecurityClusterNetworkCertificatesDelete(params *SecurityClusterNetworkCertificatesDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityClusterNetworkCertificatesDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_cluster_network_certificates_delete",
		Method:             "DELETE",
		PathPattern:        "/security/cluster-network/certificates/{node.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityClusterNetworkCertificatesDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityClusterNetworkCertificatesDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityClusterNetworkCertificatesDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityClusterNetworkCertificatesDeleteCollection security cluster network certificates delete collection API
*/
func (a *Client) SecurityClusterNetworkCertificatesDeleteCollection(params *SecurityClusterNetworkCertificatesDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityClusterNetworkCertificatesDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_cluster_network_certificates_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/cluster-network/certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityClusterNetworkCertificatesDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityClusterNetworkCertificatesDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityClusterNetworkCertificatesDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityClusterNetworkCertificatesGet Retrieves the certificate configuration for cluster network security for a given node.

### Related ONTAP commands
* 'security cluster-network certificate show'
*/
func (a *Client) SecurityClusterNetworkCertificatesGet(params *SecurityClusterNetworkCertificatesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityClusterNetworkCertificatesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_cluster_network_certificates_get",
		Method:             "GET",
		PathPattern:        "/security/cluster-network/certificates/{node.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityClusterNetworkCertificatesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityClusterNetworkCertificatesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityClusterNetworkCertificatesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityClusterNetworkCertificatesModify Updates the certificate configuration for cluster network security for a given node.

### Required properties
* `node: The name of the node`
### Related ONTAP commands
* 'security cluster-network certificate modify'
*/
func (a *Client) SecurityClusterNetworkCertificatesModify(params *SecurityClusterNetworkCertificatesModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityClusterNetworkCertificatesModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_cluster_network_certificates_modify",
		Method:             "PATCH",
		PathPattern:        "/security/cluster-network/certificates/{node.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityClusterNetworkCertificatesModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityClusterNetworkCertificatesModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityClusterNetworkCertificatesModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityClusterNetworkCertificatesModifyCollection security cluster network certificates modify collection API
*/
func (a *Client) SecurityClusterNetworkCertificatesModifyCollection(params *SecurityClusterNetworkCertificatesModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkCertificatesModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityClusterNetworkCertificatesModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_cluster_network_certificates_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/cluster-network/certificates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityClusterNetworkCertificatesModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityClusterNetworkCertificatesModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityClusterNetworkCertificatesModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityClusterNetworkGet Retrieves the cluster network security configuration.

### Related ONTAP commands
* 'security cluster-network show'
*/
func (a *Client) SecurityClusterNetworkGet(params *SecurityClusterNetworkGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityClusterNetworkGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_cluster_network_get",
		Method:             "GET",
		PathPattern:        "/security/cluster-network",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityClusterNetworkGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityClusterNetworkGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityClusterNetworkGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityClusterNetworkModify Updates the cluster network security configuration.

### Optional properties
* 'enabled' - Indicates whether cluster network security is enabled.
* 'mode' - The cluster network security mode.
### Related ONTAP commands
* 'security cluster-network modify'
*/
func (a *Client) SecurityClusterNetworkModify(params *SecurityClusterNetworkModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityClusterNetworkModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityClusterNetworkModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_cluster_network_modify",
		Method:             "PATCH",
		PathPattern:        "/security/cluster-network",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityClusterNetworkModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityClusterNetworkModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityClusterNetworkModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityConfigGet Retrieves information about the security configured on the cluster.

### Related ONTAP commands
* `security config show`
*/
func (a *Client) SecurityConfigGet(params *SecurityConfigGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityConfigGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityConfigGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_config_get",
		Method:             "GET",
		PathPattern:        "/security",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityConfigGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityConfigGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityConfigGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityConfigModify Updates the software FIPS mode or modifies software data encryption.

<personalities supports=unified>The PATCH request can be used to enable conversion of non-encrypted metadata volumes to encrypted metadata volumes and non-NAE aggregates to NAE aggregates.</personalities>
<personalities supports=asar2,aiml>
The PATCH request can be used to enable conversion of all non-encrypted volumes and LUNs to encrypted volumes and LUNs.
The PATCH request can also be used to start the rekey of all encrypted volumes and LUNs.
</personalities>
### Related ONTAP commands
* `security config modify`
*/
func (a *Client) SecurityConfigModify(params *SecurityConfigModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityConfigModifyOK, *SecurityConfigModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityConfigModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_config_modify",
		Method:             "PATCH",
		PathPattern:        "/security",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityConfigModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityConfigModifyOK:
		return value, nil, nil
	case *SecurityConfigModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityConfigModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityExternalRoleMappingCollectionGet Retrieves all external-role-mapping entries.

### Related ONTAP commands
* `security login external-role-mapping show`
*/
func (a *Client) SecurityExternalRoleMappingCollectionGet(params *SecurityExternalRoleMappingCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityExternalRoleMappingCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_external_role_mapping_collection_get",
		Method:             "GET",
		PathPattern:        "/security/external-role-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityExternalRoleMappingCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityExternalRoleMappingCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityExternalRoleMappingCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityExternalRoleMappingCreate Creates an external-role-mapping entry.

### Required properties
* `external_role`
* `provider`
* `ontap_role`
### Optional properties
* `comment`
### Related ONTAP commands
* `security login external-role-mapping create`
*/
func (a *Client) SecurityExternalRoleMappingCreate(params *SecurityExternalRoleMappingCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityExternalRoleMappingCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_external_role_mapping_create",
		Method:             "POST",
		PathPattern:        "/security/external-role-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityExternalRoleMappingCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityExternalRoleMappingCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityExternalRoleMappingCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityExternalRoleMappingDelete Deletes an external-role-mapping entry.

### Related ONTAP commands
* `security login external-role-mapping delete`
*/
func (a *Client) SecurityExternalRoleMappingDelete(params *SecurityExternalRoleMappingDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityExternalRoleMappingDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_external_role_mapping_delete",
		Method:             "DELETE",
		PathPattern:        "/security/external-role-mappings/{external_role}/{provider}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityExternalRoleMappingDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityExternalRoleMappingDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityExternalRoleMappingDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityExternalRoleMappingDeleteCollection security external role mapping delete collection API
*/
func (a *Client) SecurityExternalRoleMappingDeleteCollection(params *SecurityExternalRoleMappingDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityExternalRoleMappingDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_external_role_mapping_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/external-role-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityExternalRoleMappingDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityExternalRoleMappingDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityExternalRoleMappingDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityExternalRoleMappingGet Retrieves an external-role-mapping entry.

### Related ONTAP commands
* `security login external-role-mapping show`
*/
func (a *Client) SecurityExternalRoleMappingGet(params *SecurityExternalRoleMappingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityExternalRoleMappingGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_external_role_mapping_get",
		Method:             "GET",
		PathPattern:        "/security/external-role-mappings/{external_role}/{provider}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityExternalRoleMappingGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityExternalRoleMappingGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityExternalRoleMappingGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityExternalRoleMappingModify Updates an external-role-mapping entry.

### Related ONTAP commands
* `security login external-role-mapping modify`
*/
func (a *Client) SecurityExternalRoleMappingModify(params *SecurityExternalRoleMappingModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityExternalRoleMappingModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_external_role_mapping_modify",
		Method:             "PATCH",
		PathPattern:        "/security/external-role-mappings/{external_role}/{provider}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityExternalRoleMappingModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityExternalRoleMappingModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityExternalRoleMappingModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityExternalRoleMappingModifyCollection security external role mapping modify collection API
*/
func (a *Client) SecurityExternalRoleMappingModifyCollection(params *SecurityExternalRoleMappingModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityExternalRoleMappingModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityExternalRoleMappingModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_external_role_mapping_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/external-role-mappings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityExternalRoleMappingModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityExternalRoleMappingModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityExternalRoleMappingModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityGroupCollectionGet Retrieves all group entries.

### Related ONTAP commands
* `security login group show`
*/
func (a *Client) SecurityGroupCollectionGet(params *SecurityGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityGroupCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_group_collection_get",
		Method:             "GET",
		PathPattern:        "/security/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityGroupCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityGroupCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityGroupCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityGroupCreate Creates a group entry.

### Required properties
* `name`
### Optional properties
* `owner`
* `type`
* `uuid`
* `comment`
### Related ONTAP commands
* `security login group create`
*/
func (a *Client) SecurityGroupCreate(params *SecurityGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityGroupCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_group_create",
		Method:             "POST",
		PathPattern:        "/security/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityGroupCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityGroupCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityGroupCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityGroupDelete Deletes a group entry.

### Related ONTAP commands
* `security login group delete`
*/
func (a *Client) SecurityGroupDelete(params *SecurityGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityGroupDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_group_delete",
		Method:             "DELETE",
		PathPattern:        "/security/groups/{owner.uuid}/{name}/{type}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityGroupDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityGroupDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityGroupDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityGroupDeleteCollection security group delete collection API
*/
func (a *Client) SecurityGroupDeleteCollection(params *SecurityGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityGroupDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_group_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityGroupDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityGroupDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityGroupDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityGroupGet Retrieves a group entry.

### Related ONTAP commands
* `security login group show`
*/
func (a *Client) SecurityGroupGet(params *SecurityGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityGroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_group_get",
		Method:             "GET",
		PathPattern:        "/security/groups/{owner.uuid}/{name}/{type}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityGroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityGroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityGroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityGroupModify Updates configured group information.

### Related ONTAP commands
* `security login group modify`
*/
func (a *Client) SecurityGroupModify(params *SecurityGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityGroupModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_group_modify",
		Method:             "PATCH",
		PathPattern:        "/security/groups/{owner.uuid}/{name}/{type}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityGroupModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityGroupModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityGroupModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityGroupModifyCollection security group modify collection API
*/
func (a *Client) SecurityGroupModifyCollection(params *SecurityGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityGroupModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityGroupModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_group_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityGroupModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityGroupModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityGroupModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityHaNetworkGet Retrieves the HA network security configuration.

### Related ONTAP commands
* 'security ha-network show'
*/
func (a *Client) SecurityHaNetworkGet(params *SecurityHaNetworkGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityHaNetworkGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityHaNetworkGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_ha_network_get",
		Method:             "GET",
		PathPattern:        "/security/ha-network",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityHaNetworkGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityHaNetworkGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityHaNetworkGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityHaNetworkModify Updates the HA network security configuration.

### Optional properties
* 'enabled' - Indicates if HA network security for NVLog traffic is enabled.
### Related ONTAP commands
* 'security ha-network modify'
*/
func (a *Client) SecurityHaNetworkModify(params *SecurityHaNetworkModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityHaNetworkModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityHaNetworkModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_ha_network_modify",
		Method:             "PATCH",
		PathPattern:        "/security/ha-network",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityHaNetworkModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityHaNetworkModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityHaNetworkModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityJitPrivilegeCollectionGet Retrieves global JIT privilege configurations on an SVM.

### Related ONTAP commands
* `security jit-privilege show`
*/
func (a *Client) SecurityJitPrivilegeCollectionGet(params *SecurityJitPrivilegeCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityJitPrivilegeCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_jit_privilege_collection_get",
		Method:             "GET",
		PathPattern:        "/security/jit-privileges",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityJitPrivilegeCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityJitPrivilegeCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityJitPrivilegeCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityJitPrivilegeGet Retrieves the JIT privilege configurations for an SVM.

### Related ONTAP commands
* `security jit-privilege show`
*/
func (a *Client) SecurityJitPrivilegeGet(params *SecurityJitPrivilegeGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityJitPrivilegeGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_jit_privilege_get",
		Method:             "GET",
		PathPattern:        "/security/jit-privileges/{owner.uuid}/{application}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityJitPrivilegeGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityJitPrivilegeGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityJitPrivilegeGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityJitPrivilegeModify Modifies the JIT privilege configurations for an SVM.

### Related ONTAP commands
* `security jit-privilege modify`
*/
func (a *Client) SecurityJitPrivilegeModify(params *SecurityJitPrivilegeModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityJitPrivilegeModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_jit_privilege_modify",
		Method:             "PATCH",
		PathPattern:        "/security/jit-privileges/{owner.uuid}/{application}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityJitPrivilegeModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityJitPrivilegeModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityJitPrivilegeModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityJitPrivilegeModifyCollection security jit privilege modify collection API
*/
func (a *Client) SecurityJitPrivilegeModifyCollection(params *SecurityJitPrivilegeModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityJitPrivilegeModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_jit_privilege_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/jit-privileges",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityJitPrivilegeModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityJitPrivilegeModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityJitPrivilegeModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityJitPrivilegeUserCollectionGet Retrieves the JIT privilege user configurations for an SVM.

### Related ONTAP commands
* `security jit-privilege user show`
*/
func (a *Client) SecurityJitPrivilegeUserCollectionGet(params *SecurityJitPrivilegeUserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeUserCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityJitPrivilegeUserCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_jit_privilege_user_collection_get",
		Method:             "GET",
		PathPattern:        "/security/jit-privilege-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityJitPrivilegeUserCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityJitPrivilegeUserCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityJitPrivilegeUserCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityJitPrivilegeUserCreate Creates the JIT privilege user configurations for an SVM.

### Required properties
* `owner.uuid` - Account owner UUID.
* `account.name` - User name.
* `application` - Application
### Related ONTAP commands
* `security jit-privilege user create`
*/
func (a *Client) SecurityJitPrivilegeUserCreate(params *SecurityJitPrivilegeUserCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeUserCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityJitPrivilegeUserCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_jit_privilege_user_create",
		Method:             "POST",
		PathPattern:        "/security/jit-privilege-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityJitPrivilegeUserCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityJitPrivilegeUserCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityJitPrivilegeUserCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityJitPrivilegeUserDelete Deletes the JIT privilege user configurations for an SVM.

### Related ONTAP commands
* `security jit-privilege user delete`
### Required properties
* `owner.uuid`
* `application`
* `account.name`
*/
func (a *Client) SecurityJitPrivilegeUserDelete(params *SecurityJitPrivilegeUserDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeUserDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityJitPrivilegeUserDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_jit_privilege_user_delete",
		Method:             "DELETE",
		PathPattern:        "/security/jit-privilege-users/{owner.uuid}/{account.name}/{application}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityJitPrivilegeUserDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityJitPrivilegeUserDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityJitPrivilegeUserDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityJitPrivilegeUserDeleteCollection security jit privilege user delete collection API
*/
func (a *Client) SecurityJitPrivilegeUserDeleteCollection(params *SecurityJitPrivilegeUserDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeUserDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityJitPrivilegeUserDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_jit_privilege_user_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/jit-privilege-users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityJitPrivilegeUserDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityJitPrivilegeUserDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityJitPrivilegeUserDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityJitPrivilegeUserGet Retrieves the JIT privilege user configurations for an SVM.

### Related ONTAP commands
* `security jit-privilege user show`
*/
func (a *Client) SecurityJitPrivilegeUserGet(params *SecurityJitPrivilegeUserGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityJitPrivilegeUserGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityJitPrivilegeUserGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_jit_privilege_user_get",
		Method:             "GET",
		PathPattern:        "/security/jit-privilege-users/{owner.uuid}/{account.name}/{application}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityJitPrivilegeUserGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityJitPrivilegeUserGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityJitPrivilegeUserGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerCollectionGet Retrieves key managers.

### Expensive properties
There is an added computational cost to retrieving these properties. They are excluded from default GET results and must be explicitly requested using the `fields` query parameter. For more details, see [`Requesting specific fields`](#Requesting_specific_fields). Additionally, these fields are unavailable for inactive configurations as they are only relevant to active configurations.
* `status.message`
* `status.code`
### Examples
  - To retrieve basic information about a key manager:
    ```
    GET /security/key-managers
    ```
  - To retrieve specific fields, including expensive properties:
    ```
    GET /security/key-managers/?fields=status.code,status.message
    ```

### Related ONTAP commands
* `security key-manager show-key-store`
* `security key-manager external show`
* `security key-manager external show-status`
* `security key-manager onboard show-backup`
*/
func (a *Client) SecurityKeyManagerCollectionGet(params *SecurityKeyManagerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_collection_get",
		Method:             "GET",
		PathPattern:        "/security/key-managers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerCreate Creates a key manager.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create a key manager.
* `external.client_certificate` - Client certificate. Required only when creating an external key manager.
* `external.server_ca_certificates` - Server CA certificates. Required only when creating an external key manager.
* `external.servers.server` - Primary Key servers. Required only when creating an external key manager.
* `onboard.passphrase` - Cluster-wide passphrase. Required only when creating an Onboard Key Manager.
* `synchronize` - Synchronizes missing onboard keys on any node in the cluster. Required only when creating an Onboard Key Manager at the partner site of a MetroCluster configuration.
### Optional parameters:
* `create_inactive` - Create a configuration without enabling it. This flag is set to "false" by default.
### Related ONTAP commands
* `security key-manager external enable`
* `security key-manager onboard enable`
* `security key-manager onboard sync`
*/
func (a *Client) SecurityKeyManagerCreate(params *SecurityKeyManagerCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerCreateCreated, *SecurityKeyManagerCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_create",
		Method:             "POST",
		PathPattern:        "/security/key-managers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityKeyManagerCreateCreated:
		return value, nil, nil
	case *SecurityKeyManagerCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerDelete Deletes a key manager.

### Related ONTAP commands
* `security key-manager external disable`
* `security key-manager onboard disable`
*/
func (a *Client) SecurityKeyManagerDelete(params *SecurityKeyManagerDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_delete",
		Method:             "DELETE",
		PathPattern:        "/security/key-managers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityKeyManagerDeleteCollection security key manager delete collection API
*/
func (a *Client) SecurityKeyManagerDeleteCollection(params *SecurityKeyManagerDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/key-managers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerGet Retrieves key managers.

### Expensive properties
There is an added computational cost to retrieving these properties. They are excluded from default GET results and must be explicitly requested using the `fields` query parameter. For more details, see [`Requesting specific fields`](#Requesting_specific_fields). Additionally, these fields are unavailable for inactive configurations as they are only relevant to active configurations.
* `status.message`
* `status.code`
### Examples
  - To retrieve basic information about a key manager:
    ```
    GET /security/key-managers/{uuid}
    ```
  - To retrieve specific fields, including expensive properties:
    ```
    GET /security/key-managers/{uuid}?fields=status.message
    ```

### Related ONTAP commands
* `security key-manager show-key-store`
* `security key-manager external show`
* `security key-manager external show-status`
* `security key-manager onboard show-backup`
*/
func (a *Client) SecurityKeyManagerGet(params *SecurityKeyManagerGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_get",
		Method:             "GET",
		PathPattern:        "/security/key-managers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerKeyServersCollectionGet Retrieves the list of key servers configured in an external key manager.

### Expensive properties
There is an added computational cost to retrieving these properties. They are excluded from default GET results and must be explicitly requested using the `fields` query parameter. For more details, see [`Requesting specific fields`](#Requesting_specific_fields). Additionally, these fields are unavailable for inactive configurations as they are only relevant to active configurations.
* `connectivity.cluster_availability`
* `connectivity.node_states.node.name`
* `connectivity.node_states.node.uuid`
* `connectivity.node_states.state`
### Examples
  - To retrieve basic information about a key server:
    ```
    GET /security/key-managers/{uuid}/key-servers
    ```
  - To retrieve specific fields, including expensive properties:
    ```
    GET /security/key-managers/{uuid}/key-servers?fields=connectivity.cluster_availability,connectivity.node_states.node.name
    ```

### Related ONTAP commands
* `security key-manager external show`
* `security key-manager external show-status`
*/
func (a *Client) SecurityKeyManagerKeyServersCollectionGet(params *SecurityKeyManagerKeyServersCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerKeyServersCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_key_servers_collection_get",
		Method:             "GET",
		PathPattern:        "/security/key-managers/{uuid}/key-servers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerKeyServersCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerKeyServersCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerKeyServersCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerKeyServersCreate Adds primary key servers to a configured external key manager.

### Required properties
* `uuid` - UUID of the external key manager.
* `server` - Primary Key server name.
### Related ONTAP commands
* `security key-manager external add-servers`
*/
func (a *Client) SecurityKeyManagerKeyServersCreate(params *SecurityKeyManagerKeyServersCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerKeyServersCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_key_servers_create",
		Method:             "POST",
		PathPattern:        "/security/key-managers/{uuid}/key-servers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerKeyServersCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerKeyServersCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerKeyServersCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerKeyServersDelete Deletes a primary key server.

### Optional parameters:
* `force` - Bypass Out of Quorum checks when deleting a primary key server. This flag is set to "false" by default.
### Related ONTAP commands
* `security key-manager external remove-servers`
*/
func (a *Client) SecurityKeyManagerKeyServersDelete(params *SecurityKeyManagerKeyServersDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerKeyServersDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_key_servers_delete",
		Method:             "DELETE",
		PathPattern:        "/security/key-managers/{uuid}/key-servers/{server}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerKeyServersDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerKeyServersDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerKeyServersDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityKeyManagerKeyServersDeleteCollection security key manager key servers delete collection API
*/
func (a *Client) SecurityKeyManagerKeyServersDeleteCollection(params *SecurityKeyManagerKeyServersDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerKeyServersDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_key_servers_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/key-managers/{uuid}/key-servers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerKeyServersDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerKeyServersDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerKeyServersDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerKeyServersGet Retrieves key servers configured in an external key manager.

### Expensive properties
There is an added computational cost to retrieving these properties. They are excluded from default GET results and must be explicitly requested using the `fields` query parameter. For more details, see [`Requesting specific fields`](#Requesting_specific_fields). Additionally, these fields are unavailable for inactive configurations as they are only relevant to active configurations.
* `connectivity.cluster_availability`
* `connectivity.node_states.node.name`
* `connectivity.node_states.node.uuid`
* `connectivity.node_states.state`
### Examples
  - To retrieve basic information about a key server:
    ```
    GET /security/key-managers/{uuid}/key-servers/{server}
    ```
  - To retrieve specific fields, including expensive properties:
    ```
    GET /security/key-managers/{uuid}/key-servers/{server}?fields=connectivity.cluster_availability,connectivity.node_states.node.name
    ```

### Related ONTAP commands
* `security key-manager external show`
* `security key-manager external show-status`
*/
func (a *Client) SecurityKeyManagerKeyServersGet(params *SecurityKeyManagerKeyServersGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerKeyServersGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_key_servers_get",
		Method:             "GET",
		PathPattern:        "/security/key-managers/{uuid}/key-servers/{server}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerKeyServersGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerKeyServersGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerKeyServersGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerKeyServersModify Updates a primary key server.

### Related ONTAP commands
* `security key-manager external modify-server`
*/
func (a *Client) SecurityKeyManagerKeyServersModify(params *SecurityKeyManagerKeyServersModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerKeyServersModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_key_servers_modify",
		Method:             "PATCH",
		PathPattern:        "/security/key-managers/{uuid}/key-servers/{server}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerKeyServersModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerKeyServersModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerKeyServersModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityKeyManagerKeyServersModifyCollection security key manager key servers modify collection API
*/
func (a *Client) SecurityKeyManagerKeyServersModifyCollection(params *SecurityKeyManagerKeyServersModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerKeyServersModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerKeyServersModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_key_servers_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/key-managers/{uuid}/key-servers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerKeyServersModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeyManagerKeyServersModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerKeyServersModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerMigrate Migrates the keys belonging to an SVM between the cluster's key manager and the SVM's key manager. This operation can run for several minutes.

### Required properties
* `source.uuid` - UUID of the source key manager.
* `uuid` - UUID of the destination key manager.
The UUID of onboard and external KMIP key manager can be fetched using [`GET /api/security/key-managers`].
The UUID of Azure Key Vault key manager can be fetched using [`GET /api/security/azure-key-vaults`].
The UUID of Google Cloud key manager can be fetched using [`GET /api/security/gcp-kms`].
The UUID of Amazon Web Services key manager can be fetched using [`GET /api/security/aws-kms`].
### Related ONTAP commands
* `security key-manager key migrate`
*/
func (a *Client) SecurityKeyManagerMigrate(params *SecurityKeyManagerMigrateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerMigrateCreated, *SecurityKeyManagerMigrateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerMigrateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_migrate",
		Method:             "POST",
		PathPattern:        "/security/key-managers/{source.uuid}/migrate",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerMigrateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityKeyManagerMigrateCreated:
		return value, nil, nil
	case *SecurityKeyManagerMigrateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerMigrateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerModify Updates a key manager.

**Note:** When validate_certificates is set, the API returns a 202 status code for successful creation of the job, otherwise an error is returned.
### Required properties (when patching the Onboard Key Manager)
* `onboard.existing_passphrase` - Cluster-wide passphrase. Required only when synchronizing the passphrase of the Onboard Key Manager.
* `synchronize` - Synchronizes missing Onboard Key Manager keys on any node in the cluster. Required only when synchronizing the Onboard Key Manager keys in a local cluster.
### Required properties (when patching an external key manager)
* `external.client_certificate` or `external.server_ca_certificates` - Client certificate or Server CA certificate. Required when modifying an external key manager.
### Optional parameters (when patching an external key manager):
* `validate_certificates` - Validate certificates by testing the connection to the KMIP server using them. This flag is set to "false" by default.
### Related ONTAP commands
* `security key-manager external modify`
* `security key-manager onboard sync`
* `security key-manager onboard update-passphrase`
*/
func (a *Client) SecurityKeyManagerModify(params *SecurityKeyManagerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerModifyOK, *SecurityKeyManagerModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_modify",
		Method:             "PATCH",
		PathPattern:        "/security/key-managers/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityKeyManagerModifyOK:
		return value, nil, nil
	case *SecurityKeyManagerModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityKeyManagerModifyCollection security key manager modify collection API
*/
func (a *Client) SecurityKeyManagerModifyCollection(params *SecurityKeyManagerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerModifyCollectionOK, *SecurityKeyManagerModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/key-managers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityKeyManagerModifyCollectionOK:
		return value, nil, nil
	case *SecurityKeyManagerModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeyManagerRestore Retrieves and restores any current unrestored keys (associated with the storage controller) from the specified key management server.

### Required properties
* `security_key_manager.uuid` - UUID of the key management server.
The UUID of the external key manager can be retrieved using [`GET /api/security/key-managers`].
### Related ONTAP commands
* `security key-manager external restore`
*/
func (a *Client) SecurityKeyManagerRestore(params *SecurityKeyManagerRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeyManagerRestoreCreated, *SecurityKeyManagerRestoreAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeyManagerRestoreParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_key_manager_restore",
		Method:             "POST",
		PathPattern:        "/security/key-managers/{security_key_manager.uuid}/restore",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeyManagerRestoreReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityKeyManagerRestoreCreated:
		return value, nil, nil
	case *SecurityKeyManagerRestoreAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeyManagerRestoreDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeystoreCollectionGet Retrieves keystores.

### Related ONTAP commands
* `security key-manager show-key-store`
* `security key-manager keystore show`
*/
func (a *Client) SecurityKeystoreCollectionGet(params *SecurityKeystoreCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeystoreCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_keystore_collection_get",
		Method:             "GET",
		PathPattern:        "/security/key-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeystoreCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeystoreCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeystoreCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeystoreDelete Deletes an inactive keystore configuration.

### Related ONTAP commands
* `security key-manager keystore delete`
*/
func (a *Client) SecurityKeystoreDelete(params *SecurityKeystoreDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeystoreDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_keystore_delete",
		Method:             "DELETE",
		PathPattern:        "/security/key-stores/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeystoreDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeystoreDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeystoreDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityKeystoreDeleteCollection security keystore delete collection API
*/
func (a *Client) SecurityKeystoreDeleteCollection(params *SecurityKeystoreDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeystoreDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_keystore_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/key-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeystoreDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeystoreDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeystoreDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeystoreGet Retrieves details of the keystore configuration with the specified UUID.

### Related ONTAP commands
* `security key-manager keystore show`
*/
func (a *Client) SecurityKeystoreGet(params *SecurityKeystoreGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeystoreGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_keystore_get",
		Method:             "GET",
		PathPattern:        "/security/key-stores/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeystoreGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityKeystoreGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeystoreGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityKeystoreModify Enables a keystore configuration

### Related ONTAP commands
* `security key-manager keystore enable`
* `security key-manager keystore disable`
*/
func (a *Client) SecurityKeystoreModify(params *SecurityKeystoreModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreModifyOK, *SecurityKeystoreModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeystoreModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_keystore_modify",
		Method:             "PATCH",
		PathPattern:        "/security/key-stores/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeystoreModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityKeystoreModifyOK:
		return value, nil, nil
	case *SecurityKeystoreModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeystoreModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityKeystoreModifyCollection security keystore modify collection API
*/
func (a *Client) SecurityKeystoreModifyCollection(params *SecurityKeystoreModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityKeystoreModifyCollectionOK, *SecurityKeystoreModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityKeystoreModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_keystore_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/key-stores",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityKeystoreModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityKeystoreModifyCollectionOK:
		return value, nil, nil
	case *SecurityKeystoreModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityKeystoreModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityLogForwardingCreate Configures remote syslog/splunk server information.

### Required properties
All of the following fields are required for creating a remote syslog/splunk destination
* `address`
### Optional properties
All of the following fields are optional for creating a remote syslog/splunk destination
* `port` (1 - 65535)
* `ipspace`
* `protocol`
* `facility`
* `verify_server` (Can only be "true" when protocol is "tcp_encrypted")
* `message_format` (Can be either "legacy-netapp" or "rfc-5424")
* `timestamp_format_override` (Can be either "no-override", "rfc-3164", "iso-8601-utc" or "iso-8601-local-time")
* `hostname_format_override` (Can be either "no-override", "fqdn" or "hostname-only")
*/
func (a *Client) SecurityLogForwardingCreate(params *SecurityLogForwardingCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingCreateCreated, *SecurityLogForwardingCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityLogForwardingCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_log_forwarding_create",
		Method:             "POST",
		PathPattern:        "/security/audit/destinations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityLogForwardingCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityLogForwardingCreateCreated:
		return value, nil, nil
	case *SecurityLogForwardingCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityLogForwardingCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityLogForwardingDelete Deletes remote syslog/splunk server information.
*/
func (a *Client) SecurityLogForwardingDelete(params *SecurityLogForwardingDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityLogForwardingDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_log_forwarding_delete",
		Method:             "DELETE",
		PathPattern:        "/security/audit/destinations/{address}/{port}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityLogForwardingDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityLogForwardingDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityLogForwardingDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityLogForwardingDeleteCollection security log forwarding delete collection API
*/
func (a *Client) SecurityLogForwardingDeleteCollection(params *SecurityLogForwardingDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityLogForwardingDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_log_forwarding_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/audit/destinations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityLogForwardingDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityLogForwardingDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityLogForwardingDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityLogForwardingGet Defines a remote syslog/splunk server for sending audit information to.
*/
func (a *Client) SecurityLogForwardingGet(params *SecurityLogForwardingGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityLogForwardingGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_log_forwarding_get",
		Method:             "GET",
		PathPattern:        "/security/audit/destinations/{address}/{port}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityLogForwardingGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityLogForwardingGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityLogForwardingGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityLogForwardingModify Updates remote syslog/splunk server information.
*/
func (a *Client) SecurityLogForwardingModify(params *SecurityLogForwardingModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityLogForwardingModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_log_forwarding_modify",
		Method:             "PATCH",
		PathPattern:        "/security/audit/destinations/{address}/{port}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityLogForwardingModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityLogForwardingModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityLogForwardingModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityLogForwardingModifyCollection security log forwarding modify collection API
*/
func (a *Client) SecurityLogForwardingModifyCollection(params *SecurityLogForwardingModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityLogForwardingModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityLogForwardingModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_log_forwarding_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/audit/destinations",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityLogForwardingModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityLogForwardingModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityLogForwardingModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityOauth2CollectionGet Retrieves all OAuth 2.0 configurations.

### Related ONTAP commands
* `security oauth2 client show`
*/
func (a *Client) SecurityOauth2CollectionGet(params *SecurityOauth2CollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2CollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOauth2CollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oauth2_collection_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/cluster/oauth2/clients",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOauth2CollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityOauth2CollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOauth2CollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityOauth2Create Creates the OAuth 2.0 configuration.

### Required properties
* `name`
* `application`
* `issuer`
### Optional properties
* `audience`
* `client_id`
* `client_secret`
* `introspection.endpoint_uri`
* `introspection.interval`
* `remote_user_claim`
* `jwks.provider_uri`
* `jwks.refresh_interval`
* `outgoing_proxy`
* `use_local_roles_if_present`
* `skip_uri_validation`
* `use_mutual_tls`
* `provider`
### Related ONTAP commands
* `security oauth2 client create`
*/
func (a *Client) SecurityOauth2Create(params *SecurityOauth2CreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2CreateCreated, *SecurityOauth2CreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOauth2CreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oauth2_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/cluster/oauth2/clients",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOauth2CreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityOauth2CreateCreated:
		return value, nil, nil
	case *SecurityOauth2CreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOauth2CreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityOauth2Delete Deletes the OAuth 2.0 configuration with the specified name.

### Required properties
  - `config_name`

### Related ONTAP commands
* `security oauth2 client delete`
*/
func (a *Client) SecurityOauth2Delete(params *SecurityOauth2DeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2DeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOauth2DeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oauth2_delete",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/cluster/oauth2/clients/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOauth2DeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityOauth2DeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOauth2DeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecurityOauth2DeleteCollection security oauth2 delete collection API
*/
func (a *Client) SecurityOauth2DeleteCollection(params *SecurityOauth2DeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2DeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOauth2DeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oauth2_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/cluster/oauth2/clients",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOauth2DeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityOauth2DeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOauth2DeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityOauth2Get Retrieves the OAuth 2.0 configuration with the specified name.

### Related ONTAP commands
* `security oauth2 client show`
*/
func (a *Client) SecurityOauth2Get(params *SecurityOauth2GetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2GetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOauth2GetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oauth2_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/cluster/oauth2/clients/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOauth2GetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityOauth2GetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOauth2GetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityOauth2GlobalGet Retrieves the OAuth 2.0 status.

### Related ONTAP commands
* `security oauth2 show`
*/
func (a *Client) SecurityOauth2GlobalGet(params *SecurityOauth2GlobalGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2GlobalGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOauth2GlobalGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oauth2_global_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/cluster/oauth2",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOauth2GlobalGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityOauth2GlobalGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOauth2GlobalGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityOauth2GlobalModify Updates the OAuth 2.0 status.

### Related ONTAP commands
* `security oauth2 modify`
*/
func (a *Client) SecurityOauth2GlobalModify(params *SecurityOauth2GlobalModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOauth2GlobalModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOauth2GlobalModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oauth2_global_modify",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/cluster/oauth2",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOauth2GlobalModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityOauth2GlobalModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOauth2GlobalModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityOidcCreate Creates the OIDC configuration in the cluster.

### Optional properties
* `skip_uri_validation`
* `jwks_refresh_interval`
* `outgoing_proxy`
* `access_token_issuer`
### Related ONTAP commands
* `security oidc create`
*/
func (a *Client) SecurityOidcCreate(params *SecurityOidcCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOidcCreateCreated, *SecurityOidcCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOidcCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oidc_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/cluster/oidc",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOidcCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecurityOidcCreateCreated:
		return value, nil, nil
	case *SecurityOidcCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOidcCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityOidcDelete Deletes the OIDC configuration in the cluster.

### Related ONTAP commands
* `security oidc delete`
*/
func (a *Client) SecurityOidcDelete(params *SecurityOidcDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOidcDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOidcDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oidc_delete",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/cluster/oidc",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOidcDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityOidcDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOidcDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityOidcGet Retrieves the OIDC configuration in the cluster.

### Related ONTAP commands
* `security oidc show`
*/
func (a *Client) SecurityOidcGet(params *SecurityOidcGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOidcGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOidcGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oidc_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/cluster/oidc",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOidcGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityOidcGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOidcGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecurityOidcModify Updates the OIDC configuration in the cluster.

### Required properties
* `enabled`
### Related ONTAP commands
* `security oidc modify`
*/
func (a *Client) SecurityOidcModify(params *SecurityOidcModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecurityOidcModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecurityOidcModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_oidc_modify",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/cluster/oidc",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecurityOidcModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecurityOidcModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecurityOidcModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecuritySamlDefMetadataCreate Creates the SAML default metadata configuration. Note that `common_name` is mutually exclusive with `serial_number` and `ca` in POST requests.

### Optional properties
* `certificate`
* `host`
*/
func (a *Client) SecuritySamlDefMetadataCreate(params *SecuritySamlDefMetadataCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlDefMetadataCreateCreated, *SecuritySamlDefMetadataCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecuritySamlDefMetadataCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_saml_def_metadata_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/cluster/saml-sp/default-metadata",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecuritySamlDefMetadataCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecuritySamlDefMetadataCreateCreated:
		return value, nil, nil
	case *SecuritySamlDefMetadataCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecuritySamlDefMetadataCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecuritySamlDefMetadataDelete Deletes the SAML default metadata configuration.
*/
func (a *Client) SecuritySamlDefMetadataDelete(params *SecuritySamlDefMetadataDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlDefMetadataDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecuritySamlDefMetadataDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_saml_def_metadata_delete",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/cluster/saml-sp/default-metadata",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecuritySamlDefMetadataDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecuritySamlDefMetadataDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecuritySamlDefMetadataDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecuritySamlDefMetadataGet Retrieves the SAML default metadata configuration.
*/
func (a *Client) SecuritySamlDefMetadataGet(params *SecuritySamlDefMetadataGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlDefMetadataGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecuritySamlDefMetadataGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_saml_def_metadata_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/cluster/saml-sp/default-metadata",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecuritySamlDefMetadataGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecuritySamlDefMetadataGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecuritySamlDefMetadataGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SecuritySamlSpCreate Creates a SAML service provider configuration. Note that "common_name" is mutually exclusive with "serial_number" and "ca" in POST. SAML will initially be disabled, requiring a patch to set "enabled" to "true", so that the user has time to complete the setup of the IdP.

### Required properties
* `idp_uri`
### Optional properties
* `certificate`
* `enabled`
* `host`
*/
func (a *Client) SecuritySamlSpCreate(params *SecuritySamlSpCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlSpCreateCreated, *SecuritySamlSpCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecuritySamlSpCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_saml_sp_create",
		Method:             "POST",
		PathPattern:        "/security/authentication/cluster/saml-sp",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecuritySamlSpCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SecuritySamlSpCreateCreated:
		return value, nil, nil
	case *SecuritySamlSpCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecuritySamlSpCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecuritySamlSpDelete Deletes a SAML service provider configuration.
*/
func (a *Client) SecuritySamlSpDelete(params *SecuritySamlSpDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlSpDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecuritySamlSpDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_saml_sp_delete",
		Method:             "DELETE",
		PathPattern:        "/security/authentication/cluster/saml-sp",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecuritySamlSpDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecuritySamlSpDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecuritySamlSpDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecuritySamlSpGet Retrieves a SAML service provider configuration.
*/
func (a *Client) SecuritySamlSpGet(params *SecuritySamlSpGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlSpGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecuritySamlSpGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_saml_sp_get",
		Method:             "GET",
		PathPattern:        "/security/authentication/cluster/saml-sp",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecuritySamlSpGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecuritySamlSpGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecuritySamlSpGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SecuritySamlSpModify Updates a SAML service provider configuration.
*/
func (a *Client) SecuritySamlSpModify(params *SecuritySamlSpModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SecuritySamlSpModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSecuritySamlSpModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "security_saml_sp_modify",
		Method:             "PATCH",
		PathPattern:        "/security/authentication/cluster/saml-sp",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SecuritySamlSpModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SecuritySamlSpModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SecuritySamlSpModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SSHGet Retrieves the cluster SSH server ciphers, MAC algorithms, key exchange algorithms, host key algorithms, connection limits, login grace time, and _ssh-rsa_ enabled status for public key algorithms.

### Related ONTAP commands
* `security ssh`
* `security protocol ssh`
*/
func (a *Client) SSHGet(params *SSHGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSHGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSHGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ssh_get",
		Method:             "GET",
		PathPattern:        "/security/ssh",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SSHGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSHGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSHGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SSHModify Updates the SSH server setting for a cluster.

### Optional parameters
* `ciphers` - Encryption algorithms for the payload
* `key_exchange_algorithms` - SSH key exchange algorithms
* `mac_algorithms` - MAC algorithms
* `host_key_algorithms` - Host key algorithms
* `max_authentication_retry_count` - Maximum authentication retries allowed before closing the connection
* `connections_per_second` - Maximum allowed connections per second
* `max_instances` - Maximum allowed connections per node
* `is_rsa_in_publickey_algorithms_enabled` - _ssh-rsa_ enabled status for public key algorithms
* `login_grace_time` - The SSH connection login grace time
* `per_source_limit` - Maximum allowed connections from the same client host
### Related ONTAP commands
* `security ssh`
* `security protocol ssh`
*/
func (a *Client) SSHModify(params *SSHModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SSHModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSSHModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ssh_modify",
		Method:             "PATCH",
		PathPattern:        "/security/ssh",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SSHModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SSHModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SSHModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageUnitAntiRansomwareEntropyStatsCollectionGet Retrieves the data-entropy statistics for the storage units.
*/
func (a *Client) StorageUnitAntiRansomwareEntropyStatsCollectionGet(params *StorageUnitAntiRansomwareEntropyStatsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareEntropyStatsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitAntiRansomwareEntropyStatsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_anti_ransomware_entropy_stats_collection_get",
		Method:             "GET",
		PathPattern:        "/security/anti-ransomware/storage-unit/entropy-stats",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitAntiRansomwareEntropyStatsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageUnitAntiRansomwareEntropyStatsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitAntiRansomwareEntropyStatsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageUnitAntiRansomwareEntropyStatsGet Retrieves a data-entropy statistic for the storage unit.
*/
func (a *Client) StorageUnitAntiRansomwareEntropyStatsGet(params *StorageUnitAntiRansomwareEntropyStatsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareEntropyStatsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitAntiRansomwareEntropyStatsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_anti_ransomware_entropy_stats_get",
		Method:             "GET",
		PathPattern:        "/security/anti-ransomware/storage-unit/entropy-stats/{storage_unit.uuid}/{entropy_stats_type}/{timestamp}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitAntiRansomwareEntropyStatsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageUnitAntiRansomwareEntropyStatsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitAntiRansomwareEntropyStatsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageUnitAntiRansomwareSuspectCollectionGet Retrieves information about the storage units on which a ransomware attack is detected.
*/
func (a *Client) StorageUnitAntiRansomwareSuspectCollectionGet(params *StorageUnitAntiRansomwareSuspectCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareSuspectCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitAntiRansomwareSuspectCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_anti_ransomware_suspect_collection_get",
		Method:             "GET",
		PathPattern:        "/security/anti-ransomware/storage-unit/suspects",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitAntiRansomwareSuspectCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageUnitAntiRansomwareSuspectCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitAntiRansomwareSuspectCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageUnitAntiRansomwareSuspectDelete Clear the ransomware attack detected on a storage unit specified by the UUID.
*/
func (a *Client) StorageUnitAntiRansomwareSuspectDelete(params *StorageUnitAntiRansomwareSuspectDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareSuspectDeleteOK, *StorageUnitAntiRansomwareSuspectDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitAntiRansomwareSuspectDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_anti_ransomware_suspect_delete",
		Method:             "DELETE",
		PathPattern:        "/security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitAntiRansomwareSuspectDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageUnitAntiRansomwareSuspectDeleteOK:
		return value, nil, nil
	case *StorageUnitAntiRansomwareSuspectDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitAntiRansomwareSuspectDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageUnitAntiRansomwareSuspectDeleteCollection storage unit anti ransomware suspect delete collection API
*/
func (a *Client) StorageUnitAntiRansomwareSuspectDeleteCollection(params *StorageUnitAntiRansomwareSuspectDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareSuspectDeleteCollectionOK, *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitAntiRansomwareSuspectDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_anti_ransomware_suspect_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/anti-ransomware/storage-unit/suspects",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitAntiRansomwareSuspectDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *StorageUnitAntiRansomwareSuspectDeleteCollectionOK:
		return value, nil, nil
	case *StorageUnitAntiRansomwareSuspectDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitAntiRansomwareSuspectDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StorageUnitAntiRansomwareSuspectGet Retrieves information about the storage unit specified by the UUID.
*/
func (a *Client) StorageUnitAntiRansomwareSuspectGet(params *StorageUnitAntiRansomwareSuspectGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StorageUnitAntiRansomwareSuspectGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStorageUnitAntiRansomwareSuspectGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "storage_unit_anti_ransomware_suspect_get",
		Method:             "GET",
		PathPattern:        "/security/anti-ransomware/storage-unit/suspects/{storage_unit.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &StorageUnitAntiRansomwareSuspectGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StorageUnitAntiRansomwareSuspectGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StorageUnitAntiRansomwareSuspectGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SupportedAlgorithmsCollectionGet Retrieve all WebAuthn supported algorithms entries.

### Related ONTAP commands
* `security webauthn supported-algorithms show`
*/
func (a *Client) SupportedAlgorithmsCollectionGet(params *SupportedAlgorithmsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SupportedAlgorithmsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSupportedAlgorithmsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "supported_algorithms_collection_get",
		Method:             "GET",
		PathPattern:        "/security/webauthn/supported-algorithms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SupportedAlgorithmsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SupportedAlgorithmsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SupportedAlgorithmsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SupportedAlgorithmsGet Retrieves a WebAuthn supported algorithms entry.

### Related ONTAP commands
* `security webauthn supported-algorithms show`
*/
func (a *Client) SupportedAlgorithmsGet(params *SupportedAlgorithmsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SupportedAlgorithmsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSupportedAlgorithmsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "supported_algorithms_get",
		Method:             "GET",
		PathPattern:        "/security/webauthn/supported-algorithms/{owner.uuid}/{algorithm.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SupportedAlgorithmsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SupportedAlgorithmsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SupportedAlgorithmsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmSSHServerCollectionGet Retrieves the SSH server configuration for all the data SVMs.

### Related ONTAP commands
* `security ssh`
*/
func (a *Client) SvmSSHServerCollectionGet(params *SvmSSHServerCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmSSHServerCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmSSHServerCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_ssh_server_collection_get",
		Method:             "GET",
		PathPattern:        "/security/ssh/svms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmSSHServerCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmSSHServerCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmSSHServerCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmSSHServerGet Retrieves the SSH server configuration for the specified data SVM.

### Related ONTAP commands
* `security ssh`
*/
func (a *Client) SvmSSHServerGet(params *SvmSSHServerGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmSSHServerGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmSSHServerGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_ssh_server_get",
		Method:             "GET",
		PathPattern:        "/security/ssh/svms/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmSSHServerGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmSSHServerGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmSSHServerGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SvmSSHServerModify Updates the SSH server configuration for the specified data SVM.

### Optional parameters
* `ciphers` - Encryption algorithms for the payload
* `key_exchange_algorithms` - SSH key exchange algorithms
* `host_key_algorithms` - Host key algorithms
* `mac_algorithms` - MAC algorithms
* `max_authentication_retry_count` - Maximum authentication retries allowed before closing the connection
* `is_rsa_in_publickey_algorithms_enabled` - _ssh-rsa_ enabled status for public key algorithms
* `login_grace_time` - Login grace time allowed for SSH connection
### Related ONTAP commands
* `security ssh`
*/
func (a *Client) SvmSSHServerModify(params *SvmSSHServerModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmSSHServerModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmSSHServerModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_ssh_server_modify",
		Method:             "PATCH",
		PathPattern:        "/security/ssh/svms/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmSSHServerModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmSSHServerModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmSSHServerModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SvmSSHServerModifyCollection svm ssh server modify collection API
*/
func (a *Client) SvmSSHServerModifyCollection(params *SvmSSHServerModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SvmSSHServerModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSvmSSHServerModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "svm_ssh_server_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/ssh/svms",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SvmSSHServerModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SvmSSHServerModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SvmSSHServerModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TotpCollectionGet Retrieves the TOTP profiles configured for user accounts.

### Related ONTAP commands
* `security login totp show`
### Learn more
* [`DOC /security/login/totps`](#docs-security-security_login_totps)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) TotpCollectionGet(params *TotpCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TotpCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTotpCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "totp_collection_get",
		Method:             "GET",
		PathPattern:        "/security/login/totps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TotpCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TotpCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TotpCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TotpCreate Creates a TOTP profile for a user account.

### Required properties
* `owner.uuid` - Account owner UUID.
* `account.name` - Account user name.
### Related ONTAP commands
* `security login totp create`
### Learn more
* [`DOC /security/login/totps`](#docs-security-security_login_totps)
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) TotpCreate(params *TotpCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TotpCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTotpCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "totp_create",
		Method:             "POST",
		PathPattern:        "/security/login/totps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TotpCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TotpCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TotpCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TotpGet Retrieves the TOTP profile configured for a user account.

### Related ONTAP commands
* `security login totp show`
### Learn more
* [`DOC /security/login/totps/{owner.uuid}/{account.name}`](#docs-security-security_login_totps_{owner.uuid}_{account.name})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) TotpGet(params *TotpGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TotpGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTotpGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "totp_get",
		Method:             "GET",
		PathPattern:        "/security/login/totps/{owner.uuid}/{account.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TotpGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TotpGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TotpGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	TotpModify Updates a TOTP user account.

### Related ONTAP commands
* `security login totp modify`
### Learn more
* [`DOC /security/login/totps/{owner.uuid}/{account.name}`](#docs-security-security_login_totps_{owner.uuid}_{account.name})
* [`DOC /security/accounts`](#docs-security-security_accounts)
*/
func (a *Client) TotpModify(params *TotpModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TotpModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTotpModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "totp_modify",
		Method:             "PATCH",
		PathPattern:        "/security/login/totps/{owner.uuid}/{account.name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TotpModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TotpModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TotpModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
TotpModifyCollection totp modify collection API
*/
func (a *Client) TotpModifyCollection(params *TotpModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*TotpModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewTotpModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "totp_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/security/login/totps",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &TotpModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*TotpModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*TotpModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WebauthnCredentialsCollectionGet Retrieves all WebAuthn credentials entries.

### Related ONTAP commands
* `security webauthn credentials show`
*/
func (a *Client) WebauthnCredentialsCollectionGet(params *WebauthnCredentialsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnCredentialsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWebauthnCredentialsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "webauthn_credentials_collection_get",
		Method:             "GET",
		PathPattern:        "/security/webauthn/credentials",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WebauthnCredentialsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WebauthnCredentialsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WebauthnCredentialsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WebauthnCredentialsDelete Deletes a WebAuthn credentials entry.

### Required properties
  - `owner.uuid`
  - `username`
  - `index`
  - `relying_party.id`

### Related ONTAP commands
* `security webauthn credentials delete`
*/
func (a *Client) WebauthnCredentialsDelete(params *WebauthnCredentialsDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnCredentialsDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWebauthnCredentialsDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "webauthn_credentials_delete",
		Method:             "DELETE",
		PathPattern:        "/security/webauthn/credentials/{owner.uuid}/{username}/{index}/{relying_party.id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WebauthnCredentialsDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WebauthnCredentialsDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WebauthnCredentialsDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
WebauthnCredentialsDeleteCollection webauthn credentials delete collection API
*/
func (a *Client) WebauthnCredentialsDeleteCollection(params *WebauthnCredentialsDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnCredentialsDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWebauthnCredentialsDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "webauthn_credentials_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/security/webauthn/credentials",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WebauthnCredentialsDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WebauthnCredentialsDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WebauthnCredentialsDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WebauthnCredentialsGet Retrieves a WebAuthn credentials entry.

### Related ONTAP commands
* `security webauthn credentials show`
*/
func (a *Client) WebauthnCredentialsGet(params *WebauthnCredentialsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnCredentialsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWebauthnCredentialsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "webauthn_credentials_get",
		Method:             "GET",
		PathPattern:        "/security/webauthn/credentials/{owner.uuid}/{username}/{index}/{relying_party.id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WebauthnCredentialsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WebauthnCredentialsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WebauthnCredentialsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WebauthnGlobalCollectionGet Retrieve WebAuthn global settings for a cluster and all SVMs.

### Related ONTAP commands
* `security webauthn show`
*/
func (a *Client) WebauthnGlobalCollectionGet(params *WebauthnGlobalCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnGlobalCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWebauthnGlobalCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "webauthn_global_collection_get",
		Method:             "GET",
		PathPattern:        "/security/webauthn/global-settings",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WebauthnGlobalCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WebauthnGlobalCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WebauthnGlobalCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WebauthnGlobalGet Retrieves a WebAuthn global setting entry.

### Related ONTAP commands
* `security webauthn show`
*/
func (a *Client) WebauthnGlobalGet(params *WebauthnGlobalGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WebauthnGlobalGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWebauthnGlobalGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "webauthn_global_get",
		Method:             "GET",
		PathPattern:        "/security/webauthn/global-settings/{owner.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WebauthnGlobalGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WebauthnGlobalGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WebauthnGlobalGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	WhoamiGet Retrieves the username, role, and permissions information for the logged-in user.

### Related ONTAP commands
* `security login whoami`
*/
func (a *Client) WhoamiGet(params *WhoamiGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*WhoamiGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewWhoamiGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "whoami_get",
		Method:             "GET",
		PathPattern:        "/security/login/whoami",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &WhoamiGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*WhoamiGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*WhoamiGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
