// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityClusterNetworkCertificatesCollectionGetParams creates a new SecurityClusterNetworkCertificatesCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityClusterNetworkCertificatesCollectionGetParams() *SecurityClusterNetworkCertificatesCollectionGetParams {
	return &SecurityClusterNetworkCertificatesCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityClusterNetworkCertificatesCollectionGetParamsWithTimeout creates a new SecurityClusterNetworkCertificatesCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSecurityClusterNetworkCertificatesCollectionGetParamsWithTimeout(timeout time.Duration) *SecurityClusterNetworkCertificatesCollectionGetParams {
	return &SecurityClusterNetworkCertificatesCollectionGetParams{
		timeout: timeout,
	}
}

// NewSecurityClusterNetworkCertificatesCollectionGetParamsWithContext creates a new SecurityClusterNetworkCertificatesCollectionGetParams object
// with the ability to set a context for a request.
func NewSecurityClusterNetworkCertificatesCollectionGetParamsWithContext(ctx context.Context) *SecurityClusterNetworkCertificatesCollectionGetParams {
	return &SecurityClusterNetworkCertificatesCollectionGetParams{
		Context: ctx,
	}
}

// NewSecurityClusterNetworkCertificatesCollectionGetParamsWithHTTPClient creates a new SecurityClusterNetworkCertificatesCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityClusterNetworkCertificatesCollectionGetParamsWithHTTPClient(client *http.Client) *SecurityClusterNetworkCertificatesCollectionGetParams {
	return &SecurityClusterNetworkCertificatesCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SecurityClusterNetworkCertificatesCollectionGetParams contains all the parameters to send to the API endpoint

	for the security cluster network certificates collection get operation.

	Typically these are written to a http.Request.
*/
type SecurityClusterNetworkCertificatesCollectionGetParams struct {

	/* CertificateName.

	   Filter by certificate.name
	*/
	CertificateName *string

	/* CertificateUUID.

	   Filter by certificate.uuid
	*/
	CertificateUUID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security cluster network certificates collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithDefaults() *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security cluster network certificates collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SecurityClusterNetworkCertificatesCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithTimeout(timeout time.Duration) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithContext(ctx context.Context) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithHTTPClient(client *http.Client) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCertificateName adds the certificateName to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithCertificateName(certificateName *string) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetCertificateName(certificateName)
	return o
}

// SetCertificateName adds the certificateName to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetCertificateName(certificateName *string) {
	o.CertificateName = certificateName
}

// WithCertificateUUID adds the certificateUUID to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithCertificateUUID(certificateUUID *string) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetCertificateUUID(certificateUUID *string) {
	o.CertificateUUID = certificateUUID
}

// WithFields adds the fields to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithFields(fields []string) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithMaxRecords(maxRecords *int64) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNodeName adds the nodeName to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithNodeName(nodeName *string) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithNodeUUID(nodeUUID *string) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithOrderBy(orderBy []string) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithReturnRecords(returnRecords *bool) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SecurityClusterNetworkCertificatesCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security cluster network certificates collection get params
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CertificateName != nil {

		// query param certificate.name
		var qrCertificateName string

		if o.CertificateName != nil {
			qrCertificateName = *o.CertificateName
		}
		qCertificateName := qrCertificateName
		if qCertificateName != "" {

			if err := r.SetQueryParam("certificate.name", qCertificateName); err != nil {
				return err
			}
		}
	}

	if o.CertificateUUID != nil {

		// query param certificate.uuid
		var qrCertificateUUID string

		if o.CertificateUUID != nil {
			qrCertificateUUID = *o.CertificateUUID
		}
		qCertificateUUID := qrCertificateUUID
		if qCertificateUUID != "" {

			if err := r.SetQueryParam("certificate.uuid", qCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityClusterNetworkCertificatesCollectionGet binds the parameter fields
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSecurityClusterNetworkCertificatesCollectionGet binds the parameter order_by
func (o *SecurityClusterNetworkCertificatesCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
