// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSecurityClusterNetworkCertificatesCreateParams creates a new SecurityClusterNetworkCertificatesCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityClusterNetworkCertificatesCreateParams() *SecurityClusterNetworkCertificatesCreateParams {
	return &SecurityClusterNetworkCertificatesCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityClusterNetworkCertificatesCreateParamsWithTimeout creates a new SecurityClusterNetworkCertificatesCreateParams object
// with the ability to set a timeout on a request.
func NewSecurityClusterNetworkCertificatesCreateParamsWithTimeout(timeout time.Duration) *SecurityClusterNetworkCertificatesCreateParams {
	return &SecurityClusterNetworkCertificatesCreateParams{
		timeout: timeout,
	}
}

// NewSecurityClusterNetworkCertificatesCreateParamsWithContext creates a new SecurityClusterNetworkCertificatesCreateParams object
// with the ability to set a context for a request.
func NewSecurityClusterNetworkCertificatesCreateParamsWithContext(ctx context.Context) *SecurityClusterNetworkCertificatesCreateParams {
	return &SecurityClusterNetworkCertificatesCreateParams{
		Context: ctx,
	}
}

// NewSecurityClusterNetworkCertificatesCreateParamsWithHTTPClient creates a new SecurityClusterNetworkCertificatesCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityClusterNetworkCertificatesCreateParamsWithHTTPClient(client *http.Client) *SecurityClusterNetworkCertificatesCreateParams {
	return &SecurityClusterNetworkCertificatesCreateParams{
		HTTPClient: client,
	}
}

/*
SecurityClusterNetworkCertificatesCreateParams contains all the parameters to send to the API endpoint

	for the security cluster network certificates create operation.

	Typically these are written to a http.Request.
*/
type SecurityClusterNetworkCertificatesCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.SecurityClusterNetworkCertificates

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security cluster network certificates create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityClusterNetworkCertificatesCreateParams) WithDefaults() *SecurityClusterNetworkCertificatesCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security cluster network certificates create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityClusterNetworkCertificatesCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := SecurityClusterNetworkCertificatesCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security cluster network certificates create params
func (o *SecurityClusterNetworkCertificatesCreateParams) WithTimeout(timeout time.Duration) *SecurityClusterNetworkCertificatesCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security cluster network certificates create params
func (o *SecurityClusterNetworkCertificatesCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security cluster network certificates create params
func (o *SecurityClusterNetworkCertificatesCreateParams) WithContext(ctx context.Context) *SecurityClusterNetworkCertificatesCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security cluster network certificates create params
func (o *SecurityClusterNetworkCertificatesCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security cluster network certificates create params
func (o *SecurityClusterNetworkCertificatesCreateParams) WithHTTPClient(client *http.Client) *SecurityClusterNetworkCertificatesCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security cluster network certificates create params
func (o *SecurityClusterNetworkCertificatesCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the security cluster network certificates create params
func (o *SecurityClusterNetworkCertificatesCreateParams) WithInfo(info *models.SecurityClusterNetworkCertificates) *SecurityClusterNetworkCertificatesCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security cluster network certificates create params
func (o *SecurityClusterNetworkCertificatesCreateParams) SetInfo(info *models.SecurityClusterNetworkCertificates) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the security cluster network certificates create params
func (o *SecurityClusterNetworkCertificatesCreateParams) WithReturnRecords(returnRecords *bool) *SecurityClusterNetworkCertificatesCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security cluster network certificates create params
func (o *SecurityClusterNetworkCertificatesCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityClusterNetworkCertificatesCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
