// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityClusterNetworkCertificatesCreateReader is a Reader for the SecurityClusterNetworkCertificatesCreate structure.
type SecurityClusterNetworkCertificatesCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityClusterNetworkCertificatesCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSecurityClusterNetworkCertificatesCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityClusterNetworkCertificatesCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityClusterNetworkCertificatesCreateCreated creates a SecurityClusterNetworkCertificatesCreateCreated with default headers values
func NewSecurityClusterNetworkCertificatesCreateCreated() *SecurityClusterNetworkCertificatesCreateCreated {
	return &SecurityClusterNetworkCertificatesCreateCreated{}
}

/*
SecurityClusterNetworkCertificatesCreateCreated describes a response with status code 201, with default header values.

Created
*/
type SecurityClusterNetworkCertificatesCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SecurityClusterNetworkCertificates
}

// IsSuccess returns true when this security cluster network certificates create created response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security cluster network certificates create created response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security cluster network certificates create created response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this security cluster network certificates create created response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this security cluster network certificates create created response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the security cluster network certificates create created response
func (o *SecurityClusterNetworkCertificatesCreateCreated) Code() int {
	return 201
}

func (o *SecurityClusterNetworkCertificatesCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/cluster-network/certificates][%d] securityClusterNetworkCertificatesCreateCreated %s", 201, payload)
}

func (o *SecurityClusterNetworkCertificatesCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/cluster-network/certificates][%d] securityClusterNetworkCertificatesCreateCreated %s", 201, payload)
}

func (o *SecurityClusterNetworkCertificatesCreateCreated) GetPayload() *models.SecurityClusterNetworkCertificates {
	return o.Payload
}

func (o *SecurityClusterNetworkCertificatesCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SecurityClusterNetworkCertificates)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityClusterNetworkCertificatesCreateDefault creates a SecurityClusterNetworkCertificatesCreateDefault with default headers values
func NewSecurityClusterNetworkCertificatesCreateDefault(code int) *SecurityClusterNetworkCertificatesCreateDefault {
	return &SecurityClusterNetworkCertificatesCreateDefault{
		_statusCode: code,
	}
}

/*
	SecurityClusterNetworkCertificatesCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 70320128 | Modifying the cluster network security configuration requires an effective cluster version of ONTAP 9.18.1 or later. |
| 70320132 | The cluster has an out of quorum node, wait until all nodes are in quorum before modifying the cluster network security configuration. |
| 70320137 | The specified certificate was not found on the admin SVM |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityClusterNetworkCertificatesCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security cluster network certificates create default response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security cluster network certificates create default response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security cluster network certificates create default response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security cluster network certificates create default response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security cluster network certificates create default response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security cluster network certificates create default response
func (o *SecurityClusterNetworkCertificatesCreateDefault) Code() int {
	return o._statusCode
}

func (o *SecurityClusterNetworkCertificatesCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/cluster-network/certificates][%d] security_cluster_network_certificates_create default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/cluster-network/certificates][%d] security_cluster_network_certificates_create default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityClusterNetworkCertificatesCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
