// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityClusterNetworkCertificatesDeleteCollectionParams creates a new SecurityClusterNetworkCertificatesDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityClusterNetworkCertificatesDeleteCollectionParams() *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	return &SecurityClusterNetworkCertificatesDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityClusterNetworkCertificatesDeleteCollectionParamsWithTimeout creates a new SecurityClusterNetworkCertificatesDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSecurityClusterNetworkCertificatesDeleteCollectionParamsWithTimeout(timeout time.Duration) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	return &SecurityClusterNetworkCertificatesDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSecurityClusterNetworkCertificatesDeleteCollectionParamsWithContext creates a new SecurityClusterNetworkCertificatesDeleteCollectionParams object
// with the ability to set a context for a request.
func NewSecurityClusterNetworkCertificatesDeleteCollectionParamsWithContext(ctx context.Context) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	return &SecurityClusterNetworkCertificatesDeleteCollectionParams{
		Context: ctx,
	}
}

// NewSecurityClusterNetworkCertificatesDeleteCollectionParamsWithHTTPClient creates a new SecurityClusterNetworkCertificatesDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityClusterNetworkCertificatesDeleteCollectionParamsWithHTTPClient(client *http.Client) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	return &SecurityClusterNetworkCertificatesDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SecurityClusterNetworkCertificatesDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the security cluster network certificates delete collection operation.

	Typically these are written to a http.Request.
*/
type SecurityClusterNetworkCertificatesDeleteCollectionParams struct {

	/* CertificateName.

	   Filter by certificate.name
	*/
	CertificateName *string

	/* CertificateUUID.

	   Filter by certificate.uuid
	*/
	CertificateUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info SecurityClusterNetworkCertificatesDeleteCollectionBody

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security cluster network certificates delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithDefaults() *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security cluster network certificates delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SecurityClusterNetworkCertificatesDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithTimeout(timeout time.Duration) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithContext(ctx context.Context) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithHTTPClient(client *http.Client) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCertificateName adds the certificateName to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithCertificateName(certificateName *string) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetCertificateName(certificateName)
	return o
}

// SetCertificateName adds the certificateName to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetCertificateName(certificateName *string) {
	o.CertificateName = certificateName
}

// WithCertificateUUID adds the certificateUUID to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithCertificateUUID(certificateUUID *string) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetCertificateUUID(certificateUUID *string) {
	o.CertificateUUID = certificateUUID
}

// WithContinueOnFailure adds the continueOnFailure to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithInfo(info SecurityClusterNetworkCertificatesDeleteCollectionBody) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetInfo(info SecurityClusterNetworkCertificatesDeleteCollectionBody) {
	o.Info = info
}

// WithNodeName adds the nodeName to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithNodeName(nodeName *string) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithNodeUUID(nodeUUID *string) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithReturnRecords adds the returnRecords to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SecurityClusterNetworkCertificatesDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the security cluster network certificates delete collection params
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityClusterNetworkCertificatesDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CertificateName != nil {

		// query param certificate.name
		var qrCertificateName string

		if o.CertificateName != nil {
			qrCertificateName = *o.CertificateName
		}
		qCertificateName := qrCertificateName
		if qCertificateName != "" {

			if err := r.SetQueryParam("certificate.name", qCertificateName); err != nil {
				return err
			}
		}
	}

	if o.CertificateUUID != nil {

		// query param certificate.uuid
		var qrCertificateUUID string

		if o.CertificateUUID != nil {
			qrCertificateUUID = *o.CertificateUUID
		}
		qCertificateUUID := qrCertificateUUID
		if qCertificateUUID != "" {

			if err := r.SetQueryParam("certificate.uuid", qCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
