// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityClusterNetworkCertificatesDeleteCollectionReader is a Reader for the SecurityClusterNetworkCertificatesDeleteCollection structure.
type SecurityClusterNetworkCertificatesDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityClusterNetworkCertificatesDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityClusterNetworkCertificatesDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityClusterNetworkCertificatesDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityClusterNetworkCertificatesDeleteCollectionOK creates a SecurityClusterNetworkCertificatesDeleteCollectionOK with default headers values
func NewSecurityClusterNetworkCertificatesDeleteCollectionOK() *SecurityClusterNetworkCertificatesDeleteCollectionOK {
	return &SecurityClusterNetworkCertificatesDeleteCollectionOK{}
}

/*
SecurityClusterNetworkCertificatesDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityClusterNetworkCertificatesDeleteCollectionOK struct {
	Payload *models.SecurityClusterNetworkCertificates
}

// IsSuccess returns true when this security cluster network certificates delete collection o k response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security cluster network certificates delete collection o k response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security cluster network certificates delete collection o k response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security cluster network certificates delete collection o k response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security cluster network certificates delete collection o k response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security cluster network certificates delete collection o k response
func (o *SecurityClusterNetworkCertificatesDeleteCollectionOK) Code() int {
	return 200
}

func (o *SecurityClusterNetworkCertificatesDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/cluster-network/certificates][%d] securityClusterNetworkCertificatesDeleteCollectionOK %s", 200, payload)
}

func (o *SecurityClusterNetworkCertificatesDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/cluster-network/certificates][%d] securityClusterNetworkCertificatesDeleteCollectionOK %s", 200, payload)
}

func (o *SecurityClusterNetworkCertificatesDeleteCollectionOK) GetPayload() *models.SecurityClusterNetworkCertificates {
	return o.Payload
}

func (o *SecurityClusterNetworkCertificatesDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityClusterNetworkCertificates)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityClusterNetworkCertificatesDeleteCollectionDefault creates a SecurityClusterNetworkCertificatesDeleteCollectionDefault with default headers values
func NewSecurityClusterNetworkCertificatesDeleteCollectionDefault(code int) *SecurityClusterNetworkCertificatesDeleteCollectionDefault {
	return &SecurityClusterNetworkCertificatesDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SecurityClusterNetworkCertificatesDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 70320128 | Modifying the cluster network security configuration requires an effective cluster version of ONTAP 9.18.1 or later. |
| 70320132 | The cluster has an out of quorum node, wait until all nodes are in quorum before modifying the cluster network security configuration. |
| 70320137 | The specified certificate was not found on the admin SVM |
| 70320150 | The certificate table is currently in use. Removing a certificate entry is not allowed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityClusterNetworkCertificatesDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security cluster network certificates delete collection default response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security cluster network certificates delete collection default response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security cluster network certificates delete collection default response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security cluster network certificates delete collection default response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security cluster network certificates delete collection default response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security cluster network certificates delete collection default response
func (o *SecurityClusterNetworkCertificatesDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityClusterNetworkCertificatesDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/cluster-network/certificates][%d] security_cluster_network_certificates_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/cluster-network/certificates][%d] security_cluster_network_certificates_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityClusterNetworkCertificatesDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityClusterNetworkCertificatesDeleteCollectionBody security cluster network certificates delete collection body
swagger:model SecurityClusterNetworkCertificatesDeleteCollectionBody
*/
type SecurityClusterNetworkCertificatesDeleteCollectionBody struct {

	// security cluster network certificates response inline records
	SecurityClusterNetworkCertificatesResponseInlineRecords []*models.SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this security cluster network certificates delete collection body
func (o *SecurityClusterNetworkCertificatesDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSecurityClusterNetworkCertificatesResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityClusterNetworkCertificatesDeleteCollectionBody) validateSecurityClusterNetworkCertificatesResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityClusterNetworkCertificatesResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityClusterNetworkCertificatesResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityClusterNetworkCertificatesResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityClusterNetworkCertificatesResponseInlineRecords[i] != nil {
			if err := o.SecurityClusterNetworkCertificatesResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security cluster network certificates delete collection body based on the context it is used
func (o *SecurityClusterNetworkCertificatesDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSecurityClusterNetworkCertificatesResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityClusterNetworkCertificatesDeleteCollectionBody) contextValidateSecurityClusterNetworkCertificatesResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityClusterNetworkCertificatesResponseInlineRecords); i++ {

		if o.SecurityClusterNetworkCertificatesResponseInlineRecords[i] != nil {
			if err := o.SecurityClusterNetworkCertificatesResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityClusterNetworkCertificatesDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityClusterNetworkCertificatesDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityClusterNetworkCertificatesDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem Manages the cluster network security certificate configuration.
swagger:model security_cluster_network_certificates_response_inline_records_inline_array_item
*/
type SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem struct {

	// links
	Links *models.SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// certificate
	Certificate *models.SecurityCertificateReference `json:"certificate,omitempty"`

	// node
	Node *models.NodeReference `json:"node,omitempty"`
}

// Validate validates this security cluster network certificates response inline records inline array item
func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security cluster network certificates response inline records inline array item based on the context it is used
func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks security cluster network certificates response inline records inline array item inline links
swagger:model security_cluster_network_certificates_response_inline_records_inline_array_item_inline__links
*/
type SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security cluster network certificates response inline records inline array item inline links
func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security cluster network certificates response inline records inline array item inline links based on the context it is used
func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
