// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityClusterNetworkCertificatesDeleteReader is a Reader for the SecurityClusterNetworkCertificatesDelete structure.
type SecurityClusterNetworkCertificatesDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityClusterNetworkCertificatesDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityClusterNetworkCertificatesDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityClusterNetworkCertificatesDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityClusterNetworkCertificatesDeleteOK creates a SecurityClusterNetworkCertificatesDeleteOK with default headers values
func NewSecurityClusterNetworkCertificatesDeleteOK() *SecurityClusterNetworkCertificatesDeleteOK {
	return &SecurityClusterNetworkCertificatesDeleteOK{}
}

/*
SecurityClusterNetworkCertificatesDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SecurityClusterNetworkCertificatesDeleteOK struct {
	Payload *models.SecurityClusterNetworkCertificates
}

// IsSuccess returns true when this security cluster network certificates delete o k response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security cluster network certificates delete o k response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security cluster network certificates delete o k response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security cluster network certificates delete o k response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security cluster network certificates delete o k response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security cluster network certificates delete o k response
func (o *SecurityClusterNetworkCertificatesDeleteOK) Code() int {
	return 200
}

func (o *SecurityClusterNetworkCertificatesDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/cluster-network/certificates/{node.name}][%d] securityClusterNetworkCertificatesDeleteOK %s", 200, payload)
}

func (o *SecurityClusterNetworkCertificatesDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/cluster-network/certificates/{node.name}][%d] securityClusterNetworkCertificatesDeleteOK %s", 200, payload)
}

func (o *SecurityClusterNetworkCertificatesDeleteOK) GetPayload() *models.SecurityClusterNetworkCertificates {
	return o.Payload
}

func (o *SecurityClusterNetworkCertificatesDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityClusterNetworkCertificates)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityClusterNetworkCertificatesDeleteDefault creates a SecurityClusterNetworkCertificatesDeleteDefault with default headers values
func NewSecurityClusterNetworkCertificatesDeleteDefault(code int) *SecurityClusterNetworkCertificatesDeleteDefault {
	return &SecurityClusterNetworkCertificatesDeleteDefault{
		_statusCode: code,
	}
}

/*
	SecurityClusterNetworkCertificatesDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 70320128 | Modifying the cluster network security configuration requires an effective cluster version of ONTAP 9.18.1 or later. |
| 70320132 | The cluster has an out of quorum node, wait until all nodes are in quorum before modifying the cluster network security configuration. |
| 70320137 | The specified certificate was not found on the admin SVM |
| 70320150 | The certificate table is currently in use. Removing a certificate entry is not allowed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityClusterNetworkCertificatesDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security cluster network certificates delete default response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security cluster network certificates delete default response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security cluster network certificates delete default response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security cluster network certificates delete default response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security cluster network certificates delete default response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security cluster network certificates delete default response
func (o *SecurityClusterNetworkCertificatesDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SecurityClusterNetworkCertificatesDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/cluster-network/certificates/{node.name}][%d] security_cluster_network_certificates_delete default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/cluster-network/certificates/{node.name}][%d] security_cluster_network_certificates_delete default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityClusterNetworkCertificatesDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
