// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityClusterNetworkCertificatesGetReader is a Reader for the SecurityClusterNetworkCertificatesGet structure.
type SecurityClusterNetworkCertificatesGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityClusterNetworkCertificatesGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityClusterNetworkCertificatesGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityClusterNetworkCertificatesGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityClusterNetworkCertificatesGetOK creates a SecurityClusterNetworkCertificatesGetOK with default headers values
func NewSecurityClusterNetworkCertificatesGetOK() *SecurityClusterNetworkCertificatesGetOK {
	return &SecurityClusterNetworkCertificatesGetOK{}
}

/*
SecurityClusterNetworkCertificatesGetOK describes a response with status code 200, with default header values.

OK
*/
type SecurityClusterNetworkCertificatesGetOK struct {
	Payload *models.SecurityClusterNetworkCertificates
}

// IsSuccess returns true when this security cluster network certificates get o k response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security cluster network certificates get o k response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security cluster network certificates get o k response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security cluster network certificates get o k response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security cluster network certificates get o k response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security cluster network certificates get o k response
func (o *SecurityClusterNetworkCertificatesGetOK) Code() int {
	return 200
}

func (o *SecurityClusterNetworkCertificatesGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/cluster-network/certificates/{node.name}][%d] securityClusterNetworkCertificatesGetOK %s", 200, payload)
}

func (o *SecurityClusterNetworkCertificatesGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/cluster-network/certificates/{node.name}][%d] securityClusterNetworkCertificatesGetOK %s", 200, payload)
}

func (o *SecurityClusterNetworkCertificatesGetOK) GetPayload() *models.SecurityClusterNetworkCertificates {
	return o.Payload
}

func (o *SecurityClusterNetworkCertificatesGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityClusterNetworkCertificates)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityClusterNetworkCertificatesGetDefault creates a SecurityClusterNetworkCertificatesGetDefault with default headers values
func NewSecurityClusterNetworkCertificatesGetDefault(code int) *SecurityClusterNetworkCertificatesGetDefault {
	return &SecurityClusterNetworkCertificatesGetDefault{
		_statusCode: code,
	}
}

/*
SecurityClusterNetworkCertificatesGetDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityClusterNetworkCertificatesGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security cluster network certificates get default response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security cluster network certificates get default response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security cluster network certificates get default response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security cluster network certificates get default response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security cluster network certificates get default response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security cluster network certificates get default response
func (o *SecurityClusterNetworkCertificatesGetDefault) Code() int {
	return o._statusCode
}

func (o *SecurityClusterNetworkCertificatesGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/cluster-network/certificates/{node.name}][%d] security_cluster_network_certificates_get default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/cluster-network/certificates/{node.name}][%d] security_cluster_network_certificates_get default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityClusterNetworkCertificatesGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
