// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityClusterNetworkCertificatesModifyCollectionParams creates a new SecurityClusterNetworkCertificatesModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityClusterNetworkCertificatesModifyCollectionParams() *SecurityClusterNetworkCertificatesModifyCollectionParams {
	return &SecurityClusterNetworkCertificatesModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityClusterNetworkCertificatesModifyCollectionParamsWithTimeout creates a new SecurityClusterNetworkCertificatesModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewSecurityClusterNetworkCertificatesModifyCollectionParamsWithTimeout(timeout time.Duration) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	return &SecurityClusterNetworkCertificatesModifyCollectionParams{
		timeout: timeout,
	}
}

// NewSecurityClusterNetworkCertificatesModifyCollectionParamsWithContext creates a new SecurityClusterNetworkCertificatesModifyCollectionParams object
// with the ability to set a context for a request.
func NewSecurityClusterNetworkCertificatesModifyCollectionParamsWithContext(ctx context.Context) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	return &SecurityClusterNetworkCertificatesModifyCollectionParams{
		Context: ctx,
	}
}

// NewSecurityClusterNetworkCertificatesModifyCollectionParamsWithHTTPClient creates a new SecurityClusterNetworkCertificatesModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityClusterNetworkCertificatesModifyCollectionParamsWithHTTPClient(client *http.Client) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	return &SecurityClusterNetworkCertificatesModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
SecurityClusterNetworkCertificatesModifyCollectionParams contains all the parameters to send to the API endpoint

	for the security cluster network certificates modify collection operation.

	Typically these are written to a http.Request.
*/
type SecurityClusterNetworkCertificatesModifyCollectionParams struct {

	/* CertificateName.

	   Filter by certificate.name
	*/
	CertificateName *string

	/* CertificateUUID.

	   Filter by certificate.uuid
	*/
	CertificateUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info SecurityClusterNetworkCertificatesModifyCollectionBody

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security cluster network certificates modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithDefaults() *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security cluster network certificates modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SecurityClusterNetworkCertificatesModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithTimeout(timeout time.Duration) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithContext(ctx context.Context) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithHTTPClient(client *http.Client) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCertificateName adds the certificateName to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithCertificateName(certificateName *string) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetCertificateName(certificateName)
	return o
}

// SetCertificateName adds the certificateName to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetCertificateName(certificateName *string) {
	o.CertificateName = certificateName
}

// WithCertificateUUID adds the certificateUUID to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithCertificateUUID(certificateUUID *string) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetCertificateUUID(certificateUUID *string) {
	o.CertificateUUID = certificateUUID
}

// WithContinueOnFailure adds the continueOnFailure to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithInfo(info SecurityClusterNetworkCertificatesModifyCollectionBody) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetInfo(info SecurityClusterNetworkCertificatesModifyCollectionBody) {
	o.Info = info
}

// WithNodeName adds the nodeName to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithNodeName(nodeName *string) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithNodeUUID(nodeUUID *string) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithReturnRecords adds the returnRecords to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithReturnRecords(returnRecords *bool) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WithSerialRecords(serialRecords *bool) *SecurityClusterNetworkCertificatesModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the security cluster network certificates modify collection params
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityClusterNetworkCertificatesModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CertificateName != nil {

		// query param certificate.name
		var qrCertificateName string

		if o.CertificateName != nil {
			qrCertificateName = *o.CertificateName
		}
		qCertificateName := qrCertificateName
		if qCertificateName != "" {

			if err := r.SetQueryParam("certificate.name", qCertificateName); err != nil {
				return err
			}
		}
	}

	if o.CertificateUUID != nil {

		// query param certificate.uuid
		var qrCertificateUUID string

		if o.CertificateUUID != nil {
			qrCertificateUUID = *o.CertificateUUID
		}
		qCertificateUUID := qrCertificateUUID
		if qCertificateUUID != "" {

			if err := r.SetQueryParam("certificate.uuid", qCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
