// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityClusterNetworkCertificatesModifyCollectionReader is a Reader for the SecurityClusterNetworkCertificatesModifyCollection structure.
type SecurityClusterNetworkCertificatesModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityClusterNetworkCertificatesModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityClusterNetworkCertificatesModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityClusterNetworkCertificatesModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityClusterNetworkCertificatesModifyCollectionOK creates a SecurityClusterNetworkCertificatesModifyCollectionOK with default headers values
func NewSecurityClusterNetworkCertificatesModifyCollectionOK() *SecurityClusterNetworkCertificatesModifyCollectionOK {
	return &SecurityClusterNetworkCertificatesModifyCollectionOK{}
}

/*
SecurityClusterNetworkCertificatesModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityClusterNetworkCertificatesModifyCollectionOK struct {
}

// IsSuccess returns true when this security cluster network certificates modify collection o k response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security cluster network certificates modify collection o k response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security cluster network certificates modify collection o k response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security cluster network certificates modify collection o k response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security cluster network certificates modify collection o k response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security cluster network certificates modify collection o k response
func (o *SecurityClusterNetworkCertificatesModifyCollectionOK) Code() int {
	return 200
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/cluster-network/certificates][%d] securityClusterNetworkCertificatesModifyCollectionOK", 200)
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/cluster-network/certificates][%d] securityClusterNetworkCertificatesModifyCollectionOK", 200)
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityClusterNetworkCertificatesModifyCollectionDefault creates a SecurityClusterNetworkCertificatesModifyCollectionDefault with default headers values
func NewSecurityClusterNetworkCertificatesModifyCollectionDefault(code int) *SecurityClusterNetworkCertificatesModifyCollectionDefault {
	return &SecurityClusterNetworkCertificatesModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SecurityClusterNetworkCertificatesModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 70320128 | Modifying the cluster network security configuration requires an effective cluster version of ONTAP 9.18.1 or later. |
| 70320132 | The cluster has an out of quorum node, wait until all nodes are in quorum before modifying the cluster network security configuration. |
| 70320137 | The specified certificate was not found on the admin SVM |
| 70320138 | The certificate table is currently in use. Removing a certificate entry is not allowed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityClusterNetworkCertificatesModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security cluster network certificates modify collection default response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security cluster network certificates modify collection default response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security cluster network certificates modify collection default response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security cluster network certificates modify collection default response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security cluster network certificates modify collection default response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security cluster network certificates modify collection default response
func (o *SecurityClusterNetworkCertificatesModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/cluster-network/certificates][%d] security_cluster_network_certificates_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/cluster-network/certificates][%d] security_cluster_network_certificates_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityClusterNetworkCertificatesModifyCollectionBody security cluster network certificates modify collection body
swagger:model SecurityClusterNetworkCertificatesModifyCollectionBody
*/
type SecurityClusterNetworkCertificatesModifyCollectionBody struct {

	// links
	Links *models.SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// certificate
	Certificate *models.SecurityCertificateReference `json:"certificate,omitempty"`

	// node
	Node *models.NodeReference `json:"node,omitempty"`

	// security cluster network certificates response inline records
	SecurityClusterNetworkCertificatesResponseInlineRecords []*models.SecurityClusterNetworkCertificatesResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`
}

// Validate validates this security cluster network certificates modify collection body
func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityClusterNetworkCertificatesResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) validateSecurityClusterNetworkCertificatesResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityClusterNetworkCertificatesResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityClusterNetworkCertificatesResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityClusterNetworkCertificatesResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityClusterNetworkCertificatesResponseInlineRecords[i] != nil {
			if err := o.SecurityClusterNetworkCertificatesResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security cluster network certificates modify collection body based on the context it is used
func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSecurityClusterNetworkCertificatesResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) contextValidateSecurityClusterNetworkCertificatesResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityClusterNetworkCertificatesResponseInlineRecords); i++ {

		if o.SecurityClusterNetworkCertificatesResponseInlineRecords[i] != nil {
			if err := o.SecurityClusterNetworkCertificatesResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityClusterNetworkCertificatesModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityClusterNetworkCertificatesModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
