// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityClusterNetworkCertificatesModifyReader is a Reader for the SecurityClusterNetworkCertificatesModify structure.
type SecurityClusterNetworkCertificatesModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityClusterNetworkCertificatesModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityClusterNetworkCertificatesModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityClusterNetworkCertificatesModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityClusterNetworkCertificatesModifyOK creates a SecurityClusterNetworkCertificatesModifyOK with default headers values
func NewSecurityClusterNetworkCertificatesModifyOK() *SecurityClusterNetworkCertificatesModifyOK {
	return &SecurityClusterNetworkCertificatesModifyOK{}
}

/*
SecurityClusterNetworkCertificatesModifyOK describes a response with status code 200, with default header values.

OK
*/
type SecurityClusterNetworkCertificatesModifyOK struct {
}

// IsSuccess returns true when this security cluster network certificates modify o k response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security cluster network certificates modify o k response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security cluster network certificates modify o k response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security cluster network certificates modify o k response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security cluster network certificates modify o k response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security cluster network certificates modify o k response
func (o *SecurityClusterNetworkCertificatesModifyOK) Code() int {
	return 200
}

func (o *SecurityClusterNetworkCertificatesModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/cluster-network/certificates/{node.name}][%d] securityClusterNetworkCertificatesModifyOK", 200)
}

func (o *SecurityClusterNetworkCertificatesModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/cluster-network/certificates/{node.name}][%d] securityClusterNetworkCertificatesModifyOK", 200)
}

func (o *SecurityClusterNetworkCertificatesModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityClusterNetworkCertificatesModifyDefault creates a SecurityClusterNetworkCertificatesModifyDefault with default headers values
func NewSecurityClusterNetworkCertificatesModifyDefault(code int) *SecurityClusterNetworkCertificatesModifyDefault {
	return &SecurityClusterNetworkCertificatesModifyDefault{
		_statusCode: code,
	}
}

/*
	SecurityClusterNetworkCertificatesModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 70320128 | Modifying the cluster network security configuration requires an effective cluster version of ONTAP 9.18.1 or later. |
| 70320132 | The cluster has an out of quorum node, wait until all nodes are in quorum before modifying the cluster network security configuration. |
| 70320137 | The specified certificate was not found on the admin SVM |
| 70320138 | The certificate table is currently in use. Removing a certificate entry is not allowed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityClusterNetworkCertificatesModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security cluster network certificates modify default response has a 2xx status code
func (o *SecurityClusterNetworkCertificatesModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security cluster network certificates modify default response has a 3xx status code
func (o *SecurityClusterNetworkCertificatesModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security cluster network certificates modify default response has a 4xx status code
func (o *SecurityClusterNetworkCertificatesModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security cluster network certificates modify default response has a 5xx status code
func (o *SecurityClusterNetworkCertificatesModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security cluster network certificates modify default response a status code equal to that given
func (o *SecurityClusterNetworkCertificatesModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security cluster network certificates modify default response
func (o *SecurityClusterNetworkCertificatesModifyDefault) Code() int {
	return o._statusCode
}

func (o *SecurityClusterNetworkCertificatesModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/cluster-network/certificates/{node.name}][%d] security_cluster_network_certificates_modify default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/cluster-network/certificates/{node.name}][%d] security_cluster_network_certificates_modify default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkCertificatesModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityClusterNetworkCertificatesModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
