// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityClusterNetworkModifyReader is a Reader for the SecurityClusterNetworkModify structure.
type SecurityClusterNetworkModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityClusterNetworkModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityClusterNetworkModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityClusterNetworkModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityClusterNetworkModifyOK creates a SecurityClusterNetworkModifyOK with default headers values
func NewSecurityClusterNetworkModifyOK() *SecurityClusterNetworkModifyOK {
	return &SecurityClusterNetworkModifyOK{}
}

/*
SecurityClusterNetworkModifyOK describes a response with status code 200, with default header values.

OK
*/
type SecurityClusterNetworkModifyOK struct {
}

// IsSuccess returns true when this security cluster network modify o k response has a 2xx status code
func (o *SecurityClusterNetworkModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security cluster network modify o k response has a 3xx status code
func (o *SecurityClusterNetworkModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security cluster network modify o k response has a 4xx status code
func (o *SecurityClusterNetworkModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security cluster network modify o k response has a 5xx status code
func (o *SecurityClusterNetworkModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security cluster network modify o k response a status code equal to that given
func (o *SecurityClusterNetworkModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security cluster network modify o k response
func (o *SecurityClusterNetworkModifyOK) Code() int {
	return 200
}

func (o *SecurityClusterNetworkModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /security/cluster-network][%d] securityClusterNetworkModifyOK", 200)
}

func (o *SecurityClusterNetworkModifyOK) String() string {
	return fmt.Sprintf("[PATCH /security/cluster-network][%d] securityClusterNetworkModifyOK", 200)
}

func (o *SecurityClusterNetworkModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityClusterNetworkModifyDefault creates a SecurityClusterNetworkModifyDefault with default headers values
func NewSecurityClusterNetworkModifyDefault(code int) *SecurityClusterNetworkModifyDefault {
	return &SecurityClusterNetworkModifyDefault{
		_statusCode: code,
	}
}

/*
	SecurityClusterNetworkModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 70320128 | Modifying the cluster network security configuration requires an effective cluster version of ONTAP 9.18.1 or later. |
| 70320131 | Cluster network security does not support MetroCluster configurations. |
| 70320132 | The cluster has an out of quorum node, wait until all nodes are in quorum before modifying the cluster network security configuration. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityClusterNetworkModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security cluster network modify default response has a 2xx status code
func (o *SecurityClusterNetworkModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security cluster network modify default response has a 3xx status code
func (o *SecurityClusterNetworkModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security cluster network modify default response has a 4xx status code
func (o *SecurityClusterNetworkModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security cluster network modify default response has a 5xx status code
func (o *SecurityClusterNetworkModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security cluster network modify default response a status code equal to that given
func (o *SecurityClusterNetworkModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security cluster network modify default response
func (o *SecurityClusterNetworkModifyDefault) Code() int {
	return o._statusCode
}

func (o *SecurityClusterNetworkModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/cluster-network][%d] security_cluster_network_modify default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/cluster-network][%d] security_cluster_network_modify default %s", o._statusCode, payload)
}

func (o *SecurityClusterNetworkModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityClusterNetworkModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
