// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSecurityExternalRoleMappingCreateParams creates a new SecurityExternalRoleMappingCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityExternalRoleMappingCreateParams() *SecurityExternalRoleMappingCreateParams {
	return &SecurityExternalRoleMappingCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityExternalRoleMappingCreateParamsWithTimeout creates a new SecurityExternalRoleMappingCreateParams object
// with the ability to set a timeout on a request.
func NewSecurityExternalRoleMappingCreateParamsWithTimeout(timeout time.Duration) *SecurityExternalRoleMappingCreateParams {
	return &SecurityExternalRoleMappingCreateParams{
		timeout: timeout,
	}
}

// NewSecurityExternalRoleMappingCreateParamsWithContext creates a new SecurityExternalRoleMappingCreateParams object
// with the ability to set a context for a request.
func NewSecurityExternalRoleMappingCreateParamsWithContext(ctx context.Context) *SecurityExternalRoleMappingCreateParams {
	return &SecurityExternalRoleMappingCreateParams{
		Context: ctx,
	}
}

// NewSecurityExternalRoleMappingCreateParamsWithHTTPClient creates a new SecurityExternalRoleMappingCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityExternalRoleMappingCreateParamsWithHTTPClient(client *http.Client) *SecurityExternalRoleMappingCreateParams {
	return &SecurityExternalRoleMappingCreateParams{
		HTTPClient: client,
	}
}

/*
SecurityExternalRoleMappingCreateParams contains all the parameters to send to the API endpoint

	for the security external role mapping create operation.

	Typically these are written to a http.Request.
*/
type SecurityExternalRoleMappingCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.SecurityExternalRoleMapping

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security external role mapping create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityExternalRoleMappingCreateParams) WithDefaults() *SecurityExternalRoleMappingCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security external role mapping create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityExternalRoleMappingCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := SecurityExternalRoleMappingCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security external role mapping create params
func (o *SecurityExternalRoleMappingCreateParams) WithTimeout(timeout time.Duration) *SecurityExternalRoleMappingCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security external role mapping create params
func (o *SecurityExternalRoleMappingCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security external role mapping create params
func (o *SecurityExternalRoleMappingCreateParams) WithContext(ctx context.Context) *SecurityExternalRoleMappingCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security external role mapping create params
func (o *SecurityExternalRoleMappingCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security external role mapping create params
func (o *SecurityExternalRoleMappingCreateParams) WithHTTPClient(client *http.Client) *SecurityExternalRoleMappingCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security external role mapping create params
func (o *SecurityExternalRoleMappingCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the security external role mapping create params
func (o *SecurityExternalRoleMappingCreateParams) WithInfo(info *models.SecurityExternalRoleMapping) *SecurityExternalRoleMappingCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security external role mapping create params
func (o *SecurityExternalRoleMappingCreateParams) SetInfo(info *models.SecurityExternalRoleMapping) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the security external role mapping create params
func (o *SecurityExternalRoleMappingCreateParams) WithReturnRecords(returnRecords *bool) *SecurityExternalRoleMappingCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security external role mapping create params
func (o *SecurityExternalRoleMappingCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityExternalRoleMappingCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
