// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityExternalRoleMappingDeleteCollectionReader is a Reader for the SecurityExternalRoleMappingDeleteCollection structure.
type SecurityExternalRoleMappingDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityExternalRoleMappingDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityExternalRoleMappingDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityExternalRoleMappingDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityExternalRoleMappingDeleteCollectionOK creates a SecurityExternalRoleMappingDeleteCollectionOK with default headers values
func NewSecurityExternalRoleMappingDeleteCollectionOK() *SecurityExternalRoleMappingDeleteCollectionOK {
	return &SecurityExternalRoleMappingDeleteCollectionOK{}
}

/*
SecurityExternalRoleMappingDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityExternalRoleMappingDeleteCollectionOK struct {
}

// IsSuccess returns true when this security external role mapping delete collection o k response has a 2xx status code
func (o *SecurityExternalRoleMappingDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security external role mapping delete collection o k response has a 3xx status code
func (o *SecurityExternalRoleMappingDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security external role mapping delete collection o k response has a 4xx status code
func (o *SecurityExternalRoleMappingDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security external role mapping delete collection o k response has a 5xx status code
func (o *SecurityExternalRoleMappingDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security external role mapping delete collection o k response a status code equal to that given
func (o *SecurityExternalRoleMappingDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security external role mapping delete collection o k response
func (o *SecurityExternalRoleMappingDeleteCollectionOK) Code() int {
	return 200
}

func (o *SecurityExternalRoleMappingDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /security/external-role-mappings][%d] securityExternalRoleMappingDeleteCollectionOK", 200)
}

func (o *SecurityExternalRoleMappingDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /security/external-role-mappings][%d] securityExternalRoleMappingDeleteCollectionOK", 200)
}

func (o *SecurityExternalRoleMappingDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityExternalRoleMappingDeleteCollectionDefault creates a SecurityExternalRoleMappingDeleteCollectionDefault with default headers values
func NewSecurityExternalRoleMappingDeleteCollectionDefault(code int) *SecurityExternalRoleMappingDeleteCollectionDefault {
	return &SecurityExternalRoleMappingDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
SecurityExternalRoleMappingDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityExternalRoleMappingDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security external role mapping delete collection default response has a 2xx status code
func (o *SecurityExternalRoleMappingDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security external role mapping delete collection default response has a 3xx status code
func (o *SecurityExternalRoleMappingDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security external role mapping delete collection default response has a 4xx status code
func (o *SecurityExternalRoleMappingDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security external role mapping delete collection default response has a 5xx status code
func (o *SecurityExternalRoleMappingDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security external role mapping delete collection default response a status code equal to that given
func (o *SecurityExternalRoleMappingDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security external role mapping delete collection default response
func (o *SecurityExternalRoleMappingDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityExternalRoleMappingDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/external-role-mappings][%d] security_external_role_mapping_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityExternalRoleMappingDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/external-role-mappings][%d] security_external_role_mapping_delete_collection default %s", o._statusCode, payload)
}

func (o *SecurityExternalRoleMappingDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityExternalRoleMappingDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityExternalRoleMappingDeleteCollectionBody security external role mapping delete collection body
swagger:model SecurityExternalRoleMappingDeleteCollectionBody
*/
type SecurityExternalRoleMappingDeleteCollectionBody struct {

	// security external role mapping response inline records
	SecurityExternalRoleMappingResponseInlineRecords []*models.SecurityExternalRoleMapping `json:"records,omitempty"`
}

// Validate validates this security external role mapping delete collection body
func (o *SecurityExternalRoleMappingDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSecurityExternalRoleMappingResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityExternalRoleMappingDeleteCollectionBody) validateSecurityExternalRoleMappingResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityExternalRoleMappingResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityExternalRoleMappingResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityExternalRoleMappingResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityExternalRoleMappingResponseInlineRecords[i] != nil {
			if err := o.SecurityExternalRoleMappingResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this security external role mapping delete collection body based on the context it is used
func (o *SecurityExternalRoleMappingDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSecurityExternalRoleMappingResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityExternalRoleMappingDeleteCollectionBody) contextValidateSecurityExternalRoleMappingResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityExternalRoleMappingResponseInlineRecords); i++ {

		if o.SecurityExternalRoleMappingResponseInlineRecords[i] != nil {
			if err := o.SecurityExternalRoleMappingResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityExternalRoleMappingDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityExternalRoleMappingDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityExternalRoleMappingDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
