// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewSecurityExternalRoleMappingDeleteParams creates a new SecurityExternalRoleMappingDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityExternalRoleMappingDeleteParams() *SecurityExternalRoleMappingDeleteParams {
	return &SecurityExternalRoleMappingDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityExternalRoleMappingDeleteParamsWithTimeout creates a new SecurityExternalRoleMappingDeleteParams object
// with the ability to set a timeout on a request.
func NewSecurityExternalRoleMappingDeleteParamsWithTimeout(timeout time.Duration) *SecurityExternalRoleMappingDeleteParams {
	return &SecurityExternalRoleMappingDeleteParams{
		timeout: timeout,
	}
}

// NewSecurityExternalRoleMappingDeleteParamsWithContext creates a new SecurityExternalRoleMappingDeleteParams object
// with the ability to set a context for a request.
func NewSecurityExternalRoleMappingDeleteParamsWithContext(ctx context.Context) *SecurityExternalRoleMappingDeleteParams {
	return &SecurityExternalRoleMappingDeleteParams{
		Context: ctx,
	}
}

// NewSecurityExternalRoleMappingDeleteParamsWithHTTPClient creates a new SecurityExternalRoleMappingDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityExternalRoleMappingDeleteParamsWithHTTPClient(client *http.Client) *SecurityExternalRoleMappingDeleteParams {
	return &SecurityExternalRoleMappingDeleteParams{
		HTTPClient: client,
	}
}

/*
SecurityExternalRoleMappingDeleteParams contains all the parameters to send to the API endpoint

	for the security external role mapping delete operation.

	Typically these are written to a http.Request.
*/
type SecurityExternalRoleMappingDeleteParams struct {

	/* ExternalRole.

	   External Identity provider role.
	*/
	ExternalRole string

	/* Provider.

	   Type of the external identity provider.
	*/
	Provider string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security external role mapping delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityExternalRoleMappingDeleteParams) WithDefaults() *SecurityExternalRoleMappingDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security external role mapping delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityExternalRoleMappingDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security external role mapping delete params
func (o *SecurityExternalRoleMappingDeleteParams) WithTimeout(timeout time.Duration) *SecurityExternalRoleMappingDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security external role mapping delete params
func (o *SecurityExternalRoleMappingDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security external role mapping delete params
func (o *SecurityExternalRoleMappingDeleteParams) WithContext(ctx context.Context) *SecurityExternalRoleMappingDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security external role mapping delete params
func (o *SecurityExternalRoleMappingDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security external role mapping delete params
func (o *SecurityExternalRoleMappingDeleteParams) WithHTTPClient(client *http.Client) *SecurityExternalRoleMappingDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security external role mapping delete params
func (o *SecurityExternalRoleMappingDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithExternalRole adds the externalRole to the security external role mapping delete params
func (o *SecurityExternalRoleMappingDeleteParams) WithExternalRole(externalRole string) *SecurityExternalRoleMappingDeleteParams {
	o.SetExternalRole(externalRole)
	return o
}

// SetExternalRole adds the externalRole to the security external role mapping delete params
func (o *SecurityExternalRoleMappingDeleteParams) SetExternalRole(externalRole string) {
	o.ExternalRole = externalRole
}

// WithProvider adds the provider to the security external role mapping delete params
func (o *SecurityExternalRoleMappingDeleteParams) WithProvider(provider string) *SecurityExternalRoleMappingDeleteParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the security external role mapping delete params
func (o *SecurityExternalRoleMappingDeleteParams) SetProvider(provider string) {
	o.Provider = provider
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityExternalRoleMappingDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param external_role
	if err := r.SetPathParam("external_role", o.ExternalRole); err != nil {
		return err
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
