// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityExternalRoleMappingGetParams creates a new SecurityExternalRoleMappingGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityExternalRoleMappingGetParams() *SecurityExternalRoleMappingGetParams {
	return &SecurityExternalRoleMappingGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityExternalRoleMappingGetParamsWithTimeout creates a new SecurityExternalRoleMappingGetParams object
// with the ability to set a timeout on a request.
func NewSecurityExternalRoleMappingGetParamsWithTimeout(timeout time.Duration) *SecurityExternalRoleMappingGetParams {
	return &SecurityExternalRoleMappingGetParams{
		timeout: timeout,
	}
}

// NewSecurityExternalRoleMappingGetParamsWithContext creates a new SecurityExternalRoleMappingGetParams object
// with the ability to set a context for a request.
func NewSecurityExternalRoleMappingGetParamsWithContext(ctx context.Context) *SecurityExternalRoleMappingGetParams {
	return &SecurityExternalRoleMappingGetParams{
		Context: ctx,
	}
}

// NewSecurityExternalRoleMappingGetParamsWithHTTPClient creates a new SecurityExternalRoleMappingGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityExternalRoleMappingGetParamsWithHTTPClient(client *http.Client) *SecurityExternalRoleMappingGetParams {
	return &SecurityExternalRoleMappingGetParams{
		HTTPClient: client,
	}
}

/*
SecurityExternalRoleMappingGetParams contains all the parameters to send to the API endpoint

	for the security external role mapping get operation.

	Typically these are written to a http.Request.
*/
type SecurityExternalRoleMappingGetParams struct {

	/* ExternalRole.

	   External Identity provider role.
	*/
	ExternalRole string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Provider.

	   Type of the external identity provider.
	*/
	Provider string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security external role mapping get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityExternalRoleMappingGetParams) WithDefaults() *SecurityExternalRoleMappingGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security external role mapping get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityExternalRoleMappingGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) WithTimeout(timeout time.Duration) *SecurityExternalRoleMappingGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) WithContext(ctx context.Context) *SecurityExternalRoleMappingGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) WithHTTPClient(client *http.Client) *SecurityExternalRoleMappingGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithExternalRole adds the externalRole to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) WithExternalRole(externalRole string) *SecurityExternalRoleMappingGetParams {
	o.SetExternalRole(externalRole)
	return o
}

// SetExternalRole adds the externalRole to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) SetExternalRole(externalRole string) {
	o.ExternalRole = externalRole
}

// WithFields adds the fields to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) WithFields(fields []string) *SecurityExternalRoleMappingGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithProvider adds the provider to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) WithProvider(provider string) *SecurityExternalRoleMappingGetParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the security external role mapping get params
func (o *SecurityExternalRoleMappingGetParams) SetProvider(provider string) {
	o.Provider = provider
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityExternalRoleMappingGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param external_role
	if err := r.SetPathParam("external_role", o.ExternalRole); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityExternalRoleMappingGet binds the parameter fields
func (o *SecurityExternalRoleMappingGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
