// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityExternalRoleMappingModifyCollectionReader is a Reader for the SecurityExternalRoleMappingModifyCollection structure.
type SecurityExternalRoleMappingModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityExternalRoleMappingModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityExternalRoleMappingModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityExternalRoleMappingModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityExternalRoleMappingModifyCollectionOK creates a SecurityExternalRoleMappingModifyCollectionOK with default headers values
func NewSecurityExternalRoleMappingModifyCollectionOK() *SecurityExternalRoleMappingModifyCollectionOK {
	return &SecurityExternalRoleMappingModifyCollectionOK{}
}

/*
SecurityExternalRoleMappingModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityExternalRoleMappingModifyCollectionOK struct {
	Payload *models.SecurityExternalRoleMapping
}

// IsSuccess returns true when this security external role mapping modify collection o k response has a 2xx status code
func (o *SecurityExternalRoleMappingModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security external role mapping modify collection o k response has a 3xx status code
func (o *SecurityExternalRoleMappingModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security external role mapping modify collection o k response has a 4xx status code
func (o *SecurityExternalRoleMappingModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security external role mapping modify collection o k response has a 5xx status code
func (o *SecurityExternalRoleMappingModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security external role mapping modify collection o k response a status code equal to that given
func (o *SecurityExternalRoleMappingModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security external role mapping modify collection o k response
func (o *SecurityExternalRoleMappingModifyCollectionOK) Code() int {
	return 200
}

func (o *SecurityExternalRoleMappingModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/external-role-mappings][%d] securityExternalRoleMappingModifyCollectionOK %s", 200, payload)
}

func (o *SecurityExternalRoleMappingModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/external-role-mappings][%d] securityExternalRoleMappingModifyCollectionOK %s", 200, payload)
}

func (o *SecurityExternalRoleMappingModifyCollectionOK) GetPayload() *models.SecurityExternalRoleMapping {
	return o.Payload
}

func (o *SecurityExternalRoleMappingModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityExternalRoleMapping)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityExternalRoleMappingModifyCollectionDefault creates a SecurityExternalRoleMappingModifyCollectionDefault with default headers values
func NewSecurityExternalRoleMappingModifyCollectionDefault(code int) *SecurityExternalRoleMappingModifyCollectionDefault {
	return &SecurityExternalRoleMappingModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SecurityExternalRoleMappingModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5636243 | Provided ONTAP role is not configured. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityExternalRoleMappingModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security external role mapping modify collection default response has a 2xx status code
func (o *SecurityExternalRoleMappingModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security external role mapping modify collection default response has a 3xx status code
func (o *SecurityExternalRoleMappingModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security external role mapping modify collection default response has a 4xx status code
func (o *SecurityExternalRoleMappingModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security external role mapping modify collection default response has a 5xx status code
func (o *SecurityExternalRoleMappingModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security external role mapping modify collection default response a status code equal to that given
func (o *SecurityExternalRoleMappingModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security external role mapping modify collection default response
func (o *SecurityExternalRoleMappingModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityExternalRoleMappingModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/external-role-mappings][%d] security_external_role_mapping_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityExternalRoleMappingModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/external-role-mappings][%d] security_external_role_mapping_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityExternalRoleMappingModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityExternalRoleMappingModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityExternalRoleMappingModifyCollectionBody security external role mapping modify collection body
swagger:model SecurityExternalRoleMappingModifyCollectionBody
*/
type SecurityExternalRoleMappingModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Any comment regarding this external-role-mapping entry.
	Comment *string `json:"comment,omitempty"`

	// External Identity provider role.
	ExternalRole *string `json:"external_role,omitempty"`

	// ontap role
	OntapRole *models.SecurityExternalRoleMappingInlineOntapRole `json:"ontap_role,omitempty"`

	// Type of the external identity provider.
	// Enum: ["adfs","auth0","entra","keycloak","basic"]
	Provider *string `json:"provider,omitempty"`

	// security external role mapping response inline records
	SecurityExternalRoleMappingResponseInlineRecords []*models.SecurityExternalRoleMapping `json:"records,omitempty"`

	// Date and time indicating when this external-role-mapping entry was created.
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this security external role mapping modify collection body
func (o *SecurityExternalRoleMappingModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOntapRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityExternalRoleMappingResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityExternalRoleMappingModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityExternalRoleMappingModifyCollectionBody) validateOntapRole(formats strfmt.Registry) error {
	if swag.IsZero(o.OntapRole) { // not required
		return nil
	}

	if o.OntapRole != nil {
		if err := o.OntapRole.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role")
			}
			return err
		}
	}

	return nil
}

var securityExternalRoleMappingModifyCollectionBodyTypeProviderPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["adfs","auth0","entra","keycloak","basic"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityExternalRoleMappingModifyCollectionBodyTypeProviderPropEnum = append(securityExternalRoleMappingModifyCollectionBodyTypeProviderPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SecurityExternalRoleMappingModifyCollectionBody
	// SecurityExternalRoleMappingModifyCollectionBody
	// provider
	// Provider
	// adfs
	// END DEBUGGING
	// SecurityExternalRoleMappingModifyCollectionBodyProviderAdfs captures enum value "adfs"
	SecurityExternalRoleMappingModifyCollectionBodyProviderAdfs string = "adfs"

	// BEGIN DEBUGGING
	// SecurityExternalRoleMappingModifyCollectionBody
	// SecurityExternalRoleMappingModifyCollectionBody
	// provider
	// Provider
	// auth0
	// END DEBUGGING
	// SecurityExternalRoleMappingModifyCollectionBodyProviderAuth0 captures enum value "auth0"
	SecurityExternalRoleMappingModifyCollectionBodyProviderAuth0 string = "auth0"

	// BEGIN DEBUGGING
	// SecurityExternalRoleMappingModifyCollectionBody
	// SecurityExternalRoleMappingModifyCollectionBody
	// provider
	// Provider
	// entra
	// END DEBUGGING
	// SecurityExternalRoleMappingModifyCollectionBodyProviderEntra captures enum value "entra"
	SecurityExternalRoleMappingModifyCollectionBodyProviderEntra string = "entra"

	// BEGIN DEBUGGING
	// SecurityExternalRoleMappingModifyCollectionBody
	// SecurityExternalRoleMappingModifyCollectionBody
	// provider
	// Provider
	// keycloak
	// END DEBUGGING
	// SecurityExternalRoleMappingModifyCollectionBodyProviderKeycloak captures enum value "keycloak"
	SecurityExternalRoleMappingModifyCollectionBodyProviderKeycloak string = "keycloak"

	// BEGIN DEBUGGING
	// SecurityExternalRoleMappingModifyCollectionBody
	// SecurityExternalRoleMappingModifyCollectionBody
	// provider
	// Provider
	// basic
	// END DEBUGGING
	// SecurityExternalRoleMappingModifyCollectionBodyProviderBasic captures enum value "basic"
	SecurityExternalRoleMappingModifyCollectionBodyProviderBasic string = "basic"
)

// prop value enum
func (o *SecurityExternalRoleMappingModifyCollectionBody) validateProviderEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityExternalRoleMappingModifyCollectionBodyTypeProviderPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SecurityExternalRoleMappingModifyCollectionBody) validateProvider(formats strfmt.Registry) error {
	if swag.IsZero(o.Provider) { // not required
		return nil
	}

	// value enum
	if err := o.validateProviderEnum("info"+"."+"provider", "body", *o.Provider); err != nil {
		return err
	}

	return nil
}

func (o *SecurityExternalRoleMappingModifyCollectionBody) validateSecurityExternalRoleMappingResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityExternalRoleMappingResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityExternalRoleMappingResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityExternalRoleMappingResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityExternalRoleMappingResponseInlineRecords[i] != nil {
			if err := o.SecurityExternalRoleMappingResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SecurityExternalRoleMappingModifyCollectionBody) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security external role mapping modify collection body based on the context it is used
func (o *SecurityExternalRoleMappingModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOntapRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSecurityExternalRoleMappingResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityExternalRoleMappingModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityExternalRoleMappingModifyCollectionBody) contextValidateOntapRole(ctx context.Context, formats strfmt.Registry) error {

	if o.OntapRole != nil {
		if err := o.OntapRole.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityExternalRoleMappingModifyCollectionBody) contextValidateSecurityExternalRoleMappingResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityExternalRoleMappingResponseInlineRecords); i++ {

		if o.SecurityExternalRoleMappingResponseInlineRecords[i] != nil {
			if err := o.SecurityExternalRoleMappingResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *SecurityExternalRoleMappingModifyCollectionBody) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityExternalRoleMappingModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityExternalRoleMappingModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityExternalRoleMappingModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityExternalRoleMappingInlineOntapRole ONTAP role to map with the external identity role.
swagger:model security_external_role_mapping_inline_ontap_role
*/
type SecurityExternalRoleMappingInlineOntapRole struct {

	// links
	Links *models.SecurityExternalRoleMappingInlineOntapRoleInlineLinks `json:"_links,omitempty"`

	// Role name
	// Example: admin
	Name *string `json:"name,omitempty"`
}

// Validate validates this security external role mapping inline ontap role
func (o *SecurityExternalRoleMappingInlineOntapRole) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityExternalRoleMappingInlineOntapRole) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security external role mapping inline ontap role based on the context it is used
func (o *SecurityExternalRoleMappingInlineOntapRole) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityExternalRoleMappingInlineOntapRole) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityExternalRoleMappingInlineOntapRole) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityExternalRoleMappingInlineOntapRole) UnmarshalBinary(b []byte) error {
	var res SecurityExternalRoleMappingInlineOntapRole
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityExternalRoleMappingInlineOntapRoleInlineLinks security external role mapping inline ontap role inline links
swagger:model security_external_role_mapping_inline_ontap_role_inline__links
*/
type SecurityExternalRoleMappingInlineOntapRoleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security external role mapping inline ontap role inline links
func (o *SecurityExternalRoleMappingInlineOntapRoleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityExternalRoleMappingInlineOntapRoleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security external role mapping inline ontap role inline links based on the context it is used
func (o *SecurityExternalRoleMappingInlineOntapRoleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityExternalRoleMappingInlineOntapRoleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "ontap_role" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityExternalRoleMappingInlineOntapRoleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityExternalRoleMappingInlineOntapRoleInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityExternalRoleMappingInlineOntapRoleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
