// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityGroupCollectionGetParams creates a new SecurityGroupCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityGroupCollectionGetParams() *SecurityGroupCollectionGetParams {
	return &SecurityGroupCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityGroupCollectionGetParamsWithTimeout creates a new SecurityGroupCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSecurityGroupCollectionGetParamsWithTimeout(timeout time.Duration) *SecurityGroupCollectionGetParams {
	return &SecurityGroupCollectionGetParams{
		timeout: timeout,
	}
}

// NewSecurityGroupCollectionGetParamsWithContext creates a new SecurityGroupCollectionGetParams object
// with the ability to set a context for a request.
func NewSecurityGroupCollectionGetParamsWithContext(ctx context.Context) *SecurityGroupCollectionGetParams {
	return &SecurityGroupCollectionGetParams{
		Context: ctx,
	}
}

// NewSecurityGroupCollectionGetParamsWithHTTPClient creates a new SecurityGroupCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityGroupCollectionGetParamsWithHTTPClient(client *http.Client) *SecurityGroupCollectionGetParams {
	return &SecurityGroupCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SecurityGroupCollectionGetParams contains all the parameters to send to the API endpoint

	for the security group collection get operation.

	Typically these are written to a http.Request.
*/
type SecurityGroupCollectionGetParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security group collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityGroupCollectionGetParams) WithDefaults() *SecurityGroupCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security group collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityGroupCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SecurityGroupCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithTimeout(timeout time.Duration) *SecurityGroupCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithContext(ctx context.Context) *SecurityGroupCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithHTTPClient(client *http.Client) *SecurityGroupCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithComment(comment *string) *SecurityGroupCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithCreateTime adds the createTime to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithCreateTime(createTime *string) *SecurityGroupCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithFields adds the fields to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithFields(fields []string) *SecurityGroupCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithID adds the id to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithID(id *int64) *SecurityGroupCollectionGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetID(id *int64) {
	o.ID = id
}

// WithMaxRecords adds the maxRecords to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithMaxRecords(maxRecords *int64) *SecurityGroupCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithName(name *string) *SecurityGroupCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithOrderBy(orderBy []string) *SecurityGroupCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOwnerName adds the ownerName to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithOwnerName(ownerName *string) *SecurityGroupCollectionGetParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithOwnerUUID(ownerUUID *string) *SecurityGroupCollectionGetParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithReturnRecords(returnRecords *bool) *SecurityGroupCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SecurityGroupCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithScope(scope *string) *SecurityGroupCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithType adds the typeVar to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithType(typeVar *string) *SecurityGroupCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the security group collection get params
func (o *SecurityGroupCollectionGetParams) WithUUID(uuid *string) *SecurityGroupCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the security group collection get params
func (o *SecurityGroupCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityGroupCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSecurityGroupCollectionGet binds the parameter fields
func (o *SecurityGroupCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSecurityGroupCollectionGet binds the parameter order_by
func (o *SecurityGroupCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
