// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityGroupCollectionGetReader is a Reader for the SecurityGroupCollectionGet structure.
type SecurityGroupCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityGroupCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityGroupCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityGroupCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityGroupCollectionGetOK creates a SecurityGroupCollectionGetOK with default headers values
func NewSecurityGroupCollectionGetOK() *SecurityGroupCollectionGetOK {
	return &SecurityGroupCollectionGetOK{}
}

/*
SecurityGroupCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SecurityGroupCollectionGetOK struct {
	Payload *models.SecurityGroupResponse
}

// IsSuccess returns true when this security group collection get o k response has a 2xx status code
func (o *SecurityGroupCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security group collection get o k response has a 3xx status code
func (o *SecurityGroupCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security group collection get o k response has a 4xx status code
func (o *SecurityGroupCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security group collection get o k response has a 5xx status code
func (o *SecurityGroupCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security group collection get o k response a status code equal to that given
func (o *SecurityGroupCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security group collection get o k response
func (o *SecurityGroupCollectionGetOK) Code() int {
	return 200
}

func (o *SecurityGroupCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/groups][%d] securityGroupCollectionGetOK %s", 200, payload)
}

func (o *SecurityGroupCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/groups][%d] securityGroupCollectionGetOK %s", 200, payload)
}

func (o *SecurityGroupCollectionGetOK) GetPayload() *models.SecurityGroupResponse {
	return o.Payload
}

func (o *SecurityGroupCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SecurityGroupResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityGroupCollectionGetDefault creates a SecurityGroupCollectionGetDefault with default headers values
func NewSecurityGroupCollectionGetDefault(code int) *SecurityGroupCollectionGetDefault {
	return &SecurityGroupCollectionGetDefault{
		_statusCode: code,
	}
}

/*
SecurityGroupCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type SecurityGroupCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security group collection get default response has a 2xx status code
func (o *SecurityGroupCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security group collection get default response has a 3xx status code
func (o *SecurityGroupCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security group collection get default response has a 4xx status code
func (o *SecurityGroupCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security group collection get default response has a 5xx status code
func (o *SecurityGroupCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security group collection get default response a status code equal to that given
func (o *SecurityGroupCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security group collection get default response
func (o *SecurityGroupCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SecurityGroupCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/groups][%d] security_group_collection_get default %s", o._statusCode, payload)
}

func (o *SecurityGroupCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /security/groups][%d] security_group_collection_get default %s", o._statusCode, payload)
}

func (o *SecurityGroupCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityGroupCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
