// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewSecurityGroupCreateParams creates a new SecurityGroupCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityGroupCreateParams() *SecurityGroupCreateParams {
	return &SecurityGroupCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityGroupCreateParamsWithTimeout creates a new SecurityGroupCreateParams object
// with the ability to set a timeout on a request.
func NewSecurityGroupCreateParamsWithTimeout(timeout time.Duration) *SecurityGroupCreateParams {
	return &SecurityGroupCreateParams{
		timeout: timeout,
	}
}

// NewSecurityGroupCreateParamsWithContext creates a new SecurityGroupCreateParams object
// with the ability to set a context for a request.
func NewSecurityGroupCreateParamsWithContext(ctx context.Context) *SecurityGroupCreateParams {
	return &SecurityGroupCreateParams{
		Context: ctx,
	}
}

// NewSecurityGroupCreateParamsWithHTTPClient creates a new SecurityGroupCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityGroupCreateParamsWithHTTPClient(client *http.Client) *SecurityGroupCreateParams {
	return &SecurityGroupCreateParams{
		HTTPClient: client,
	}
}

/*
SecurityGroupCreateParams contains all the parameters to send to the API endpoint

	for the security group create operation.

	Typically these are written to a http.Request.
*/
type SecurityGroupCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.SecurityGroup

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security group create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityGroupCreateParams) WithDefaults() *SecurityGroupCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security group create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityGroupCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := SecurityGroupCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security group create params
func (o *SecurityGroupCreateParams) WithTimeout(timeout time.Duration) *SecurityGroupCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security group create params
func (o *SecurityGroupCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security group create params
func (o *SecurityGroupCreateParams) WithContext(ctx context.Context) *SecurityGroupCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security group create params
func (o *SecurityGroupCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security group create params
func (o *SecurityGroupCreateParams) WithHTTPClient(client *http.Client) *SecurityGroupCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security group create params
func (o *SecurityGroupCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the security group create params
func (o *SecurityGroupCreateParams) WithInfo(info *models.SecurityGroup) *SecurityGroupCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security group create params
func (o *SecurityGroupCreateParams) SetInfo(info *models.SecurityGroup) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the security group create params
func (o *SecurityGroupCreateParams) WithReturnRecords(returnRecords *bool) *SecurityGroupCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security group create params
func (o *SecurityGroupCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityGroupCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
