// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityGroupCreateReader is a Reader for the SecurityGroupCreate structure.
type SecurityGroupCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityGroupCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSecurityGroupCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityGroupCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityGroupCreateCreated creates a SecurityGroupCreateCreated with default headers values
func NewSecurityGroupCreateCreated() *SecurityGroupCreateCreated {
	return &SecurityGroupCreateCreated{}
}

/*
SecurityGroupCreateCreated describes a response with status code 201, with default header values.

Created
*/
type SecurityGroupCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SecurityGroupResponse
}

// IsSuccess returns true when this security group create created response has a 2xx status code
func (o *SecurityGroupCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security group create created response has a 3xx status code
func (o *SecurityGroupCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security group create created response has a 4xx status code
func (o *SecurityGroupCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this security group create created response has a 5xx status code
func (o *SecurityGroupCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this security group create created response a status code equal to that given
func (o *SecurityGroupCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the security group create created response
func (o *SecurityGroupCreateCreated) Code() int {
	return 201
}

func (o *SecurityGroupCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/groups][%d] securityGroupCreateCreated %s", 201, payload)
}

func (o *SecurityGroupCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/groups][%d] securityGroupCreateCreated %s", 201, payload)
}

func (o *SecurityGroupCreateCreated) GetPayload() *models.SecurityGroupResponse {
	return o.Payload
}

func (o *SecurityGroupCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SecurityGroupResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecurityGroupCreateDefault creates a SecurityGroupCreateDefault with default headers values
func NewSecurityGroupCreateDefault(code int) *SecurityGroupCreateDefault {
	return &SecurityGroupCreateDefault{
		_statusCode: code,
	}
}

/*
	SecurityGroupCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5636231 | Failed to create the group because the maximum number of allowed group IDs has been reached. |
| 5636232 | The group name does not satisfy the length requirement. |
| 5636235 | Duplicate UUID. |
| 5636244 | Failed to delete the group because it is part of the group role mapping configuration. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityGroupCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security group create default response has a 2xx status code
func (o *SecurityGroupCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security group create default response has a 3xx status code
func (o *SecurityGroupCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security group create default response has a 4xx status code
func (o *SecurityGroupCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security group create default response has a 5xx status code
func (o *SecurityGroupCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security group create default response a status code equal to that given
func (o *SecurityGroupCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security group create default response
func (o *SecurityGroupCreateDefault) Code() int {
	return o._statusCode
}

func (o *SecurityGroupCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/groups][%d] security_group_create default %s", o._statusCode, payload)
}

func (o *SecurityGroupCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /security/groups][%d] security_group_create default %s", o._statusCode, payload)
}

func (o *SecurityGroupCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityGroupCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
