// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewSecurityGroupDeleteParams creates a new SecurityGroupDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityGroupDeleteParams() *SecurityGroupDeleteParams {
	return &SecurityGroupDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityGroupDeleteParamsWithTimeout creates a new SecurityGroupDeleteParams object
// with the ability to set a timeout on a request.
func NewSecurityGroupDeleteParamsWithTimeout(timeout time.Duration) *SecurityGroupDeleteParams {
	return &SecurityGroupDeleteParams{
		timeout: timeout,
	}
}

// NewSecurityGroupDeleteParamsWithContext creates a new SecurityGroupDeleteParams object
// with the ability to set a context for a request.
func NewSecurityGroupDeleteParamsWithContext(ctx context.Context) *SecurityGroupDeleteParams {
	return &SecurityGroupDeleteParams{
		Context: ctx,
	}
}

// NewSecurityGroupDeleteParamsWithHTTPClient creates a new SecurityGroupDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityGroupDeleteParamsWithHTTPClient(client *http.Client) *SecurityGroupDeleteParams {
	return &SecurityGroupDeleteParams{
		HTTPClient: client,
	}
}

/*
SecurityGroupDeleteParams contains all the parameters to send to the API endpoint

	for the security group delete operation.

	Typically these are written to a http.Request.
*/
type SecurityGroupDeleteParams struct {

	/* Name.

	   Group name.
	*/
	Name string

	/* OwnerUUID.

	   Group owner. Used to identify a cluster or an SVM.
	*/
	OwnerUUID string

	/* Type.

	   Group type.
	*/
	Type string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security group delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityGroupDeleteParams) WithDefaults() *SecurityGroupDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security group delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityGroupDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the security group delete params
func (o *SecurityGroupDeleteParams) WithTimeout(timeout time.Duration) *SecurityGroupDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security group delete params
func (o *SecurityGroupDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security group delete params
func (o *SecurityGroupDeleteParams) WithContext(ctx context.Context) *SecurityGroupDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security group delete params
func (o *SecurityGroupDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security group delete params
func (o *SecurityGroupDeleteParams) WithHTTPClient(client *http.Client) *SecurityGroupDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security group delete params
func (o *SecurityGroupDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the security group delete params
func (o *SecurityGroupDeleteParams) WithName(name string) *SecurityGroupDeleteParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the security group delete params
func (o *SecurityGroupDeleteParams) SetName(name string) {
	o.Name = name
}

// WithOwnerUUID adds the ownerUUID to the security group delete params
func (o *SecurityGroupDeleteParams) WithOwnerUUID(ownerUUID string) *SecurityGroupDeleteParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the security group delete params
func (o *SecurityGroupDeleteParams) SetOwnerUUID(ownerUUID string) {
	o.OwnerUUID = ownerUUID
}

// WithType adds the typeVar to the security group delete params
func (o *SecurityGroupDeleteParams) WithType(typeVar string) *SecurityGroupDeleteParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the security group delete params
func (o *SecurityGroupDeleteParams) SetType(typeVar string) {
	o.Type = typeVar
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityGroupDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param owner.uuid
	if err := r.SetPathParam("owner.uuid", o.OwnerUUID); err != nil {
		return err
	}

	// path param type
	if err := r.SetPathParam("type", o.Type); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
