// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityGroupDeleteReader is a Reader for the SecurityGroupDelete structure.
type SecurityGroupDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityGroupDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityGroupDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityGroupDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityGroupDeleteOK creates a SecurityGroupDeleteOK with default headers values
func NewSecurityGroupDeleteOK() *SecurityGroupDeleteOK {
	return &SecurityGroupDeleteOK{}
}

/*
SecurityGroupDeleteOK describes a response with status code 200, with default header values.

OK
*/
type SecurityGroupDeleteOK struct {
}

// IsSuccess returns true when this security group delete o k response has a 2xx status code
func (o *SecurityGroupDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security group delete o k response has a 3xx status code
func (o *SecurityGroupDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security group delete o k response has a 4xx status code
func (o *SecurityGroupDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security group delete o k response has a 5xx status code
func (o *SecurityGroupDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security group delete o k response a status code equal to that given
func (o *SecurityGroupDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security group delete o k response
func (o *SecurityGroupDeleteOK) Code() int {
	return 200
}

func (o *SecurityGroupDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /security/groups/{owner.uuid}/{name}/{type}][%d] securityGroupDeleteOK", 200)
}

func (o *SecurityGroupDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /security/groups/{owner.uuid}/{name}/{type}][%d] securityGroupDeleteOK", 200)
}

func (o *SecurityGroupDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityGroupDeleteDefault creates a SecurityGroupDeleteDefault with default headers values
func NewSecurityGroupDeleteDefault(code int) *SecurityGroupDeleteDefault {
	return &SecurityGroupDeleteDefault{
		_statusCode: code,
	}
}

/*
	SecurityGroupDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5636244 | The group is part of the role mapping configuration. Delete the mapping first and then delete the group. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityGroupDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security group delete default response has a 2xx status code
func (o *SecurityGroupDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security group delete default response has a 3xx status code
func (o *SecurityGroupDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security group delete default response has a 4xx status code
func (o *SecurityGroupDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security group delete default response has a 5xx status code
func (o *SecurityGroupDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security group delete default response a status code equal to that given
func (o *SecurityGroupDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security group delete default response
func (o *SecurityGroupDeleteDefault) Code() int {
	return o._statusCode
}

func (o *SecurityGroupDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/groups/{owner.uuid}/{name}/{type}][%d] security_group_delete default %s", o._statusCode, payload)
}

func (o *SecurityGroupDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /security/groups/{owner.uuid}/{name}/{type}][%d] security_group_delete default %s", o._statusCode, payload)
}

func (o *SecurityGroupDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityGroupDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
