// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSecurityGroupModifyCollectionParams creates a new SecurityGroupModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSecurityGroupModifyCollectionParams() *SecurityGroupModifyCollectionParams {
	return &SecurityGroupModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSecurityGroupModifyCollectionParamsWithTimeout creates a new SecurityGroupModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewSecurityGroupModifyCollectionParamsWithTimeout(timeout time.Duration) *SecurityGroupModifyCollectionParams {
	return &SecurityGroupModifyCollectionParams{
		timeout: timeout,
	}
}

// NewSecurityGroupModifyCollectionParamsWithContext creates a new SecurityGroupModifyCollectionParams object
// with the ability to set a context for a request.
func NewSecurityGroupModifyCollectionParamsWithContext(ctx context.Context) *SecurityGroupModifyCollectionParams {
	return &SecurityGroupModifyCollectionParams{
		Context: ctx,
	}
}

// NewSecurityGroupModifyCollectionParamsWithHTTPClient creates a new SecurityGroupModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSecurityGroupModifyCollectionParamsWithHTTPClient(client *http.Client) *SecurityGroupModifyCollectionParams {
	return &SecurityGroupModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
SecurityGroupModifyCollectionParams contains all the parameters to send to the API endpoint

	for the security group modify collection operation.

	Typically these are written to a http.Request.
*/
type SecurityGroupModifyCollectionParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* Info.

	   Info specification
	*/
	Info SecurityGroupModifyCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OwnerName.

	   Filter by owner.name
	*/
	OwnerName *string

	/* OwnerUUID.

	   Filter by owner.uuid
	*/
	OwnerUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the security group modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityGroupModifyCollectionParams) WithDefaults() *SecurityGroupModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the security group modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SecurityGroupModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SecurityGroupModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithTimeout(timeout time.Duration) *SecurityGroupModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithContext(ctx context.Context) *SecurityGroupModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithHTTPClient(client *http.Client) *SecurityGroupModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithComment(comment *string) *SecurityGroupModifyCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SecurityGroupModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreateTime adds the createTime to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithCreateTime(createTime *string) *SecurityGroupModifyCollectionParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithID adds the id to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithID(id *int64) *SecurityGroupModifyCollectionParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetID(id *int64) {
	o.ID = id
}

// WithInfo adds the info to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithInfo(info SecurityGroupModifyCollectionBody) *SecurityGroupModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetInfo(info SecurityGroupModifyCollectionBody) {
	o.Info = info
}

// WithName adds the name to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithName(name *string) *SecurityGroupModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOwnerName adds the ownerName to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithOwnerName(ownerName *string) *SecurityGroupModifyCollectionParams {
	o.SetOwnerName(ownerName)
	return o
}

// SetOwnerName adds the ownerName to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetOwnerName(ownerName *string) {
	o.OwnerName = ownerName
}

// WithOwnerUUID adds the ownerUUID to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithOwnerUUID(ownerUUID *string) *SecurityGroupModifyCollectionParams {
	o.SetOwnerUUID(ownerUUID)
	return o
}

// SetOwnerUUID adds the ownerUuid to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetOwnerUUID(ownerUUID *string) {
	o.OwnerUUID = ownerUUID
}

// WithReturnRecords adds the returnRecords to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithReturnRecords(returnRecords *bool) *SecurityGroupModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *SecurityGroupModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithScope(scope *string) *SecurityGroupModifyCollectionParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSerialRecords adds the serialRecords to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithSerialRecords(serialRecords *bool) *SecurityGroupModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithType adds the typeVar to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithType(typeVar *string) *SecurityGroupModifyCollectionParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) WithUUID(uuid *string) *SecurityGroupModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the security group modify collection params
func (o *SecurityGroupModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *SecurityGroupModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OwnerName != nil {

		// query param owner.name
		var qrOwnerName string

		if o.OwnerName != nil {
			qrOwnerName = *o.OwnerName
		}
		qOwnerName := qrOwnerName
		if qOwnerName != "" {

			if err := r.SetQueryParam("owner.name", qOwnerName); err != nil {
				return err
			}
		}
	}

	if o.OwnerUUID != nil {

		// query param owner.uuid
		var qrOwnerUUID string

		if o.OwnerUUID != nil {
			qrOwnerUUID = *o.OwnerUUID
		}
		qOwnerUUID := qrOwnerUUID
		if qOwnerUUID != "" {

			if err := r.SetQueryParam("owner.uuid", qOwnerUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
