// Code generated by go-swagger; DO NOT EDIT.

package security

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SecurityGroupModifyCollectionReader is a Reader for the SecurityGroupModifyCollection structure.
type SecurityGroupModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecurityGroupModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecurityGroupModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSecurityGroupModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSecurityGroupModifyCollectionOK creates a SecurityGroupModifyCollectionOK with default headers values
func NewSecurityGroupModifyCollectionOK() *SecurityGroupModifyCollectionOK {
	return &SecurityGroupModifyCollectionOK{}
}

/*
SecurityGroupModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SecurityGroupModifyCollectionOK struct {
}

// IsSuccess returns true when this security group modify collection o k response has a 2xx status code
func (o *SecurityGroupModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this security group modify collection o k response has a 3xx status code
func (o *SecurityGroupModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this security group modify collection o k response has a 4xx status code
func (o *SecurityGroupModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this security group modify collection o k response has a 5xx status code
func (o *SecurityGroupModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this security group modify collection o k response a status code equal to that given
func (o *SecurityGroupModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the security group modify collection o k response
func (o *SecurityGroupModifyCollectionOK) Code() int {
	return 200
}

func (o *SecurityGroupModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /security/groups][%d] securityGroupModifyCollectionOK", 200)
}

func (o *SecurityGroupModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /security/groups][%d] securityGroupModifyCollectionOK", 200)
}

func (o *SecurityGroupModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecurityGroupModifyCollectionDefault creates a SecurityGroupModifyCollectionDefault with default headers values
func NewSecurityGroupModifyCollectionDefault(code int) *SecurityGroupModifyCollectionDefault {
	return &SecurityGroupModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	SecurityGroupModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5636235 | Duplicate UUID. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SecurityGroupModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this security group modify collection default response has a 2xx status code
func (o *SecurityGroupModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this security group modify collection default response has a 3xx status code
func (o *SecurityGroupModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this security group modify collection default response has a 4xx status code
func (o *SecurityGroupModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this security group modify collection default response has a 5xx status code
func (o *SecurityGroupModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this security group modify collection default response a status code equal to that given
func (o *SecurityGroupModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the security group modify collection default response
func (o *SecurityGroupModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SecurityGroupModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/groups][%d] security_group_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityGroupModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /security/groups][%d] security_group_modify_collection default %s", o._statusCode, payload)
}

func (o *SecurityGroupModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SecurityGroupModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecurityGroupModifyCollectionBody security group modify collection body
swagger:model SecurityGroupModifyCollectionBody
*/
type SecurityGroupModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// Any comment regarding this group entry.
	// Example: Azure Group
	Comment *string `json:"comment,omitempty"`

	// Date and time indicating when this group entry was created.
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Group ID which is unique per group across the system. It is a read-only field and it automatically assigns the next available unique number.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Group name.
	// Example: AzureGroup1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// owner
	Owner *models.SecurityGroupInlineOwner `json:"owner,omitempty"`

	// Scope of the entity. Set to "cluster" for cluster owned objects and to "svm" for SVM owned objects.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`

	// security group response inline records
	SecurityGroupResponseInlineRecords []*models.SecurityGroup `json:"records,omitempty"`

	// Group type.
	// Example: entra
	// Enum: ["entra"]
	Type *string `json:"type,omitempty"`

	// Group UUID from external Active Directory.
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this security group modify collection body
func (o *SecurityGroupModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurityGroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityGroupModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityGroupModifyCollectionBody) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(o.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"create_time", "body", "date-time", o.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *SecurityGroupModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 64); err != nil {
		return err
	}

	return nil
}

func (o *SecurityGroupModifyCollectionBody) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(o.Owner) { // not required
		return nil
	}

	if o.Owner != nil {
		if err := o.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

var securityGroupModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityGroupModifyCollectionBodyTypeScopePropEnum = append(securityGroupModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SecurityGroupModifyCollectionBody
	// SecurityGroupModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// SecurityGroupModifyCollectionBodyScopeCluster captures enum value "cluster"
	SecurityGroupModifyCollectionBodyScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// SecurityGroupModifyCollectionBody
	// SecurityGroupModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// SecurityGroupModifyCollectionBodyScopeSvm captures enum value "svm"
	SecurityGroupModifyCollectionBodyScopeSvm string = "svm"
)

// prop value enum
func (o *SecurityGroupModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityGroupModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SecurityGroupModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *SecurityGroupModifyCollectionBody) validateSecurityGroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurityGroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SecurityGroupResponseInlineRecords); i++ {
		if swag.IsZero(o.SecurityGroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SecurityGroupResponseInlineRecords[i] != nil {
			if err := o.SecurityGroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var securityGroupModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["entra"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		securityGroupModifyCollectionBodyTypeTypePropEnum = append(securityGroupModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// SecurityGroupModifyCollectionBody
	// SecurityGroupModifyCollectionBody
	// type
	// Type
	// entra
	// END DEBUGGING
	// SecurityGroupModifyCollectionBodyTypeEntra captures enum value "entra"
	SecurityGroupModifyCollectionBodyTypeEntra string = "entra"
)

// prop value enum
func (o *SecurityGroupModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, securityGroupModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *SecurityGroupModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *SecurityGroupModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this security group modify collection body based on the context it is used
func (o *SecurityGroupModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSecurityGroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityGroupModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityGroupModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *SecurityGroupModifyCollectionBody) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *SecurityGroupModifyCollectionBody) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if o.Owner != nil {
		if err := o.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner")
			}
			return err
		}
	}

	return nil
}

func (o *SecurityGroupModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *SecurityGroupModifyCollectionBody) contextValidateSecurityGroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SecurityGroupResponseInlineRecords); i++ {

		if o.SecurityGroupResponseInlineRecords[i] != nil {
			if err := o.SecurityGroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityGroupModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityGroupModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res SecurityGroupModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityGroupInlineOwner Group owner. Used to identify a cluster or an SVM.
swagger:model security_group_inline_owner
*/
type SecurityGroupInlineOwner struct {

	// links
	Links *models.SecurityGroupInlineOwnerInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this security group inline owner
func (o *SecurityGroupInlineOwner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityGroupInlineOwner) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security group inline owner based on the context it is used
func (o *SecurityGroupInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityGroupInlineOwner) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityGroupInlineOwner) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityGroupInlineOwner) UnmarshalBinary(b []byte) error {
	var res SecurityGroupInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecurityGroupInlineOwnerInlineLinks security group inline owner inline links
swagger:model security_group_inline_owner_inline__links
*/
type SecurityGroupInlineOwnerInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this security group inline owner inline links
func (o *SecurityGroupInlineOwnerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityGroupInlineOwnerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this security group inline owner inline links based on the context it is used
func (o *SecurityGroupInlineOwnerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SecurityGroupInlineOwnerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "owner" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SecurityGroupInlineOwnerInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecurityGroupInlineOwnerInlineLinks) UnmarshalBinary(b []byte) error {
	var res SecurityGroupInlineOwnerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
